// License: http://creativecommons.org/licenses/by-nc-sa/2.0/

var gSyncMarksService = {
  syncMarks:null,

////////////////////////////////////////////////////////////////////////////////

  // static call to OnLoad event
  onload:function() {
    // only sync when the first window is loading
    if (countBrowserWindows() == 0) {
      gSyncMarksService.onLoad();
    }
  },

////////////////////////////////////////////////////////////////////////////////

  // static call to OnClose event
  onclose:function() {
    // only sync when the last window is closing
    if (countBrowserWindows() == 1) {
      gSyncMarksService.onClose();
    }
  },

////////////////////////////////////////////////////////////////////////////////

  // method called when extension is loaded
  onLoad:function() {
    this.syncMarks = new SyncMarks();
    if (this.syncMarks.settings.syncOnLoad) {
      this.syncMarks.sync();
    }
  },

////////////////////////////////////////////////////////////////////////////////

  // method called when extension is unloaded
  onClose:function() {
    if (this.syncMarks.settings.syncOnExit) {
      this.syncMarks.sync();
    }
  },

////////////////////////////////////////////////////////////////////////////////
};

function countBrowserWindows() {
  var wm = Components.classes['@mozilla.org/appshell/window-mediator;1']
           .getService(Components.interfaces.nsIWindowMediator);

  var browsers = wm.getZOrderDOMWindowEnumerator('navigator:browser', true);

  // get the first open browser
  var count = 0;
  while (browsers.hasMoreElements()) {
    var browser = browsers.getNext();
    count++;
  }

  return count;
}

//Event Listeners
window.addEventListener("load", gSyncMarksService.onload, false);
window.addEventListener("close", gSyncMarksService.onclose, false);
