// License: http://creativecommons.org/licenses/by-nc-sa/2.0/

function SyncMarksHandlerXML(syncMarks) {
  this._init(syncMarks);
}

////////////////////////////////////////////////////////////////////////////////

SyncMarksHandlerXML.prototype = {
  _syncMarks:null,
  _marks:null,
  _doc:null,

////////////////////////////////////////////////////////////////////////////////
// Initialize the bookmarks iterator.

  _init:function(syncMarks) {
    this._syncMarks = syncMarks;
    this._marks = this._syncMarks.bookmarks;
  },

////////////////////////////////////////////////////////////////////////////////

  get _pid() { return "+//IDN python.org//DTD XML Bookmark Exchange Language 1.0//EN//XML"; },
  get _sid() { return "http://pyxml.sourceforge.net/topics/dtds/xbel-1.0.dtd"; },
  get _owner() { return "Mozilla"; },

////////////////////////////////////////////////////////////////////////////////
// The user's bookmarks represented as an XML document.

  get document() {
    var doctype = document.implementation.createDocumentType("xbel", this._pid, this._sid);
    this._doc = document.implementation.createDocument("", "xbel", doctype);

    var xbel = this._doc.documentElement;
    var bmarks = this._marks.bookmarks;
    xbel.appendChild(this._createTitleElement(bmarks));
    xbel.appendChild(this._createDescElement(bmarks));
    this._appendBookmarks(xbel, bmarks);

    return this._doc;
  },


////////////////////////////////////////////////////////////////////////////////
// The specified bookmarks represented as an XML document.

  _appendBookmarks:function(element, bmarks) {
    // walk through all the bookmarks and do their thang...
    for (var idx = 0; idx < bmarks.length; idx++) {
      switch (bmarks[idx].type) {
        // if the bookmark is a folder, set its children...
        case "Folder":
        case "IEFavoriteFolder":
        case "PersonalToolbarFolder":
          var folder = this._createFolderElement(bmarks[idx]);
          if (bmarks[idx].children != null) {
            this._appendBookmarks(folder, bmarks[idx].children);
          }
          element.appendChild(folder);
          break;

        // if the bookmark is a regular bookmark...
        case "Bookmark":
        case "IEFavorite":
        case "ImmutableBookmark":
          element.appendChild(this._createBookmarkElement(bmarks[idx]));
          break;

        // handle live bookmarks
        case "Livemark":
          break;

        // handle separators...
        case "BookmarkSeparator":
          element.appendChild(this._createSeparatorElement());
          break;

        // ignore everything else
        default: break;
      }
    }
  },

////////////////////////////////////////////////////////////////////////////////
// Create a <title> element appropriate for a specified bookmark.

  _createTitleElement:function(bmark) {
    var element = this._doc.createElement("title");
    if (bmark.name) {
      var textnode = this._doc.createTextNode(bmark.name);
      element.appendChild(textnode);
    }
    return element;
  },

////////////////////////////////////////////////////////////////////////////////
// Create a <desc> element appropriate for a specified bookmark.

  _createDescElement:function(bmark) {
    var element = this._doc.createElement("desc");
    if (bmark.desc) {
      var textnode = this._doc.createTextNode(bmark.desc);
      element.appendChild(textnode);
    }
    return element;
  },

////////////////////////////////////////////////////////////////////////////////
// Create a <separator> element.

  _createSeparatorElement:function() {
    return this._doc.createElement("separator");
  },

////////////////////////////////////////////////////////////////////////////////
// Returns the specified bookmark as an XML string.

  _createFolderElement:function(bmark) {
    var element = this._doc.createElement("folder");
    element.appendChild(this._createTitleElement(bmark));
    element.appendChild(this._createDescElement(bmark));
    return element;
  },

////////////////////////////////////////////////////////////////////////////////
// Returns the specified bookmark as an XML string.

  _createBookmarkElement:function(bmark) {
    var element = this._doc.createElement("bookmark");
    element.setAttribute("id", bmark.id);
    element.setAttribute("href", bmark.url);
    element.appendChild(this._createTitleElement(bmark));
    element.appendChild(this._createDescElement(bmark));
    return element;
  },

////////////////////////////////////////////////////////////////////////////////
// Overwrite the XML file with the Firefox bookmarks.

  push:function() {
    var folder = this._syncMarks.settings.favsFolder;

    // create the XML file that will be used
    var file = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
    file.initWithPath(this._syncMarks.settings.xmlFile); 
    if (! file.exists()) {
      file.create(0, 0644);
    }

    // set up the output stream to the file
    var outputStream = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);
    outputStream.init(file, 0x20 | 0x02, 00004, null);

    // write the XML source to the file
    var serializer = new XMLSerializer();
    var source = "<?xml version=\"1.0\"?>\n" + serializer.serializeToString(this.document);
    var result = outputStream.write(source, source.length);
    outputStream.flush();
    outputStream.close();
  },

////////////////////////////////////////////////////////////////////////////////
// Overwrite Firefox with the XML file.

  pull:function() {
  },

////////////////////////////////////////////////////////////////////////////////
// Merge Firefox with the XML file.

  merge:function() {
  },

////////////////////////////////////////////////////////////////////////////////
};

