// License: http://creativecommons.org/licenses/by-nc-sa/2.0/

function SyncMarksHandlerFavorites(syncMarks) {
  this._init(syncMarks);
}

////////////////////////////////////////////////////////////////////////////////

SyncMarksHandlerFavorites.prototype = {
  _syncMarks:null,
  _marks:null,

////////////////////////////////////////////////////////////////////////////////
// Initialize the bookmarks iterator.

  _init:function(syncMarks) {
    this._syncMarks = syncMarks;
    this._marks = this._syncMarks.bookmarks;
  },

////////////////////////////////////////////////////////////////////////////////
// Overwrite the Favorites folder with the Firefox bookmarks.

  push:function() {
    var folder = this._syncMarks.settings.favsFolder;

    // remove existing folder tree if requested
    if (this._syncMarks.settings.favsClean) {
      var dir = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
      dir.initWithPath(folder); 
      if (dir.exists()) {
        // we can't remove the windows favorites folder (and don't need to remove
        // the base), so remove each file in the directory
        var files = dir.directoryEntries;
        while (files.hasMoreElements()) {
          var file = files.getNext().QueryInterface(Components.interfaces.nsIFile);
          file.remove(file.isDirectory() ? true : false);
        }
      }
    }

    // push the root boomarks folder
    this._pushFolder(this._marks.bookmarks, folder);
  },

////////////////////////////////////////////////////////////////////////////////
// Overwrite the a specific folder with the specified bookmarks.

  _pushFolder:function(bmarks, folder) {
    // first, make sure the folder exists...
    var dir = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
    dir.initWithPath(folder); 
    if (! dir.exists()) {
      dir.create(1, 0755);
    }

    // now, walk through all the bookmarks and do their thang...
    for (var idx = 0; idx < bmarks.length; idx++) {
      switch (bmarks[idx].type) {
        // if the bookmark is the personal folder, force the folder name
        case "PersonalToolbarFolder":
          if (bmarks[idx].children != null) {
            this._pushFolder(bmarks[idx].children, folder + "\\Links");
          }
          break;

        // if the bookmark is a folder, set its children...
        case "Folder":
        case "IEFavoriteFolder":
          if (bmarks[idx].children != null) {
            this._pushFolder(bmarks[idx].children, folder + "\\" + bmarks[idx].name);
          }
          break;

        // if the bookmark is a regular bookmark, create the new link file
        case "IEFavorite":
        case "ImmutableBookmark":
        case "Bookmark":
          this._createWinLink(folder, bmarks[idx].name, bmarks[idx].url);
          break;

        // what should we do with live bookmarks?
        case "Livemark":

        // ignore separators and everything else
        case "BookmarkSeparator":
        default: break;
      }
    }
  },

////////////////////////////////////////////////////////////////////////////////
// Overwrite Firefox with the Favorites folder.

  pull:function() {
  },

////////////////////////////////////////////////////////////////////////////////
// Merge Firefox with the Favorites folder.

  merge:function() {
  },

////////////////////////////////////////////////////////////////////////////////

  _stripInvalidChars:function(filename) {
    filename = filename.replace(/[\\\/\:\*\?\"\<\>\|]/g, '');
    filename = filename.replace(/(^[\s]+)|([\s]+$)/g, '');
    return filename;
  },

////////////////////////////////////////////////////////////////////////////////

  // create a windows shortcut to the specified URL
  _createWinLink:function(path, name, url) {

    // set up the path to the windows shortcut
    var fullPath = path + "\\" + this._stripInvalidChars(name) + ".url"; 

    var file = Components.classes["@mozilla.org/file/local;1"]
               .createInstance(Components.interfaces.nsILocalFile);

    file.initWithPath(fullPath); 
    if (! file.exists()) {
      file.create(0, 0644);
    }

    var winLink = "[DEFAULT]\n"
                + "BASEURL=" + url + "\n"
                + "[InternetShortcut]\n"
                + "URL=" + url + "\n";

    var outputStream = Components.classes["@mozilla.org/network/file-output-stream;1"]
                       .createInstance(Components.interfaces.nsIFileOutputStream);

    outputStream.init(file, 0x20 | 0x02, 00004, null);
    var result = outputStream.write(winLink, winLink.length);
    outputStream.flush();
    outputStream.close();
  },

////////////////////////////////////////////////////////////////////////////////
};

