var timeValue = {};
var UTCTime = false;
var firstday = 0;


function paintMonth(year, month)
{
	const grid = document.getElementById("calendar");

	const months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
	document.getElementById("monthlabel").setAttribute("value", months[month] + " " + year);

	const date = new Date(year, month, 1);
	const prevcount = (date - new Date(year, month-1, 1)) / 86400000;
	const count = (new Date(year, month+1, 1) - date) / 86400000;
	const start = (date.getDay() + 6 - firstday) % 7 + 1; // do +6 then +1 to have first row always showing sth in previous month

	for (var i=0; i<42; i++)
	{
		var dayOfMonth = i - start + 1;
		var node = grid.childNodes[Math.floor(i/7) + 2].childNodes[i % 7];
		if (dayOfMonth > 0 && dayOfMonth <= count)
		{
			node.setAttribute("value", dayOfMonth);
			node.className = dayOfMonth == timeValue.date && month == timeValue.month && year == timeValue.year ? "selected" : "";
		}
		else
		{
			node.setAttribute("value", dayOfMonth > 0 ? dayOfMonth - count : dayOfMonth + prevcount);
			node.className = "notCurrentMonth";
		}
	}
}


function selectMonth()
{
	paintMonth(getValue("year"), document.getElementById("month").selectedIndex);
}


function selectDay(node)
{
	var year = getValue("year");
	var month = document.getElementById("month").selectedIndex;
	var date = node.getAttribute("value");
	if (node.className == "notCurrentMonth")
	{
		if (date > 20)
		{
			if (--month < 0) {month += 12; year--}
		}
		else
		{
			if (++month >= 12) {month -= 12; year++}
		}
	}

	setValue("year", timeValue.year = year);
	document.getElementById("month").selectedIndex = timeValue.month = month;
	setValue("date", timeValue.date = date);
	selectMonth();
}


function enterYear()
{
	var year = parseInt(getValue("year"));
	if (isNaN(year))
		year = timeValue.year;
	setValue("year", year);
	selectMonth();
}


function enterDate()
{
	var date = parseInt(getValue("date"));
	const month = document.getElementById("month").selectedIndex;
	const year = getValue("year");

	const dateMax = (new Date(year, month+1, 1) - new Date(year, month, 1)) / 86400000;

	if (isNaN(date)) date = timeValue.date;
	else if (date < 1) date = 1;
	else if (date > dateMax) date = dateMax;
	setValue("date", date);

	timeValue.date = date;
	timeValue.month = month;
	timeValue.year = year;
	selectMonth();
}


function enterTime(node, min, max)
{
	var n = parseInt(node.value);
	if (isNaN(n)) n = timeValue[node.getAttribute("id")];
	else if (n < min) n = min;
	else if (n > max) n = max;
	timeValue[node.getAttribute("id")] = node.value = n;
}


function positionDialog()
{
	box = window.arguments[0].boxObject;
	window.screenX = box.screenX + box.width;
	window.screenY = box.screenY;
}


function init()
{
	const days = ["S", "M", "T", "W", "T", "F", "S"];
	const grid = document.getElementById("calendar");
	for (var i=0; i<7; i++)
		grid.childNodes[1].childNodes[i].setAttribute("value", days[(i + firstday) % 7]);
	for (i=0; i<42; i++)
		grid.childNodes[Math.floor(i/7) + 2].childNodes[i % 7].setAttribute("onclick", "selectDay(this)");

	var date = new Date(window.arguments[0] ? window.arguments[0].value : "");
	if (date == "Invalid Date") date = new Date();

	UTCTime = window.arguments[2] ? true : false; // force boolean
	firstday = parseInt(window.arguments[3]);
	if (firstday < 0 || firstday > 6) firstday = 0;

	timeValue =
	{
		year: UTCTime ? date.getUTCFullYear() : date.getFullYear(),
		month: UTCTime ? date.getUTCMonth() : date.getMonth(),
		date: UTCTime ? date.getUTCDate() : date.getDate(),
		hours: UTCTime ? date.getUTCHours() : date.getHours(),
		minutes: UTCTime ? date.getUTCMinutes() : date.getMinutes(),
		seconds: UTCTime ? date.getUTCSeconds() : date.getSeconds()
	}
	setValue("year", timeValue.year);
	document.getElementById("month").selectedIndex = timeValue.month;
	setValue("date", timeValue.date);
	setValue("hours", timeValue.hours);
	setValue("minutes", timeValue.minutes);
	setValue("seconds", timeValue.seconds);
	selectMonth();

	window.sizeToContent();
	positionDialog();
}


function okay()
{
	try
	{
		date = new Date("1970/Jan/1"); // do not allow milliseconds
		if (UTCTime)
		{
			date.setUTCFullYear(timeValue.year);
			date.setUTCMonth(timeValue.month);
			date.setUTCDate(timeValue.date);
			date.setUTCHours(timeValue.hours);
			date.setUTCMinutes(timeValue.minutes);
			date.setUTCSeconds(timeValue.seconds);
		}
		else
		{
			date.setFullYear(timeValue.year);
			date.setMonth(timeValue.month);
			date.setDate(timeValue.date);
			date.setHours(timeValue.hours);
			date.setMinutes(timeValue.minutes);
			date.setSeconds(timeValue.seconds);
		}
		window.arguments[0].value = time(date);
		window.arguments[1].value = true;
	}
	catch (e) {window.alert(e)} // failure is normal if argument is not an object, so simply ignore the errors
	window.close();
}


function cancel()
{
	window.close();
}