function selectFile(node)
{
	var fp = saveDialog("Select File");
	if (fp != null)
		node.value = fp.file.path;
}


function fn2re(s)
{
	return s.replace(/\.\+\$\{\}\=\!\<\>\|\:\//g, "\\$&").replace(/\*/g, ".*").replace(/\?/g, ".");
}


function makeCategoryRe(s)
{
	try { return new RegExp("(^|\\W)(" + fn2re(getValue("category")).replace(/ +/gm, "|") + ")($|\\W)"); } catch (e) { return null; }
}


function makeFnmatchRe(s)
{
	try { return new RegExp("^" + fn2re(s) + "$", "i"); } catch (e) { return null; }
}


function validatePage(node)
{
	var errors = [];
	// if id attribute is not found, throw exception
	switch (node.getAttribute("id"))
	{
		case "criteria":
			if (getValue("numItems").match(/\D/)) errors.push("Max no. of items must be a positive integer");
			if (getValue("dateS") != "" && new Date(getValue("dateS")) == "Invalid Date") errors.push("Publication Date - \"From\" is invalid");
			if (getValue("dateE") != "" && new Date(getValue("dateE")) == "Invalid Date") errors.push("Publication Date - \"To\" is invalid");
			if (getValue("category") != "" && makeCategoryRe(getValue("category")) == null) errors.push("Category is invalid");
			if (getValue("guid") != "" && makeFnmatchRe(getValue("guid")) == null) errors.push("GUID is invalid");
			break;

		case "pubdate":
			if (getValue("channelPubDate") != "" && new Date(getValue("channelPubDate")) == "Invalid Date") errors.push("Publication Date is invalid");
			break;
	}

	if (errors.length)
	{
		for (var i=0, count=errors.length, errStr=""; i<count; i++)
			errStr += errors[i] + ((i < count-1) ? "\n" : "");
		window.alert(errStr);
		return false;
	}
	else
		return true;
}


function refreshData()
{
	const srcDocument = window.opener.document;
	const channel = document.getElementById("channel");
	var i, count;

	count = channel.childNodes.length;
	for (i=0; i<count; i++)
		channel.childNodes[i].value = srcDocument.getElementById(channel.childNodes[i].getAttribute("id")).value;

	setValue("channelPubDate", boolPref("publishPubDateAuto") ? time() : srcDocument.getElementById("channelPubDate"));


	const srcList = window.opener.document.getElementById("itemList");
	const list = document.getElementById("itemList");
	var selection = [];

	var maxSelect = parseInt(getValue("numItems"));
	var dateS = getValue("dateS") == "" ? null : new Date(getValue("dateS"));
	var dateE = getValue("dateE") == "" ? null : new Date(getValue("dateE"));
	var category = getValue("category") == "" ? null : makeCategoryRe(getValue("category"));
	var guid = getValue("guid") == "" ? null : makeFnmatchRe(getValue("guid"));
	var pubDate, item;

	while (list.lastChild)
		list.removeChild(list.lastChild);

	// check the list according to criteria
	count = srcList.childNodes.length;
	for (i=0; i<count; i++)
	{
		item = eval(srcList.childNodes[i].firstChild.lastChild.getAttribute("label"));
		// if no pubDate, the criteria is not satisfied
		pubDate = new Date(item.pubDate);
		if ((dateS == null || dateS <= pubDate) && (dateE == null || dateE >= pubDate) && (category == null || category.test(item.category)) && (guid == null || guid.test(item.guid)))
		{
			selection.push({date: pubDate, index: i});
		}
	}

	// sort the selection by reverse chronological order, and then output the list
	selection.sort(function comp(a, b) {return b.date - a.date;});
	// if selection is longer than maximum, just ignore all the rest
	count = maxSelect > 0 && selection.length > maxSelect? maxSelect : selection.length;
	for (i=0; i<count; i++)
		list.appendChild(srcList.childNodes[selection[i].index].cloneNode(true));
}


function init()
{
	window.moveToCenterPosition();
}


// fake function called by saveRSS in rssio.js
function itemUpdate() {}

function finish()
{
	var fp = saveDialog("Publish - Choose file to save");
	return fp && save(fp, false);
}


// Store persistances
function unload()
{
	var i, a;
	for (i in a = ["numItems", "dateS", "dateE", "category", "guid"])
		document.getElementById(a[i]).setAttribute("value", getValue(a[i]));
}