// Public variables
var itemSelectDisabled = false; // temporary disable event for manipulating selected row in list
var updateItemCmdsDisabled = false; // temporary disable update of item commands
var selectedItem = null; // selected item for editing

// Date Updates
function channelLastBuildDateUpdate()
{
	boolPref("lastBuildDateAuto") && setValue("channelLastBuildDate", time());
	// todo: mark document modified
}

function dateUpdates()
{
	if (boolPref("itemPubDateAuto"))
	{
		setValue("itemPubDate", time());
		itemInput(document.getElementById("itemPubDate"));
		// channelLastBuildDateUpdate is done in itemInput
	}
	else
	{
		channelLastBuildDateUpdate();
	}
}


// Enable/disable commands for items
function updateItemCmds()
{
	if (updateItemCmdsDisabled) return;

	var e1 = document.getElementById("tabItems").selected;
	var tree = document.getElementById("tree");
	var selList = treeSelection(tree);
	var e2 =  e1 && selList.length>0;

	var a = {
		itemInsertCmd: e1,
		itemAppendCmd: e1,
		itemDeleteCmd: e2,
		itemRevertCmd: e1 && (selectedItem != null),
		itemMoveUpCmd: e2 && selList[0].start > 0,
		itemMoveDownCmd: e2 && selList[selList.length - 1].end < tree.view.rowCount - 1
	};
	for (var i in a)
	{
		if (!a[i])
			document.getElementById(i).setAttribute("disabled", "true");
		else
			document.getElementById(i).removeAttribute("disabled");
	}
}


// Return tree selection, simplified and sorted
function treeSelection(tree)
{
	var sel = tree.view.selection;
	var i, j, count;
	var selList = [], selS = [], selE = [];
	var start = {}, end = {}, i;

	// sorting starts and ends individually - e.g. change 2-7, 3-6 to 2-6, 3-7
	count = sel.getRangeCount();
	for (i=0; i<count; i++)
	{
		sel.getRangeAt(i, start, end);
		// always push the smaller value to selS, and the bigger to selE
		if (start.value <= end.value)
		{
			selS.push(start.value);
			selE.push(end.value);
		}
		else
		{
			selS.push(end.value);
			selE.push(start.value);
		}
	}

	selS.sort(numericCompare); selE.sort(numericCompare);

	count = selS.length;
	for (i=0; i<count; i=j)
	{
		// only the first "start" and the last "end" is needed if the blocks are connected or overlapping
		for (j=i+1; j<count && selS[j]-1<=selE[i]; j++); // empty statement
		selList.push({start: selS[i], end: selE[j-1]});
	}

	return selList;
}


// Initialization of rsseditor.xul window
function init()
{
	// setting the controller for the tree in order to make it respond to keyboard commands
	var tree = document.getElementById("tree");

	var controller =
	{
		supportsCommand : function(cmd)
		{
			switch (cmd)
			{
				case "cmd_cut":
				case "cmd_copy":
				case "cmd_paste":
				case "cmd_delete":
					return true;
				default:
					return false;
			}
		},

		isCommandEnabled : function(cmd)
		{
			var e1 = document.getElementById("tabItems").selected;
			var tree = document.getElementById("tree");
			var selList = treeSelection(tree);
			var e2 =  e1 && selList.length>0;
			switch (cmd)
			{
				case "cmd_delete":
				case "cmd_cut":
				case "cmd_copy":
					return e2;
				case "cmd_paste":
					return e1;
				default:
					return false;
			}
		},

		doCommand : function(cmd)
		{
			switch (cmd)
			{
				case "cmd_cut":
				case "cmd_copy":
					itemsCopy();
					if (cmd == "cmd_copy") break;
					itemsDelete(false);
					break;
				case "cmd_delete":
					itemsDelete(true);
					break;
				case "cmd_paste":
					itemsPaste();
					break;
			}
		},

		onEvent : function(evt) {}
	};

	tree.controllers.appendController(controller);

	if (boolPref("smallIcons"))
		document.getElementById("rsseditor_toolbar").setAttribute("iconsize", "small");
	document.getElementById("itemGuid").readonly = boolPref("guidReadOnly");
}


// RSS Editor close confirmation - remember to use "return confirmClose()" for onClose attributes
function confirmClose()
{
	return window.confirm("Close RSS Editor");
}


// prototypes
function RSSItem()
{
	this.title = "";
	this.link = "";
	this.desc = "";
	this.author = "";
	this.category = "";
	this.guid = "";
	this.pubDate = "";
	this.comments = "";
	this.source = "";
	this.sourceurl = "";
}


function addListitem(item, endOfList)
{
	var list = document.getElementById("itemList");
	var e1 = document.createElement("treeitem");
	var e2 = document.createElement("treerow");
	const a = ["title", "pubDate", "category", "author"];
	for (var i in a)
		e2.appendChild(document.createElement("treecell")).setAttribute("label", item[a[i]]);
	e2.appendChild(document.createElement("treecell")).setAttribute("label", item.toSource());
	e1.appendChild(e2);
	if (selectedItem && !endOfList)
		list.insertBefore(e1, selectedItem.parentNode);
	else
		list.appendChild(e1);
	return e1;
}


// Events of items
function itemAdd(endOfList)
{
	var tree = document.getElementById("tree");
	var list = document.getElementById("itemList");
	var item = new RSSItem();
	item.title = "New item";
	item.guid = genGUID();

	try
	{
		updateItemCmdsDisabled = true;
		tree.view.selection.select(tree.view.getIndexOfItem(addListitem(item, endOfList)));
	}
	finally
	{
		updateItemCmdsDisabled = false;
		updateItemCmds();
	}
	if (tree.treeBoxObject.getLastVisibleRow < tree.currentIndex)
		tree.scrollToRow(tree.currentIndex - tree.treeBoxObject.getLastVisibleRow + tree.treeBoxObject.getFirstVisibleRow);
	dateUpdates();
}


function itemsDelete(confirm)
{
	if (confirm && window.confirm("Delete selected items?") != 1) return;

	var tree = document.getElementById("tree");
	var list = document.getElementById("itemList");

	var selList = treeSelection(tree);
	var selIndex = tree.currentIndex;
	var selectChanged = false;
	var count = selList.length;
	var range;

	try
	{
		updateItemCmdsDisabled = true;

		// deleting starts from the end of the list
		for (var i=count-1; i>=0; i--)
		{
			range = selList[i];
			if (selIndex >= range.start && selIndex <= range.end)
			{
				// move selection to the item immediately after the end of selection
				selIndex = range.start;
				// if no such item, select the item immediately before the selection
				if (range.end + 1 == tree.view.rowCount) selIndex--;
			}
			else if (!selectChanged && selIndex > range.end)
			{
				// actually moving selection in tree
				tree.view.selection.select(selIndex);
				selectChanged = true;
			}
			// delete items AFTER moving the selection
			for (var j=range.end; j>=range.start; j--)
				list.removeChild(tree.view.getItemAtIndex(j));
		}
		if (!selectChanged && tree.view.rowCount)
			tree.view.selection.select(selIndex > 0 ? selIndex : 0);
	}
	finally
	{
		updateItemCmdsDisabled = false;
		updateItemCmds();
	}
	channelLastBuildDateUpdate();
}


function itemsUp()
{
	var tree = document.getElementById("tree");
	var list = document.getElementById("itemList");

	var selList = treeSelection(tree);
	var count = selList.length;
	var range, item, refitem;


	if (selList[0].start <= 0) return
	try
	{
		itemSelectDisabled = true;
		updateItemCmdsDisabled = true;
		for (var i=0; i<count; i++)
		{
			range = selList[i];
			item = tree.view.getItemAtIndex(range.start - 1);
			if (range.end < tree.view.rowCount - 1)
			{
				refitem = tree.view.getItemAtIndex(range.end + 1);
				list.insertBefore(list.removeChild(item), refitem);
			}
			else
				list.appendChild(list.removeChild(item));
		}
	}
	finally
	{
		itemSelectDisabled = false;
		updateItemCmdsDisabled = false;
		updateItemCmds();
	}
	channelLastBuildDateUpdate();
}


function itemsDown()
{
	var tree = document.getElementById("tree");
	var list = document.getElementById("itemList");

	var selList = treeSelection(tree);
	var count = selList.length;
	var range, item, refitem;

	if (selList[count-1].end >= tree.view.rowCount-1) return;
	try
	{
		itemSelectDisabled = true;
		updateItemCmdsDisabled = true;
		for (var i=count-1; i>=0; i--)
		{
			range = selList[i];
			item = tree.view.getItemAtIndex(range.end + 1);
			refitem = tree.view.getItemAtIndex(range.start);
			list.insertBefore(list.removeChild(item), refitem);
		}
	}
	finally
	{
		itemSelectDisabled = false;
		updateItemCmdsDisabled = false;
		updateItemCmds();
	}
	channelLastBuildDateUpdate();
}


function itemSelect(skipUpdate)
{
	if (itemSelectDisabled) return;
	var tree = document.getElementById("tree");
	var row = tree.currentIndex;
	if (row < 0)
	{
		selectedItem = null;
		item = new RSSItem();
	}
	else
	{
		var listitem = tree.view.getItemAtIndex(row).firstChild;

		skipUpdate || itemUpdate();
		selectedItem = listitem;

		try
		{
			item = eval(listitem.lastChild.getAttribute("label"));
		}
		catch (e) {}
	}
	setValue("itemTitle", item.title);
	setValue("itemLink", item.link);
	setValue("itemDesc", item.desc);
	setValue("itemAuthor", item.author);
	setValue("itemCategory", item.category);
	setValue("itemGuid", item.guid);
	setValue("itemPubDate", item.pubDate);
	setValue("itemComments", item.comments);
	setValue("itemSource", item.source);
	setValue("itemSourceUrl", item.sourceurl);
}


function itemInput(element)
{
	var tree = document.getElementById("tree");
	if (selectedItem == null) return;

	var itemNames = {"itemTitle":0, "itemPubDate":1, "itemCategory":2, "itemAuthor":3};
	var id = element.getAttribute("id");

	var colId = itemNames[id];
	if (id == "itemPubDate")
	{
		selectedItem.childNodes[colId].setAttribute("label", time(element.value));
		channelLastBuildDateUpdate();
	}
	else
	{
		colId != undefined && selectedItem.childNodes[colId].setAttribute("label", element.value);
		dateUpdates();
	}
}


function itemUpdate()
{

	if (selectedItem == null) return;
	var item =
	{
		title: getValue("itemTitle"),
		link: getValue("itemLink"),
		desc: getValue("itemDesc"),
		author: getValue("itemAuthor"),
		category: getValue("itemCategory"),
		guid: getValue("itemGuid"),
		pubDate: time(getValue("itemPubDate")),
		comments: getValue("itemComments"),
		source: getValue("itemSource"),
		sourceurl: getValue("itemSourceUrl")
	}
	const a = ["title", "pubDate", "category", "author"];
	for (var i in a)
		selectedItem.childNodes[i].setAttribute("label", item[a[i]]);
	selectedItem.lastChild.setAttribute("label", item.toSource());
}


function itemGuidGen()
{
	if (!boolPref("guidReadOnly") || window.confirm("Changing GUID can affect behavior of RSS aggregrators"))
	{
		setValue("itemGuid", genGUID());
		dateUpdates();
	}
}


function publish()
{
	itemUpdate();
	window.openDialog("rsseditor_publish.xul", "rsseditor_publish", "modal");
}


function options()
{
	// storing old values
	var oldUTCTime = boolPref("UTCTime");

	window.openDialog("rsseditor_options.xul", "rsseditor_options", "modal");

	// setting toolbar size
	if (boolPref("smallIcons"))
		document.getElementById("rsseditor_toolbar").setAttribute("iconsize", "small");
	else
		document.getElementById("rsseditor_toolbar").removeAttribute("iconsize");
	// setting GUID field (not no old values because command is simple)
	document.getElementById("itemGuid").readonly = boolPref("guidReadOnly");
	// update format of times
	if (oldUTCTime != boolPref("UTCTime"))
	{
		var list = document.getElementById("itemList");
		var n = list.childNodes.length;
		var i;
		for (i=0; i<n; i++)
			list.childNodes[i].firstChild.childNodes[1].setAttribute("label", time(list.childNodes[i].firstChild.childNodes[1].getAttribute("label")));
		// Todo: update channel/pubdate, channel/lastbuilddate, item/pubdate to new time format
	}
}


function about()
{
	window.openDialog("rsseditor_about.xul", "rsseditor_about");
}