// constants
const prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("rsseditor.");


// Function for numeric order for sorting arrays
// Compare by string if any of the arguments are not numbers (i.e. a - b is Nan)
function numericCompare(a, b)
{
	var r, as, bs;
	return !isNaN(r = a - b) ? r : (as = a.toString()) > (bs = b.toString()) ? 1 : as < bs ? -1 : 0;
}


// Generate 128-bit GUID "{xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx}
function genGUID()
{
	// crude function, not actually random
	var hex = new Function("return Number(Math.floor(Math.random()*65536)).toString(16)");
	return "{" + hex() + hex() + "-" + hex() + "-" + hex() + "-" + hex() + "-" + hex() + hex() + hex() + "}";
}


// Return a time string in local time or UTC time depending on pref "rsseditor.UTCTime"
function time(s)
{
	if (s == "") return "";
	const months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
	var d = s ? new Date(s) : new Date();
	return isNaN(d.getFullYear()) || boolPref("UTCTime") ? d.toUTCString() : d.getFullYear() + "/" + months[d.getMonth()] + "/" + d.getDate() + " " + (d.getHours() < 10 ? "0" : "") + d.getHours() + ":" + (d.getMinutes() < 10 ? "0" : "") + d.getMinutes() + ":" + (d.getSeconds() < 10 ? "0" : "") + d.getSeconds();
}


// getBoolPref w/ exception handling (return false on failure)
function boolPref(pref)
{
	try
	{
		return prefs.getBoolPref(pref);
	}
	catch (e)
	{
		return false;
	}
}


// Get the value of element w/ id [id] (return null is element does not exist)
function getValue(id)
{
	try
	{
		return document.getElementById(id).value;
	}
	catch (e)
	{
		return null;
	}
}


// Set the value of element w/ id [id] to [value], ignoring runtime errors
function setValue(id, value)
{
	try
	{
		document.getElementById(id).value = value;
		return true;
	}
	catch (e)
	{
		return false;
	}
}


/**
 * Append a element w/ a text node into another element
 * @param DOMElement element Targer element
 * @param string name Name of element to be appended
 * @param string contents Contents of the text node inside tht element
 * @return DOMElement Inserted element
 */
function insertElement(element, name, contents)
{
	var d = element.ownerDocument;
	var e = d.createElement(name);
	element.appendChild(e).appendChild(d.createTextNode(contents));
	return e;
}


function fireEvent(aTarget, aType)
{
	var event = document.createEvent("Events");
	event.initEvent(aType, false, true);

	// handle dom event handlers
	var noCancel = aTarget.dispatchEvent(event);

	// handle any xml attribute event handlers
	var handler = aTarget.getAttribute("on"+aType);
	if (handler != "")
	{
		var fn = new Function("event", handler);
		var returned = fn.call(aTarget, event);
		if (returned == false)
			noCancel = false;
	}

	return noCancel;
}


/**
 * Open a time selector to select date for the desired node
 *
 * Parameters:
 * node (usually a XUL textbox) {
 *  in/out value: default date / return
 *  int boxObject.screenX + int boxObject.width: X position of the time selector
 *  int boxObject.screenY : Y position of the time selector
 * }
 */
function selectDate(node)
{
	var returned = {};
	// open the time selector w/ following arguments: (node to be edited, placeholder for successful return, UTCTime, firstday)
	openDialog("timeselector.xul", "timeselector", "chrome,modal", node, returned, boolPref("UTCTime"), 0);
	// if successful, execute "oninput" and "onchange" events
	if (returned.value == true)
	{
		fireEvent(node, "input");
		fireEvent(node, "change");
	}
}


function moveToCenterPosition()
{
	if (window.opener)
	{
		window.sizeToContent();
		window.moveTo(window.opener.screenX+(window.opener.outerWidth-window.outerWidth)/2,window.opener.screenY+(window.opener.outerHeight-window.outerHeight)/2);
	}
}


/**
 * File picker for saving files
 * @param string s: Title of save dialog
 * @return nsIFilePicker (success) or null (cancel)
 */
function saveDialog(s)
{
	var nsIFilePicker = Components.interfaces.nsIFilePicker;
	var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
	fp.init(window, s, nsIFilePicker.modeSave);

	fp.appendFilter("RSS Files", "*.rss; *.xml");
	fp.appendFilters(nsIFilePicker.filterAll);
	fp.defaultExtension = ".rss";

	var res = fp.show();
	return res == nsIFilePicker.returnOK || res == nsIFilePicker.returnReplace ? fp : null;
}