const rssXMLHeader = '<?xml version="1.0" encoding="UTF-8"?>\n';


function toUnicode(charset, data)
{
	const suniconvCID = "@mozilla.org/intl/scriptableunicodeconverter";
	const suniconvIID = Components.interfaces.nsIScriptableUnicodeConverter;

	try
	{
		var uniConv = Components.classes[suniconvCID].createInstance(suniconvIID);
		uniConv.charset = charset;
		data = uniConv.ConvertToUnicode(data);
	}
	catch(e) {}
	return data;
}


const rssType_all = 0;
const rssType_selection = 1;
const rssType_publish = 2;


function getClipboardText()
{
	var clip = Components.classes["@mozilla.org/widget/clipboard;1"].createInstance(Components.interfaces.nsIClipboard);
	if (!clip) return false;

	var trans = Components.classes["@mozilla.org/widget/transferable;1"].createInstance(Components.interfaces.nsITransferable);
	if (!trans) return false;
	trans.addDataFlavor("text/unicode");

	clip.getData(trans, clip.kGlobalClipboard);

	var str=new Object();
	var strLength=new Object();

	trans.getTransferData("text/unicode", str, strLength);

	if (str) str=str.value.QueryInterface(Components.interfaces.nsISupportsString);
	if (str) pastetext=str.data.substring(0, strLength.value / 2);

	return pastetext;
}


// Parse an item from the DOM Element "item" - called by parseData
function parseItems(items)
// the given variable is DESTROYED after parsing!
{
	var src = items.length ? items : [items];
	var data = [];
	var item, count2, j;
	try
	{
		var count = src.length;
		for (var i=0; i<count; i++)
		{
			item = new RSSItem();
			itemSrc = src[i].childNodes;
			count2 = itemSrc.length;
			for (j=0; j<count2; j++)
			{
				switch (itemSrc[j].nodeName)
				{
					case "title":
					case "link":
					case "author":
					case "category":
					case "guid":
					case "comments":
					case "source":
						try
						{
							itemSrc[j].normalize();
							item[itemSrc[j].nodeName] = itemSrc[j].firstChild.data;
						}
						catch (e) {}
						break;
					case "description":
						try
						{
							itemSrc[j].normalize();
							item.desc = itemSrc[j].firstChild.data;
						}
						catch (e) {}
						break;
					case "pubDate":
						try
						{
							itemSrc[j].normalize();
							item.pubDate = time(itemSrc[j].firstChild.data);
						}
						catch (e) {}
						break;
				}
			}
		}
		data.push(eval(item.toSource()));
	}
	catch (e) {}
	return data;
}

// parse an string w/ RSS content and load/import to RSS Editor
function parseData(str, replace)
{
	objDOMParser = new DOMParser;
	var d = objDOMParser.parseFromString(str, "text/xml");

	var channelData = {title:"", link:"", desc:"", lang:"", copyright:"", managingEditor:"", webMaster:"", pubDate:"", lastBuildDate:"", image:""};
	var items = [];
	try
	{
		if (d.documentElement.nodeName != "rss") throw "notvalid";
		var channels = d.getElementsByTagName("channel");
		if (channels.length != 1) throw "notvalid";
		var channel = channels[0].childNodes;
		var count = channel.length;
		var j, image, item, count2;
		for (var i=0; i<count; i++)
		{
			switch (channel[i].nodeName)
			{
				case "title":
				case "link":
				case "lang":
				case "copyright":
				case "managingEditor":
				case "webMaster":
					try
					{
						channel[i].normalize();
						channelData[channel[i].nodeName] = channel[i].firstChild.data;
					}
					catch (e) {}
					break;
				case "description":
					try
					{
						channel[i].normalize();
						channelData.desc = channel[i].firstChild.data;
					}
					catch (e) {}
					break;
				case "pubDate":
				case "lastBuildDate":
					try
					{
						channel[i].normalize();
						channelData[channel[i].nodeName] = time(channel[i].firstChild.data);
					}
					catch (e) {}
					break;
				case "image":
					image = channel[i].childNodes;
					count2 = image.length;
					{
						for (j=0; j<count2; j++)
						{
							if (image[j].nodeName == "url")
								try
								{
									image[j].normalize();
									channelData.image = image[j].firstChild.data;
								}
								catch (e) {}
						}
					}
					break;
				case "item":
					items.push(parseItems(channel[i])[0]);
					break;
			}
		}
	}
	catch (e)
	{
		window.alert("Not valid RSS file");
		return false;
	}

	if (replace)
	{
		setValue("channelTitle", channelData.title);
		setValue("channelLink", channelData.link);
		setValue("channelDesc", channelData.desc);
		setValue("channelLangr", channelData.lang);
		setValue("channelCopyright", channelData.copyright);
		setValue("channelManagingEditor", channelData.managingEditor);
		setValue("channelWebMaster", channelData.webMaster);
		setValue("channelPubDate", channelData.pubDate);
		setValue("channelLastBuildDate", channelData.lastBuildDate);
		setValue("channelImage", channelData.image);

		list = document.getElementById("itemList");
		while (list.lastChild)
			list.removeChild(list.lastChild);
	}

	count = items.length;
	for (i=0; i<count; i++)
		addListitem(items[i], false);

	return count;
}


// Save data (called by "save" or "save-as" or "export" or "publish")
function saveRSS(foStream, type)
{
	itemUpdate();

	var objXMLSerializer = new XMLSerializer;
	foStream.write(rssXMLHeader, rssXMLHeader.length);
	objXMLSerializer.serializeToStream(buildRSS(type), foStream, "UTF-8");
}

// Build DOM element "rss"
function buildRSS(type)
{
	var doc = document.implementation.createDocument(null, "rss", null);
	doc.documentElement.setAttribute("version", "2.0");
	doc.documentElement.appendChild(buildChannel(type));
	return doc;
}

// Build DOM element "channel"
function buildChannel(type)
{
	var d = document.implementation.createDocument(null, "rss", null);
	var e = d.createElement("channel");
	var b; // buffer

	// Required elements
	insertElement(e, "title", valueOf("channelTitle"));
	insertElement(e, "link", valueOf("channelLink"));
	insertElement(e, "description", valueOf("channelDesc"));

	// Optional elements
	valueOf("channelLang") != "" && insertElement(e, "lang", valueOf("channelLang"));
	valueOf("channelCopyright") != "" && insertElement(e, "copyright", valueOf("channelCopyright"));
	valueOf("channelManagingEditor") != "" && insertElement(e, "managingEditor", valueOf("channelManagingEditor"));
	valueOf("channelWebMaster") != "" && insertElement(e, "webMaster", valueOf("channelWebMaster"));

	// Dates are optional, validated and converted to UTC
	if ((b = new Date(valueOf("channelPubDate")).toUTCString()) != "Invalid Date")
		insertElement(e, "pubDate", b);
	if ((b = new Date(valueOf("channelLastBuildDate")).toUTCString()) != "Invalid Date")
		insertElement(e, "lastBuildDate", b);

	// Optional image
	if (valueOf("channelImage") != "")
	{
		e.appendChild(b = d.createElement("image"));
		insertElement(b, "url", valueOf("channelImage"));
		// Contents of these two elements should be same as channel/title and channel/link
		insertElement(b, "title", valueOf("channelTitle"));
		insertElement(b, "link", valueOf("channelLink"));
	}

	// Set range of items to be built
	var tree = document.getElementById("tree");
	switch (type)
	{
		case rssType_selection:
			ranges = treeSelection(tree);
			break;
		case rssType_all:
		default:
			ranges = [{start: 0, end: tree.view.rowCount - 1}];
	}
	buildItems(e, ranges);

	return e;
}

// Append the "item" elements to the supplied element according to the ranges given
function buildItems(element, ranges)
{
	var list = document.getElementById("itemList");
	var count = ranges.length;
	for (var i=0; i<count; i++)
	{
		for (var j=ranges[i].start; j<=ranges[i].end; j++)
		{
			try
			{
				item = eval(list.childNodes[j].firstChild.lastChild.getAttribute("label"));
				buf = element.ownerDocument.createElement("item");
				(item.title != "" || item.desc == "") && insertElement(buf, "title", item.title);
				item.link != "" && insertElement(buf, "link", item.link);
				item.desc != "" && insertElement(buf, "description", item.desc);
				item.author != "" && insertElement(buf, "author", item.author);
				item.category != "" && insertElement(buf, "category", item.category);
				item.comments != "" && insertElement(buf, "comments", item.comments);
				if ((b = new Date(item.pubDate).toUTCString()) != "Invalid Date")
					insertElement(buf, "pubDate", b);
				item.source != "" && insertElement(buf, "source", item.source);
	
				element.appendChild(buf);
			}
			catch (e) {}
		}
	}
}


// The object about the opened file
var openedFile = null;


function newFile()
{
	if (!window.confirm("Contents of open file will be lost")) return;
	// Reset fields in Channel Tab
	setValue("channelTitle", "");
	setValue("channelLink", "");
	setValue("channelDesc", "");
	setValue("channelLang", "");
	setValue("channelCopyright", "");
	setValue("channelManagingEditor", "");
	setValue("channelWebMaster", "");
	setValue("channelPubDate", "");
	setValue("channelLastBuildDate", "");
	setValue("channelImage", "");

	// Reset items
	list = document.getElementById("itemList");
	while (list.lastChild)
		list.removeChild(list.lastChild);
	// Reset fields in Items Tab: done by itemSelect() called by onselect event
	
	openedFile = null;
}


function openFile()
{
	var nsIFilePicker = Components.interfaces.nsIFilePicker;
	var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
	fp.init(window, "Open", nsIFilePicker.modeOpen);

	fp.appendFilter("RSS Files", "*.rss; *.xml");
	fp.appendFilters(nsIFilePicker.filterAll);

	var res = fp.show();
	if (res != nsIFilePicker.returnOK) return;

	var nsIFileInputStream = Components.interfaces.nsIFileInputStream;
	var fiStream = Components.classes["@mozilla.org/network/file-input-stream;1"].createInstance(nsIFileInputStream);
	fiStream.init(fp.file, 0x01, 00000, false);

	var nsIScriptableInputStream = Components.interfaces.nsIScriptableInputStream;
	var siStream = Components.classes["@mozilla.org/scriptableinputstream;1"].createInstance(nsIScriptableInputStream);
	siStream.init(fiStream);

	data = toUnicode("UTF-8", siStream.read(-1));

	parseData(data, true)

	openedFile = fp;
}


function save(f)
{
	var nsIFileOutputStream = Components.interfaces.nsIFileOutputStream;
	var foStream = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(nsIFileOutputStream);
	foStream.init(f.file, 0x2a, 0420, false); // wronly | create | truncate
	saveRSS(foStream, rssType_all);
	foStream.close();
}


function saveFile()
{
	openedFile ? save(openedFile) : saveAs();
}


function saveAs()
{
	var nsIFilePicker = Components.interfaces.nsIFilePicker;
	var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
	fp.init(window, "Save As", nsIFilePicker.modeSave);

	fp.appendFilter("RSS Files", "*.rss; *.xml");
	fp.appendFilters(nsIFilePicker.filterAll);

	var res = fp.show();
	if (res != nsIFilePicker.returnOK && res != nsIFilePicker.returnReplace) return;
	save(fp);
	openedFile = fp;
}


// Copy items to clipboard - as an RSS file
function itemsCopy()
{
	itemUpdate();

	var objXMLSerializer = new XMLSerializer;
	var str = rssXMLHeader;
	str += objXMLSerializer.serializeToString(buildRSS(rssType_selection));

	const gClipboardHelper = Components.classes["@mozilla.org/widget/clipboardhelper;1"].getService(Components.interfaces.nsIClipboardHelper);
	gClipboardHelper.copyString(str);
}


// Paste from an RSS file in the clipboard
function itemsPaste()
{
	// paste it before "selectedItem"
	var count = parseData(getClipboardText(), false);
	if (!count) return;

	var view = document.getElementById("tree").view;
	// Select the pasted items
	if (selectedItem == null)
		view.selection.rangedSelect(count - 1, 0, false);
	else
	{
		var index = view.getIndexOfItem(selectedItem.parentNode);
		view.selection.rangedSelect(index - 1, index - count, false);
	}
	itemSelect(false);
}