/* *******************
 * overlay.js
 * Implementation for mail and Firefox overlays
 *   rssEditor   <http://rsseditor.mozdev.org/>
 *
 * Author: Jed Brown (quicknote@jedbrown.net)
 * Contributor(s):
 *   Nickolay Ponomarev (asqueella@gmail.com)
 * Maintenance: Leunc WC (lwchk2001@yahoo.com.hk)
 ******************** */


// opens a new floating window
// if aText != undefined then it also "sends" the text to the window
function openRSSEFloat(aText)
{
	var win = rssEditor_getRSSEWinByType("rsseditor:mainwindow");
	if (win)
	{
		win.focus();
	}
	else
	{
		//Open rssEditor!

		// the text will be caught via catchText() in onLoad()
		// bug #6119 [When using Send to rssEditor on OSX, the floating
		// rssEditor window cannot be closed] possibly caused by this
		// (passing aText as an argument)
		window.openDialog("chrome://rsseditor/content/rsseditor.xul", "_blank", "chrome,all,dialog=no", aText);
	}
}


////////////////////////////////////////////////////////////////////////////////
// getRSSEWinByType
//
// Desc: Checks all open windows for the one we are looking for
// Parameters: type  - this is the name of the window we are looking for
// Returns: the type of window as an object.
// Have to add here because Mozilla Suite won't inherit rssEditor.js :(
////////////////////////////////////////////////////////////////////////////////
function rssEditor_getRSSEWinByType(type)
{
	var windowmanager;
	if (!windowmanager)
	{
		windowmanager = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService();
		windowmanager = windowmanager.QueryInterface(Components.interfaces.nsIWindowMediator);
	}
	return windowmanager.getMostRecentWindow(type);
}


////////////////////////////////////////////////////////////////////////////////
// Desc: Opens rssEditor depending on set pref
// Have to add here because Mozilla Suite won't inherit rssEditor.js :(
////////////////////////////////////////////////////////////////////////////////
function rssEditor_openRSSEditor()
{
	var howtopenRSSE = 1;
	// nsPreferences.getIntPref("rssEditor.openRSSE", 1);

	switch (howtopenRSSE)
	{
		case "0": toggleSidebar("viewrssEditorSidebar"); break;
		case "2": rssEditor_openRSSEditorInTab(); break;
		default: openRSSEFloat();
	}
}


// Open rssEditor as a tab
//### taken from Download Manager Tweak dmextension.mozdev.org
function rssEditor_openRSSEditorInTab()
{
	var numTabs = gBrowser.mTabContainer.childNodes.length;
	var index = 0;
	var oldTab = getBrowser().selectedTab;

	if (oldTab.getAttribute("rssEditor") == "true")
	{
		if (getWebNavigation().currentURI.spec == "chrome://rsseditor/content/rsseditor.xul")
		{
			BrowserCloseTabOrWindow();
			return;
		}
		else
			oldTab.removeAttribute("rssEditor");
	}

	var tempTab = null;
	while (index < numTabs)
	{
		tempTab = gBrowser.mTabContainer.childNodes[index];

		if (tempTab.getAttribute("rssEditor") == "true")
		{
			if (tempTab.label == "rssEditor" || tempTab.label == "chrome://rsseditor/content/rsseditor.xul")
			{
				getBrowser().selectedTab = tempTab;
				break;
			}
			else
			{
				getBrowser().selectedTab = tempTab;
				var url = getWebNavigation().currentURI.spec;
				if (url == "chrome://rsseditor/content/rsseditor.xul") break;
				else tempTab.removeAttribute("rssEditor");
			}
		}
		else index = index+1;
	}

	// If no rssEditor tab is open, then create one
	if (index == numTabs)
	{
		var rssEditorTab = gBrowser.addTab("chrome://rsseditor/content/rsseditor.xul");
		rssEditorTab.setAttribute("rssEditor", "true");
		getBrowser().selectedTab = rssEditorTab;
	}
}
