/*
browser.tabs.autoHide
browser.tabs.loadInBackground
browser.tabs.loadBookmarksInBackground
browser.tabs.warnOnClose
*/
var gPreferences;
addEventListener("load", QuickTabPrefToggle_OnFxLoad, false);
//Set defaults
QuickTabPrefToggle_getPrefs().SetDefaultBoolPref("extensions.quicktabpreftoggle.enable", false);
//Set User Defaults
QuickTabPrefToggle_getPrefs().SetDefaultIntPref("extensions.quicktabpreftoggle.user.open_external", 1);
QuickTabPrefToggle_getPrefs().SetDefaultIntPref("extensions.quicktabpreftoggle.user.open_newwindow", 2);
QuickTabPrefToggle_getPrefs().SetDefaultIntPref("extensions.quicktabpreftoggle.user.open_newwindow.ui", 3);
QuickTabPrefToggle_getPrefs().SetDefaultIntPref("extensions.quicktabpreftoggle.user.open_newwindow.restriction", 0);

//Set Toggle Defaults
QuickTabPrefToggle_getPrefs().SetDefaultIntPref("extensions.quicktabpreftoggle.toggle.open_external", 1);
QuickTabPrefToggle_getPrefs().SetDefaultIntPref("extensions.quicktabpreftoggle.toggle.open_newwindow", 2);
QuickTabPrefToggle_getPrefs().SetDefaultIntPref("extensions.quicktabpreftoggle.toggle.open_newwindow.ui", 3);
QuickTabPrefToggle_getPrefs().SetDefaultIntPref("extensions.quicktabpreftoggle.toggle.open_newwindow.restriction", 0);


//Get Prefs
var gQuickTabPrefToggle_user_Toggled = QuickTabPrefToggle_getPrefs().GetBoolPref("extensions.quicktabpreftoggle.enable");

//http://www.xulplanet.com/references/xpcomref/ifaces/nsIPref.html
function QuickTabPrefToggle_getPrefs() {
  if (!gPreferences) {
    try {
      gPreferences = Components.classes["@mozilla.org/preferences;1"].getService();
      gPreferences = gPreferences.QueryInterface(
        Components.interfaces.nsIPref);
    } catch (e) {}
  }

  return gPreferences;
}

// Toggle between the user prefs and the default prefs
function QuickTabPrefToggle_Toggle(){
  var QuickTabPrefToggle_user_open_external = QuickTabPrefToggle_getPrefs().GetIntPref("extensions.quicktabpreftoggle.user.open_external");
  var QuickTabPrefToggle_user_open_newwindow = QuickTabPrefToggle_getPrefs().GetIntPref("extensions.quicktabpreftoggle.user.open_newwindow");
  var QuickTabPrefToggle_user_open_newwindow_ui = QuickTabPrefToggle_getPrefs().GetIntPref("extensions.quicktabpreftoggle.user.open_newwindow.ui");
  var QuickTabPrefToggle_user_open_newwindow_restriction = QuickTabPrefToggle_getPrefs().GetIntPref("extensions.quicktabpreftoggle.user.open_newwindow.restriction");
  
  var QuickTabPrefToggle_toggle_open_external = QuickTabPrefToggle_getPrefs().GetIntPref("extensions.quicktabpreftoggle.toggle.open_external");
  var QuickTabPrefToggle_toggle_open_newwindow = QuickTabPrefToggle_getPrefs().GetIntPref("extensions.quicktabpreftoggle.toggle.open_newwindow");
  var QuickTabPrefToggle_toggle_open_newwindow_ui = QuickTabPrefToggle_getPrefs().GetIntPref("extensions.quicktabpreftoggle.toggle.open_newwindow.ui");
  var QuickTabPrefToggle_toggle_open_newwindow_restriction = QuickTabPrefToggle_getPrefs().GetIntPref("extensions.quicktabpreftoggle.toggle.open_newwindow.restriction");
  try{
    var QuickTabPrefToggle_toolbar = document.getElementById("quicktabpreftoggle-button");
  }catch(e){
    QuickTabPrefToggle_toolbar = null;
  }

  //If true than turn off, set to user prefs
  if(gQuickTabPrefToggle_user_Toggled){
    //SetIntPref SetBoolPref
    QuickTabPrefToggle_getPrefs().SetIntPref("browser.link.open_external", QuickTabPrefToggle_user_open_external);
    QuickTabPrefToggle_getPrefs().SetIntPref("browser.link.open_newwindow", QuickTabPrefToggle_user_open_newwindow);
    QuickTabPrefToggle_getPrefs().SetIntPref("browser.link.open_newwindow.ui", QuickTabPrefToggle_user_open_newwindow_ui);
    QuickTabPrefToggle_getPrefs().SetIntPref("browser.link.open_newwindow.restriction", QuickTabPrefToggle_user_open_newwindow_restriction);

    gQuickTabPrefToggle_user_Toggled = false;
    if(QuickTabPrefToggle_toolbar != null){
      QuickTabPrefToggle_toolbar.setAttribute("tooltiptext", "Normal User Mode");
    }
    
  }else if(!gQuickTabPrefToggle_user_Toggled){
    QuickTabPrefToggle_getPrefs().SetIntPref("browser.link.open_external", QuickTabPrefToggle_toggle_open_external);
    QuickTabPrefToggle_getPrefs().SetIntPref("browser.link.open_newwindow", QuickTabPrefToggle_toggle_open_newwindow);
    QuickTabPrefToggle_getPrefs().SetIntPref("browser.link.open_newwindow.ui", QuickTabPrefToggle_toggle_open_newwindow_ui);
    QuickTabPrefToggle_getPrefs().SetIntPref("browser.link.open_newwindow.restriction", QuickTabPrefToggle_toggle_open_newwindow_restriction);
    gQuickTabPrefToggle_user_Toggled = true;
    if(QuickTabPrefToggle_toolbar != null){
      QuickTabPrefToggle_toolbar.setAttribute("tooltiptext", "Toggled Mode ON");
    }
  }else{
    alert("Error: the Toggle messed up");
  }
  QuickTabPrefToggle_getPrefs().SetBoolPref("extensions.quicktabpreftoggle.enable", gQuickTabPrefToggle_user_Toggled);
}

//Used for easier calling
function QuickTabPrefToggle_OnClick(theEvent){
        if (theEvent.target.label == "About...") {
                window.open('chrome://quicktabpreftoggle/content/about.xul','QuickTabPrefToggle','chrome,centerscreen,resizable');
        }else if (theEvent.target.label == "Settings..." ) {
                window.open('chrome://quicktabpreftoggle/content/quicktabpreftoggle_settings.xul','QuickTabPrefToggle','chrome,centerscreen,resizable');
        }else{
          QuickTabPrefToggle_Toggle();
        }
}
function QuickTabPrefToggle_OnFxLoad(theEvent){
  try{
    var QuickTabPrefToggle_toolbar = document.getElementById("quicktabpreftoggle-button");
  }catch(e){
    QuickTabPrefToggle_toolbar = null;
  }
  if(QuickTabPrefToggle_toolbar != null && gQuickTabPrefToggle_user_Toggled == true){
      QuickTabPrefToggle_toolbar.setAttribute("tooltiptext", "Toggled Mode ON");
    }
  
}
