/* ***************
// quicknote.js (tabwidth=2)
// Implementation file for QuickNote  <http://quicknote.mozdev.org/>
//
// Author: Jed Brown (quicknote@jedbrown.net)
// Additional code taken from Cdn's Chrome Edit extension.
// Contributors:
//   Nickolay Ponomarev (asqueella@yahoo.com)
//   Leung WC
//   ...
//
// Version: 0.5.5+ dev
//
// Todo: investigate which one of nsPreferences/Quicknote_pref we should use (or both?)
// (asq) I'm inclined to replace all QN_pref with nsPreferences for the sake of consistency...
****************** */
const QN_notesCount = 4;
// Note, that despite all these arrays being 0-based,
// we actually use items [1..QN_notesCount] and do not use the 0th item.
var QN_tabFile = Array(QN_notesCount+1); //Path to the text files
var QN_tabName = Array(QN_notesCount+1); //Name of the Note Tabs

// Variables holding user's visual customizations (per note)
// hope that noone else has chosen these names yet...
// (I'm going to resolve it a little later)
var QN_padFontSize = Array(QN_notesCount+1);
var QN_padFontName = Array(QN_notesCount+1);
var QN_padFontColor = Array(QN_notesCount+1);
var QN_padUserStyle = Array(QN_notesCount+1);
var QN_padBackColor = Array(QN_notesCount+1);

var QN_charsLeft = Array(5); // ..until autosave (when qnautosave>0)

// Desc: QN_noteLength[X] = PadX.textLength
//       Used in autosave impl.
// Note: Do not rely on this prop. value (since it isn't always in sync with
// PadX.textLength).
var QN_noteLength = Array(5);

var howtopenQN;
var numberoftabs;
var QuickNote_saveCharset;
var QNLastTabOpened;
var QN_autosave;

// quicknote's document object (inserted here, because simple
// 'document.something' doesn't work when a function is
// called from a global overlay (such as overlay.xul) )
var QN_Document=null;

var QN_hideButtonBox;

const QuickNote_pref = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
try {
  // These will not be set on first QN load so it will except here.
  var tabtosendto = QuickNote_pref.getIntPref("quicknote.totabint", null);
  var qnfirststart = QuickNote_pref.getBoolPref("quicknote.firststart");
  var qnshowurl = QuickNote_pref.getBoolPref("quicknote.showUrl");
  numberoftabs = QuickNote_pref.getIntPref("quicknote.numtabs");
  howtopenQN = QuickNote_pref.getIntPref("quicknote.openqn");

  for(var i=1; i<=QN_notesCount; i++) {
    QN_tabFile[i] = nsPreferences.getLocalizedUnicharPref("quicknote.tab"+i+"path");
    QN_padFontSize[i] = QuickNote_pref.getIntPref("quicknote.fontsize"+i);
    QN_padFontName[i] = QuickNote_pref.getCharPref("quicknote.fontname"+i);
    QN_padFontColor[i] = QuickNote_pref.getCharPref("quicknote.fontcolor"+i);
    QN_padUserStyle[i] = QuickNote_pref.getCharPref("quicknote.userstyle"+i);
    QN_padBackColor[i] = QuickNote_pref.getCharPref("quicknote.bgcolortab"+i);
  }
} catch (e) {
  // foobar! This lets us continue.
  // Now lets set the defaults
  // This will allow us to clean up the qnsettings.js file (Not done yet)
  howtopenQN = nsPreferences.setIntPref("quicknote.openqn","1");
  numberoftabs = nsPreferences.setIntPref("quicknote.numtabs","2");

  for(var i=1; i<=QN_notesCount; i++) {
    QN_tabFile[i] = nsPreferences.setUnicharPref("quicknote.tab"+i+"path", "Blank");
    QN_padFontSize[i] = nsPreferences.setIntPref("quicknote.fontsize"+i, "12");
    QN_padFontName[i] = nsPreferences.setUnicharPref("quicknote.fontname"+i, "Verdana,sans-serif");
    QN_padFontColor[i] = nsPreferences.setUnicharPref("quicknote.fontcolor"+i, "black");
    QN_padUserStyle[i] = nsPreferences.setUnicharPref("quicknote.userstyle"+i, "");
    QN_padBackColor[i] = nsPreferences.setUnicharPref("quicknote.bgcolortab"+i, "#FFFF99");
  }
}

try {
// This pref is now set on first load, so to not break the current Settings UI.
  QuickNote_saveCharset = QuickNote_pref.getCharPref("quicknote.charset");
} catch(e) {
  QuickNote_saveCharset = 'UTF-8';
  nsPreferences.setUnicharPref("quicknote.charset", QuickNote_saveCharset);
}

try {
  // Get/Set Tab Values
  // TODO: these to go to the main try{}catch
  // ?? maybe we should do it before 0.6?
  QN_tabName[1] = QuickNote_pref.getCharPref("quicknote.tab1name");
  QN_tabName[2] = QuickNote_pref.getCharPref("quicknote.tab2name");
  QN_tabName[3] = QuickNote_pref.getCharPref("quicknote.tab3name");
  QN_tabName[4] = QuickNote_pref.getCharPref("quicknote.tab4name");
} catch(e) {
  QN_tabName[1] = nsPreferences.setUnicharPref("quicknote.tab1name", "Note 1");
  QN_tabName[2] = nsPreferences.setUnicharPref("quicknote.tab2name", "Note 2");
  QN_tabName[3] = nsPreferences.setUnicharPref("quicknote.tab3name", "Note 3");
  QN_tabName[4] = nsPreferences.setUnicharPref("quicknote.tab4name", "Note 4");
}

 
try {
// todo -oasq: this doesn't work ok when quicknote.lasttabopen is not set.
// (investigate) when you set a pref in prefs.js [for the first time; 
// manually], both get&set work not as one would expect..
  QNLastTabOpened = QuickNote_pref.getIntPref('quicknote.lasttabopen', null);

  //autosave options:
  // Value   Desc
  //  >0      autosave every X chars & on close
  //  =0      do not autosave while typing
  //  <0      no autosave at all -- TODO: implement save confirms on unLoad?
  QN_autosave = QuickNote_pref.getIntPref("quicknote.autosave");
  QN_hideButtonBox = QuickNote_pref.getBoolPref("quicknote.hidebuttonbox");
} catch(e) {
  QNLastTabOpened = 1;
  QN_autosave = nsPreferences.setIntPref("quicknote.autosave", "10");
  QN_hideButtonBox = nsPreferences.setBoolPref("quicknote.hidebuttonbox", true);
}

function QuickNote_closeWindow()
{
  window.close();
}


////////////////////////////////////////////////////////////////////////////////
// OnLoad
//
// Desc: Starts everyting (loading, Tab Labels, caught text, etc.)
// Parameters: Pad to copy the selection (via arguments[0])
// Returns: nothing
////////////////////////////////////////////////////////////////////////////////
function QuickNote_OnLoad() {
// TODO -p5: find out what is the default state for *.collapsed
// (asq) actually I thought it was true for 3rd & 4th; false for 1st and 2nd.
// I also suspect that each time OnLoad is triggered, the new instance of .xul/.js and therefore
// of all the objects, including textboxes is created, so some of these statements /are/ redundant
// I was too lazy, however, to check that out, so I ended up adding this comment ;)
// (jed) No worries, it's not really a priority, well figure it out sooner or later.


//-- set up XUL attributes depending on prefs
  QN_Document = document;
  var i;
  if(QN_hideButtonBox == false)
  {
    for(i=1; i<=QN_notesCount; i++)
      window.document.getElementById("buttonbox"+i).hidden = false;
  }

  for(i=1; i<=numberoftabs; i++)
    document.getElementById("Tab"+i).collapsed = false;
  for(i=numberoftabs+1; i<=QN_notesCount; i++)
    document.getElementById("Tab"+i).collapsed = true;

//-- load notes
  for(i=1; i<=QN_notesCount; i++)
    QuickNote_loadNote(i);

  if(!qnfirststart) {
    alert("Welcome to QuickNote:\n" +
          "This is your first time using QN.\n" +
          "Please set your preferences and re-load QuickNote!");
    window.close();
    window.open('qnsettings.xul', 'QuickNote - Settings',
                'chrome,centerscreen,resizable');
    return;
  }

  // now catch the text sent to QuickNote via context menu item
  // "Send .. to QuickNote" (if any [text])
  var textRecipent = null; // for now; see catchText comment
  try {
    textRecipent = QuickNote_catchText(window.arguments[0]);
  } catch(e) {
  }

  if(!textRecipent) {
    // Gets the last tab that was opened and sets
    // the tab to focus via selectedIndex
    document.getElementById("qntabs").selectedIndex = QNLastTabOpened-1;
    var thePadId = "Pad" + QNLastTabOpened;
    var thePad = document.getElementById(thePadId);
    thePad.focus();
  } // otherwise focus goes to the tab that caught the text
}

// this function must be called from global overlays (ie. those that do not
// overlay the QuickNote window, eg. overlay.xul) prior to any other qn.js
// functions.
function QuickNote_setupDocument(doc)
{
  QN_Document = doc;
}


////////////////////////////////////////////////////////////////////////////////
// openQuickNote()
// Desc: Opens QuickNote depending on set pref ('.openqn')
////////////////////////////////////////////////////////////////////////////////
function QuickNote_openQuickNote() {
  howtopenQN = null;
  try {
    howtopenQN = QuickNote_pref.getIntPref('quicknote.openqn', null);
  } catch (e) { // foobar!
  }

  if(howtopenQN == '0') {
    toggleSidebar('viewQuickNoteSidebar');
    return;
  }
  	if(howtopenQN == '2'){
      QuickNote_openQuickNoteInTab();
        
	}
  // default:
  openQNFloat();
}

// Open QuickNote as a tab 
//### taken from Download Manager Tweak dmextension.mozdev.org
function  QuickNote_openQuickNoteInTab(){
        var numTabs = gBrowser.mTabContainer.childNodes.length;
        var index = 0;
        var oldTab = getBrowser().selectedTab;
    
        if (oldTab.getAttribute('QuickNote') == 'true') {
        if (getWebNavigation().currentURI.spec == "chrome://quicknote/content/quicknote.xhtml") {
            BrowserCloseTabOrWindow();
            return;
          }
          else oldTab.removeAttribute('QuickNote');
        }
    
        var tempTab = null;
        while (index < numTabs) {
          tempTab = gBrowser.mTabContainer.childNodes[index];
    
          if (tempTab.getAttribute('QuickNote') == 'true') {
            if (tempTab.label == 'QuickNote' || tempTab.label == 'chrome://quicknote/content/quicknote.xhtml'){ 
              getBrowser().selectedTab = tempTab;
              break;
            }else {
              getBrowser().selectedTab = tempTab;
              var url = getWebNavigation().currentURI.spec;
              if (url == 'chrome://quicknote/content/quicknote.xhtml') break;
              else tempTab.removeAttribute('QuickNote');
          }
        }
          else index = index+1;
        }
    
        // If no QuickNote tab is open, then create one
        if (index == numTabs) {
          var QuickNoteTab = gBrowser.addTab('chrome://quicknote/content/quicknote.xhtml');
          QuickNoteTab.setAttribute('QuickNote', 'true');
          getBrowser().selectedTab = QuickNoteTab;
        }
}


// toUnicode()
//  convert given string (s) from QuickNote_saveCharset to Unicode, which
//  will then be used in the QN editboxes
//Contributed by Leung WC
function toUnicode(s) {
  const UConvID = '@mozilla.org/intl/scriptableunicodeconverter';
  const UConvIF  = Components.interfaces.nsIScriptableUnicodeConverter;
  const UConv = Components.classes[UConvID].getService(UConvIF);
  UConv.charset = QuickNote_saveCharset;
  var out = UConv.ConvertToUnicode(s);
  return out;
}
//
//Contributed by Leung WC
function fromUnicode(s) {
  const UConvID = '@mozilla.org/intl/scriptableunicodeconverter';
  const UConvIF  = Components.interfaces.nsIScriptableUnicodeConverter;
  const UConv = Components.classes[UConvID].getService(UConvIF);
  UConv.charset = QuickNote_saveCharset;
  var out = UConv.ConvertFromUnicode(s);
  return out;
}

function QuickNote_getTextareaText(tNodeID) {
  var tat = fromUnicode(QN_Document.getElementById(tNodeID).value);
  return tat;
}

function QuickNote_setTextareaText(thetext,tNodeID) {
  QN_Document.getElementById(tNodeID).value = toUnicode(thetext);
}


// applies visual customizations for a tab (bgcolor, fonts, tab names etc.)
function QuickNote_applyCustomizations(Note) {
  var NodeID = "Pad" + Note;
  var thePad = QN_Document.getElementById(NodeID);
  var oldStyles = thePad.getAttribute("style");
  thePad.setAttribute("style",
    oldStyles + " " +
    "font: " + QN_padFontSize[Note].toString() + "px " + QN_padFontName[Note] + "; "+
    "color:" + QN_padFontColor[Note] + "; " +
    "-moz-appearance: none; background-color: "+ QN_padBackColor[Note] + "; " +
    QN_padUserStyle[Note]);
  QN_Document.getElementById("Tab"+Note).label = QN_tabName[Note];
}

////////////////////////////////////////////////////////////////////////////////
// loadNote()
//
// Desc: This function decides whether to load user defined files or create 
//       new quicknote[1-4].txt in the profile chrome directory.
// Params: Note - which note to load (1..4)
////////////////////////////////////////////////////////////////////////////////
function QuickNote_loadNote(Note) {
  var userTabpath = QN_tabFile[Note];
  if( !userTabpath || userTabpath=='Blank' )
    QuickNote_setDefaultFile(Note);
  else
    QuickNote_loadAFile(userTabpath, Note);
}

////////////////////////////////////////////////////////////////////////////////
// setDefaultFile()
//
// Desc: Used for loading the default Profile Notes, sets the dir and calls 
//       loadFromFile() to actually load the files.
// Parameters: 
//    Note: Where it is headed to (1..4)
////////////////////////////////////////////////////////////////////////////////
function QuickNote_setDefaultFile(Note) {//!! review/cleanup
  var fileName = "quicknote" + Note + ".txt";
  var d = new DirUtils;
  var UserChrome = d.getUserChromeDir();
  var f = new File(UserChrome);
  var target = f.nsIFile;
  target.append(fileName);
  f = new File(target.path);

  var targetNodeID = "Pad" + Note;
  if(f.exists())
  {  // if file already exists then just open it.
    QuickNote_loadFromFile(f,Note);
    nsPreferences.setUnicharPref('quicknote.tab'+Note+'path', f.path);
  } else if(!f.exists())
  { // If it doesn't exist, create the file, then make sure it exists, then open.
    f.create();
    if (f.exists()) {
      QuickNote_loadFromFile(f,Note);
      nsPreferences.setUnicharPref('quicknote.tab'+Note+'path', f.path);
    } else { QuickNote_setTextareaText('// #2 Could not create ' + f.path + '\n// Please make sure you have the correct permissions or\n' +
        '// you can choose where to store your notes in the QuickNote Settings (right click on a note tab).',
        targetNodeID);
    }
  }
}


////////////////////////////////////////////////////////////////////////////////
// loadAFile
//
// Desc: Loads userdefined files (set in prefs), and sets the user visual 
//       customizations (color, size, bgcolor, etc.)
// Parameters: 
//    userFileName: The name and location of the file to load.
//    Note: Where it is headed to (1..4)
// Returns: true or false
////////////////////////////////////////////////////////////////////////////////
function QuickNote_loadAFile(userFileName, Note) {
  QuickNote_applyCustomizations(Note);
  if(!userFileName || userFileName=='Blank') { //todo: edit this message
    QuickNote_setTextareaText('//No file has been found!\n'+
      ' This could be caused by:\n'+
      ' 1) You have not re-opened QuickNote\n'+
      ' 2) You need to set your user File in the Preferences\n'+
      ' 3) or the archive you chose is invalid.\n'+
      ' If you have done all these and still get an error, '+
      'please contact the author at http://quicknote.mozdev.org', 'Pad'+Note);
    return false;
  }

  var f = new File(userFileName);
  var target = f.nsIFile;
  f = new File(target.path);

  if (f.exists()) {  //If file already exists then just open it.
    QuickNote_loadFromFile(f, Note);
  } else { //If it doesn't exist, tell the user
    QuickNote_setTextareaText('// #5 File ' + f.path + ' is invalid or '+
      'does not exist.', 'Pad'+Note);
  }
  return true;
}

////////////////////////////////////////////////////////////////////////////////
// loadFromFile
// Desc: Actually loads the file thanks to JSLib
// Parameters:
//    f: File (JSLib)
//    Note: where the file should be loaded to (1..4)
// Returns: true if file saved, false otherwise
////////////////////////////////////////////////////////////////////////////////
// load from f (of type File) f to the node specified with targetNodeID.
function QuickNote_loadFromFile(f,Note) {
  try {
    QN_charsLeft[Note] = QN_autosave;
    f.open();
    var stuff = f.read();
    f.close();
    QuickNote_setTextareaText(stuff,"Pad"+Note);
    QN_noteLength[Note] = QN_Document.getElementById("Pad"+Note).textLength;
  } catch(e) {
    QuickNote_setTextareaText('// #7 failed to load a file.\n'+
      '//Hint: make sure it exists and is in '+QuickNote_saveCharset+' charset.',"Pad"+Note);
  }
}



////////////////////////////////////////////////////////////////////////////////
// renameCurrentTab
//
// Desc: Rename the current Tab
// Sets prefs quicknote.tab1name, .tab2name, etc.
////////////////////////////////////////////////////////////////////////////////
function QuickNote_renameCurrentTab() {
  var Note = QN_Document.getElementById("qntabs").selectedIndex+1;//current note number
  var currentTabName = QN_Document.getElementById("tabbox").selectedTab.label;
  var newTabName;

  newTabName = prompt('Please type in a new note name for ' + currentTabName, currentTabName);
  if(newTabName == null)
    newTabName = currentTabName;

  QN_Document.getElementById("tabbox").selectedTab.label = newTabName; //Dynamically Set Name.

  var prefName = "quicknote.tab" + Note + "name"; // pref 'quicknote.tab#name'
  nsPreferences.setUnicharPref(prefName, newTabName);
}


// returns the number of current note
function QN_currentNote()
{
  return QN_Document.getElementById("qntabs").selectedIndex+1;
}

////////////////////////////////////////////////////////////////////////////////
// saveCurrent
//
// Desc: Saves the active pad to a corresponding file through a call to saveNote
//       Used for Ctrl+S ('Save Current Note') handling.
////////////////////////////////////////////////////////////////////////////////
function QuickNote_saveCurrent()
{
  QuickNote_saveNote(QN_Document.getElementById("qntabs").selectedIndex+1);//selIndex is 0-based!
}


////////////////////////////////////////////////////////////////////////////////
// saveAll
// Desc: Saves all tabs using SaveNote
////////////////////////////////////////////////////////////////////////////////
function QuickNote_saveAll()
{
  for(var i=1; i<=QN_notesCount; i++)
    QuickNote_saveNote(i);
}

////////////////////////////////////////////////////////////////////////////////
// saveNote
//
// Desc: Saves a note. Utilized the saveAFile function for actual saving
// Parameters: Note - the number of the note to be save (1..4)
// Returns: nothing
////////////////////////////////////////////////////////////////////////////////
function QuickNote_saveNote(Note) {
  var fName = QN_tabFile[Note];
  var p = QuickNote_saveAFile(fName, Note);
  if(p) {
    QN_charsLeft[Note] = QN_autosave;
    QN_Document.getElementById('save'+Note).setAttribute('disabled', 'true');
  }
}

////////////////////////////////////////////////////////////////////////////////
// autoSave()
//
// Desc: Auto-save on close function.
//       Saves all the [modified] files via saveNote().
//       Also saves the active tab information.
////////////////////////////////////////////////////////////////////////////////
function QuickNote_autoSave() {
  QNLastTabOpened = nsPreferences.setIntPref('quicknote.lasttabopen',
    QN_Document.getElementById("qntabs").selectedIndex+1);//note that selIndex is 0-based.

  if(QN_autosave < 0)
    return;

  for(var i=1; i<=QN_notesCount; i++) {
    if (!QN_Document.getElementById('save'+i).hasAttribute('disabled'))
      QuickNote_saveNote(i);
  }
}

////////////////////////////////////////////////////////////////////////////////
// onClose()
//  used when 'no autosave' option is selected
//  shows a dialog to let user select the notes he wishes to save
////////////////////////////////////////////////////////////////////////////////
function QuickNote_onClose()
{
  // since this file is used in global overlay (overlay.xul), we need to check
  // if the prefs have changed.
  // xxx the same issue may show up elsewhere
  QN_autosave = QuickNote_pref.getIntPref("quicknote.autosave");

  if(QN_autosave < 0) {
    // we get ok/cancel return value from the dialog through re.val
    var re = {};
    var Show = Array(5);  //whether the i-th note was available in QuickNote
    var Save = Array(5);  //was it modified?
    var Changed = false;  //anything modified?
    var i;
    
    for(i=1;i<=numberoftabs;i++)       Show[i] = true;
    for(i=numberoftabs+1;i<=4;i++)     Show[i] = false;
    for(i=1; i<=4; i++)
    {
      Save[i] = !QN_Document.getElementById('save'+i).hasAttribute('disabled');
      Changed = Changed || Save[i];
    }
    if(!Changed) return true; // everything is already saved => close right away
    
    window.openDialog("chrome://quicknote/content/qnconfirmsave.xul",
      "qnconfirmsave","chrome,modal,centerscreen",re,Show,QN_tabName,Save);
    if(!re.val)       // cancel: don't close QuickNote
      return false;
    else {            // ok: save the selected notes
      for(i=1; i<=4; i++)
        if(Save[i])
          QuickNote_saveNote(i);
    }
  }
  return true;
}

// onInput()
// Desc: "autosave every X characters" function.
// Note: deltaLen et al were introduced to handle pasting large text blocks
// from clipboard correctly and reliably
function QN_onInput(Note) {
  var thePad = QN_Document.getElementById("Pad" + Note);
  if(QN_autosave > 0) // if autosave as you type is enabled...
  {
    var deltaLen = Math.abs(QN_noteLength[Note]-thePad.textLength);
    QN_charsLeft[Note] = QN_charsLeft[Note] - Math.max(deltaLen,1);
    if(QN_charsLeft[Note] <= 0) { // it's time to auto-save the note
      QuickNote_saveNote(Note);
    } else {
      QN_Document.getElementById('save' + Note).removeAttribute('disabled');
    }
  } else
    QN_Document.getElementById('save' + Note).removeAttribute('disabled');
  QN_noteLength[Note] = thePad.textLength;
}


////////////////////////////////////////////////////////////////////////////////
// saveNoteAs
// Desc: Saves a Note to a user-defined location via saveAFile().
// Utilized saveAFile for actual saving.
//
// Parameters: Note: What to save (number, 1..4)
// Returns: true if list saved, false otherwise
//
// Originally Modeled after the SaveAs code from Tagzilla.mozdev.org!
////////////////////////////////////////////////////////////////////////////////
function QuickNote_saveNoteAs(Note) {
  var d = new DirUtils;
  var myUserDirPlease = d.getUserChromeDir();
  var fName = QuickNote_txtFilePicker("Save the note as", 1, myUserDirPlease);
  if(fName == null) {
    return false;
  }

  var isSaved = QuickNote_saveAFile(fName, Note);
  return isSaved;
}


////////////////////////////////////////////////////////////////////////////////
// saveAFile
// Desc: Actually does the filesaving thanks to JSLib
// Parameters:
//    aUrl: string name of file to save, in platform-specific or file:// format
//    Note: where the data is to save (1..4)
// Returns: true if file saved, false otherwise
////////////////////////////////////////////////////////////////////////////////
function QuickNote_saveAFile(aUrl, Note) {
  var aFile = aUrl;
  if(aUrl.substring(0,7) == "file://") {
    var fUtils = new FileUtils();
    aFile = fUtils.urlToPath(aUrl);
  }

  var f = new File(aFile);
  if(!f.open("w")) {
    alert('File ' + aFile + ' could not be opened!');
    return false;
  }

  var data = QuickNote_getTextareaText("Pad" + Note);
  var p;
  // File::write() returns false if data==null
  // Still it is ok to save a blank file
  // (Note:  File::open('w') overwrites the file if it already exists)
  if(data) {
    p = f.write(data);
  } else {
    p = true;
  }
  f.close();
  return p;
}

////////////////////////////////////////////////////////////////////////////////
// catchText
//
// Desc: Catch text sent via context menu. Append it to the note specified with
//       tabtosendto.
// Parameters: QuickNote window; text to catch
// Returns: the tab-id which got the text; null when no text to catch.
// ?? return true/false ?? the return value is only tested against null...
////////////////////////////////////////////////////////////////////////////////
function QuickNote_catchText(text) {
  var target; // what node to send text to, 1..4

  if(tabtosendto)
    target = tabtosendto;
  else
    target = '1';

  if(text) {  // This is causing the extra /n to apear; todo
    QNLastTabOpened = nsPreferences.setIntPref('quicknote.lasttabopen', target);
    var Pad = QN_Document.getElementById("Pad" + target);
    Pad.value = Pad.value + "\n" + text + "\n";
    QuickNote_saveNote(target);//todo: am I sure? (when autosave is off, user might not want the note to be saved)

    // current behaviour is to pop the quicknote window on 'send text'
    // so we will also switch to the tab, that 'caught' the text:
    QN_Document.getElementById("qntabs").selectedIndex = target-1;
    Pad.focus();

    return "Pad" + target;
  }
  return null;
}



////////////////////////////////////////////////////////////////////////////////
// txtFilePicker
//
// Parameters:
//  aTitle: title to go on file picker window
//  aSave: 1 if picking file to save/overwrite, 0 if picking file to load
// No longer used. --> aStart: directory to start from No longer used.
// (kept as a resource)    This must be an nsILocalFile.  new Dir("foo") in jslib/io/dir.js will
//          do the trick, but you have to do it yourself.
// Returns:
//  Name of file picked, in URL format, or null if cancelled
// Original taken and modified from Tagzilla.mozdev.org!
////////////////////////////////////////////////////////////////////////////////
function QuickNote_txtFilePicker(aTitle, aSave) {
  var retVal = null;
  try {
    const nsIFilePicker = Components.interfaces.nsIFilePicker;
    var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
    fp.init(window, aTitle, (aSave ? nsIFilePicker.modeSave : nsIFilePicker.modeOpen));
    fp.appendFilters(nsIFilePicker.filterAll | nsIFilePicker.filterText);

    /*
    if(aStart) {
      fp.displayDirectory = aStart;
    }
    */
    var result=fp.show();
    if (result == nsIFilePicker.returnOK || result == nsIFilePicker.returnReplace) {
      //retVal=fp.fileURL.spec;
      retVal=fp.file.path;
    }
  }
  catch (e) {
  }
  return retVal;
}


/*
////////////////////////////////////////////////////////////////////////////////
// mailIt
//  **********NOT IN USE YEST*******
// Parameters:
//  targetNodeID: where the data is to save!
// Returns: true
// To-Do: TESTING, can't get to get Thunderbird to load a Compose window
// Haven't tested since TB 0.1. Will do after 0.6 is released
////////////////////////////////////////////////////////////////////////////////
function QuickNote_qnMailWindow(targetNodeID) {
  var QNmailText = QuickNote_getTextareaText(targetNodeID).value;
  window.openDialog("chrome://quicknote/content/mail.xul",
      "_blank", "chrome,all,dialog", QNmailText);
  return true;
}
*/

