/////////////////////////////////////////////////////
// .value

// var pref = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
const QuickNote_pref = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
function QuickNote_quitInstance(){
	// goQuitApplication() found in chrome://global/content/globalOverlay.js
	goQuitApplication();
}
function QuickNote_onUninstall(){

	if(confirm("Uninstall the QuickNote extension?")){
	var unreg = new exUnregisterer(	'chrome://quicknote/content/contents.rdf',
									'jar:%chromeFolder%quicknote.jar!/skin/classic/externalapp/contents.rdf',
									'jar:%chromeFolder%quicknote.jar!/locale/en-US/externalapp/contents.rdf');
	unreg.unregister();
	alert("Uninstallation almost complete.\n Please make sure that no instances of QuickNote are running including the sidebar.\n If so, please close them now and click ok to continue.");
	}else{
		window.close();
	}
	
	if(!confirm("Do you want to save your QN prefs? Cancel will delete the prefs.")) {
		unreg.removePrefs('quicknote');
	}	
	
	if(confirm("It is recommended that you restart your application\n To do to so now click OK, if you still have unsaved work click CANCEL."))
	{
	    QuickNote_quitInstance();
	}
	
	window.close();
}


// On load of window (for new users will load first time )
// Makes sure the needed prefs are set on OK, and loads default values.

function QuickNote_loadQNSettings()
{
   
    // Set how many TABS (notes) are shown to the user (default are 2)
   if(!QuickNote_pref.prefHasUserValue('quicknote.numtabs') || QuickNote_pref.getIntPref('quicknote.numtabs') == '0')
   {
	   document.getElementById('numtab-2').setAttribute('selected', true);
	   QuickNote_pref.setIntPref('quicknote.numtabs', 2);
	   document.getElementById('QNTabTwoFileB').collapsed = false;
	   document.getElementById('choose-tab2').disabled = false;
	   document.getElementById('tabadvanced2').collapsed = false;
   }else {
	   if(QuickNote_pref.getIntPref('quicknote.numtabs') == 2)
	   {
		   document.getElementById('numtab-2').setAttribute('selected', true);
		   document.getElementById('QNTabTwoFileB').collapsed = false;
		   document.getElementById('choose-tab2').disabled = false;
		   document.getElementById('tabadvanced2').collapsed = false;
	   }
	   if(QuickNote_pref.getIntPref('quicknote.numtabs') == 3)
	   {
		   document.getElementById('numtab-3').setAttribute('selected', true);
		   document.getElementById('QNTabTwoFileB').collapsed = false;
		   document.getElementById('QNTabThreeFileB').collapsed = false;
		   
		   document.getElementById('choose-tab2').disabled = false;
		   document.getElementById('choose-tab3').disabled = false;
		   
		   document.getElementById('tabadvanced2').collapsed = false;
		   document.getElementById('tabadvanced3').collapsed = false;
	   }
	   if(QuickNote_pref.getIntPref('quicknote.numtabs') == 4)
	   {
		   //Show/Hide Tab File Boxes
		   document.getElementById('numtab-4').setAttribute('selected', true);
		   document.getElementById('QNTabTwoFileB').collapsed = false;
		   document.getElementById('QNTabThreeFileB').collapsed = false;
		   document.getElementById('QNTabFourFileB').collapsed = false;
		   
		   document.getElementById('choose-tab2').disabled = false;
		   document.getElementById('choose-tab3').disabled = false;
		   document.getElementById('choose-tab4').disabled = false;
		   
		   document.getElementById('tabadvanced2').collapsed = false;
		   document.getElementById('tabadvanced3').collapsed = false;
		   document.getElementById('tabadvanced4').collapsed = false;
	   }
	   if(QuickNote_pref.getIntPref('quicknote.numtabs') == 1)
	   {
		   document.getElementById('numtab-1').setAttribute('selected', true);
	   }
    }	   
   // ## Get Font Size, Colour and Type
   try{
   document.getElementById('QNTabOneFontColor').color = QuickNote_pref.getCharPref('quicknote.fontcolor1');
   document.getElementById('QNTabOneFontsizetb').value = QuickNote_pref.getIntPref('quicknote.fontsize1');
   document.getElementById('QNTabOneFontName').value = QuickNote_pref.getCharPref('quicknote.fontname1');
   document.getElementById('UserStyleDefTab1').value = QuickNote_pref.getCharPref('quicknote.userstyle1');
   document.getElementById('QNTabOneBGColor').color = QuickNote_pref.getCharPref('quicknote.bgcolortab1');
   
   document.getElementById('QNTabTwoFontColor').color = QuickNote_pref.getCharPref('quicknote.fontcolor2');
   document.getElementById('QNTabTwoFontsizetb').value = QuickNote_pref.getIntPref('quicknote.fontsize2');
   document.getElementById('QNTabTwoFontName').value = QuickNote_pref.getCharPref('quicknote.fontname2');
   document.getElementById('UserStyleDefTab2').value = QuickNote_pref.getCharPref('quicknote.userstyle2');
   document.getElementById('QNTabTwoBGColor').color = QuickNote_pref.getCharPref('quicknote.bgcolortab2');
   
   document.getElementById('QNTabThreeFontColor').color = QuickNote_pref.getCharPref('quicknote.fontcolor3');
   document.getElementById('QNTabThreeFontsizetb').value = QuickNote_pref.getIntPref('quicknote.fontsize3');
   document.getElementById('QNTabThreeFontName').value = QuickNote_pref.getCharPref('quicknote.fontname3');
   document.getElementById('UserStyleDefTab3').value = QuickNote_pref.getCharPref('quicknote.userstyle3');
   document.getElementById('QNTabThreeBGColor').color = QuickNote_pref.getCharPref('quicknote.bgcolortab3');
   
   document.getElementById('QNTabFourFontColor').color = QuickNote_pref.getCharPref('quicknote.fontcolor4');
   document.getElementById('QNTabFourFontsizetb').value = QuickNote_pref.getIntPref('quicknote.fontsize4');
   document.getElementById('QNTabFourFontName').value = QuickNote_pref.getCharPref('quicknote.fontname4');
   document.getElementById('UserStyleDefTab4').value = QuickNote_pref.getCharPref('quicknote.userstyle4');
   document.getElementById('QNTabFourBGColor').color = QuickNote_pref.getCharPref('quicknote.bgcolortab4');
   
   } catch (e){
	   //Foobar!
   }

   
   
   // ## Sets the "Send To.." options! And language support options. ##	
   if(!QuickNote_pref.prefHasUserValue('quicknote.totabint'))
   {
   	QuickNote_pref.setIntPref('quicknote.totabint', '1');
	document.getElementById('choose-tab1').setAttribute('selected', true);
	
   }else{
	if (QuickNote_pref.getIntPref('quicknote.totabint') == 2)
	{
	    document.getElementById('choose-tab2').setAttribute('selected', true);
	}
	if (QuickNote_pref.getIntPref('quicknote.totabint') == 3)
	{
	    document.getElementById('choose-tab3').setAttribute('selected', true);
	}
	if (QuickNote_pref.getIntPref('quicknote.totabint') == 4)
	{
	    document.getElementById('choose-tab4').setAttribute('selected', true);
	}
	if (QuickNote_pref.getIntPref('quicknote.totabint') == 1)
	{
	    document.getElementById('choose-tab1').setAttribute('selected', true);
	}
 }
        // ## User Files Paths  ##
  if ( !QuickNote_pref.prefHasUserValue('quicknote.tab1path') ){
		QuickNote_pref.setCharPref('quicknote.tab1path', "Blank");
		document.getElementById('QNTabOneFile').value =	QuickNote_pref.getCharPref('quicknote.tab1path');
	}else{
		document.getElementById('QNTabOneFile').value =	QuickNote_pref.getCharPref('quicknote.tab1path');
	}
	
	if ( !QuickNote_pref.prefHasUserValue('quicknote.tab2path') ){
		QuickNote_pref.setCharPref('quicknote.tab2path', "Blank");
		document.getElementById('QNTabTwoFile').value =	QuickNote_pref.getCharPref('quicknote.tab2path');
	}else{
		document.getElementById('QNTabTwoFile').value =	QuickNote_pref.getCharPref('quicknote.tab2path');
	}
	
	if ( !QuickNote_pref.prefHasUserValue('quicknote.tab3path') ){
		QuickNote_pref.setCharPref('quicknote.tab3path', "Blank");
		document.getElementById('QNTabThreeFile').value = QuickNote_pref.getCharPref('quicknote.tab3path');
	}else{
		document.getElementById('QNTabThreeFile').value = QuickNote_pref.getCharPref('quicknote.tab3path');
	}
	
	if ( !QuickNote_pref.prefHasUserValue('quicknote.tab4path') ){
		QuickNote_pref.setCharPref('quicknote.tab4path', "Blank");
		document.getElementById('QNTabFourFile').value = QuickNote_pref.getCharPref('quicknote.tab4path');
	}else{
		document.getElementById('QNTabFourFile').value = QuickNote_pref.getCharPref('quicknote.tab4path');
	}
	
	// ## Send to Text URL  ##
	if (QuickNote_pref.prefHasUserValue('quicknote.showUrl'))
	{
    if(QuickNote_pref.getBoolPref('quicknote.showUrl') == true){
      document.getElementById('qn-sendtotextUrl').setAttribute('checked', true);
    }
	}
  
  
  // ## Show Save and Save All Buttons  ##
	if (QuickNote_pref.getBoolPref('quicknote.hidebuttonbox') == false)
	{
	    document.getElementById('showButtons').setAttribute('checked', true);
	}
  // ##AutoSave Prefs ##
  if (QuickNote_pref.getIntPref('quicknote.autosave') == 0)
	{
	    document.getElementById('onclose').setAttribute('selected', true);
      document.getElementById('xthCharTB').disabled = true;
      document.getElementById('xthCharLabel').disabled = true;
	}else if (QuickNote_pref.getIntPref('quicknote.autosave') == -1)
	{
	    document.getElementById('noautosave').setAttribute('selected', true);
      document.getElementById('xthCharTB').disabled = true;
      document.getElementById('xthCharLabel').disabled = true;
	}else if (QuickNote_pref.getIntPref('quicknote.autosave') > 0){
    document.getElementById('onxchar').setAttribute('selected', true);
    document.getElementById('xthCharTB').value = QuickNote_pref.getIntPref('quicknote.autosave');
  }
  
  
   // ## File Encoding##
 	try {
    if(QuickNote_pref.prefHasUserValue('quicknote.charset')){
      document.getElementById('Encoding').value = QuickNote_pref.getCharPref('quicknote.charset');
    }    
  } catch(e) {
    document.getElementById('Encoding').value = 'UTF-8';
  }

  
	
	// Get FB toolbar button behavior only if in Firebird 
	if (navigator.userAgent.search(/Firebird/gi) == -1 && navigator.userAgent.search(/Firefox/gi) == -1 ) {
		if(navigator.userAgent.search(/Thunderbird/gi) == -1){
			document.getElementById("fbtbfunc-s").disabled = true;	
		}else{
			//UserAgent thanks to DeepestSender
			document.getElementById("fbtbfunc-s").disabled = true;                     
			document.getElementById("fbtbfunc-f").disabled = true;
			document.getElementById("fbtbfunc-t").disabled = true;
		}
	} else {		
		if (!QuickNote_pref.prefHasUserValue('quicknote.openqn'))
		{
			QuickNote_pref.setIntPref('quicknote.openqn', '1');
			document.getElementById('fbtbfunc-f').setAttribute('selected', true);
		}else{
			if (QuickNote_pref.getIntPref('quicknote.openqn') == 0)
			{
			    document.getElementById('fbtbfunc-s').setAttribute('selected', true);
			}
			if (QuickNote_pref.getIntPref('quicknote.openqn') == 1)
			{
			    document.getElementById('fbtbfunc-f').setAttribute('selected', true);
			}
			if (QuickNote_pref.getIntPref('quicknote.openqn') == 2)
			{
			    document.getElementById('fbtbfunc-t').setAttribute('selected', true);
			}
		}
	}
		
	
}

//On OK, sets the prefs chosen by the user.
function QuickNote_acceptQNSettings()
{
	if (document.getElementById('choose-tab2').getAttribute('selected') == 'true')
	{
		QuickNote_pref.setIntPref('quicknote.totabint', '2');
	}
	if (document.getElementById('choose-tab1').getAttribute('selected') == 'true'){
		QuickNote_pref.setIntPref('quicknote.totabint', '1');
	}
	if (document.getElementById('choose-tab3').getAttribute('selected') == 'true'){
		QuickNote_pref.setIntPref('quicknote.totabint', '3');
	}
	if (document.getElementById('choose-tab4').getAttribute('selected') == 'true'){
		QuickNote_pref.setIntPref('quicknote.totabint', '4');
	}
	
	var userTabOnepath = document.getElementById('QNTabOneFile').value;
	QuickNote_pref.setCharPref('quicknote.tab1path', userTabOnepath);
	
	var userTabTwopath = document.getElementById('QNTabTwoFile').value;
	QuickNote_pref.setCharPref('quicknote.tab2path', userTabTwopath);
	
	var userTabThreepath = document.getElementById('QNTabThreeFile').value;
	QuickNote_pref.setCharPref('quicknote.tab3path', userTabThreepath);
	
	var userTabFourpath = document.getElementById('QNTabFourFile').value;
	QuickNote_pref.setCharPref('quicknote.tab4path', userTabFourpath);
	
	if(!QuickNote_pref.prefHasUserValue('quicknote.firststart') || QuickNote_pref.getBoolPref('quicknote.firststart') == false){
		QuickNote_pref.setBoolPref('quicknote.firststart', true);
	}
	
	if (document.getElementById('qn-sendtotextUrl').getAttribute('checked') == 'true')
	{
		QuickNote_pref.setBoolPref('quicknote.showUrl', true);
	}else{
		QuickNote_pref.setBoolPref('quicknote.showUrl', false);
	}
  
   // ## Show Save and Save All Buttons  ##
	if (document.getElementById('showButtons').getAttribute('checked') == 'true')
	{
		QuickNote_pref.setBoolPref('quicknote.hidebuttonbox', false);
	}else{
		QuickNote_pref.setBoolPref('quicknote.hidebuttonbox', true);
	}
  
  // ##AutoSave Prefs ##
  if(document.getElementById('onclose').getAttribute('selected', true)){
    QuickNote_pref.setIntPref('quicknote.autosave', '0');
  }else if(document.getElementById('noautosave').getAttribute('selected', true)){
    QuickNote_pref.setIntPref('quicknote.autosave', '-1');
  }else{
    var AutosaveValue = document.getElementById('xthCharTB').value;
    QuickNote_pref.setIntPref('quicknote.autosave', AutosaveValue);
  }
  
  // ## File Encoding##
  if (document.getElementById('Encoding').value == ""){
    var QnEncodingType = "UTF-8";
    QuickNote_pref.setCharPref('quicknote.charset', QnEncodingType);
  }else{
    var QnEncodingType = document.getElementById('Encoding').value;
    QuickNote_pref.setCharPref('quicknote.charset', QnEncodingType);
  }
  
	
	// ## Sets Number of Tabs ##
	if (document.getElementById('numtab-1').getAttribute('selected') == 'true')
	{
		QuickNote_pref.setIntPref('quicknote.numtabs', '1');
	}
	else if(document.getElementById('numtab-2').getAttribute('selected') == 'true')
	{
		QuickNote_pref.setIntPref('quicknote.numtabs', '2');
	}
	
	else if(document.getElementById('numtab-3').getAttribute('selected') == 'true')
	{
		QuickNote_pref.setIntPref('quicknote.numtabs', '3');
	}
	else if(document.getElementById('numtab-4').getAttribute('selected') == 'true')
	{
		QuickNote_pref.setIntPref('quicknote.numtabs', '4');
	}
	
	// Set FB toolbar button behavior
	if (document.getElementById('fbtbfunc-s').getAttribute('selected') == 'true')
	{
	    QuickNote_pref.setIntPref('quicknote.openqn', '0');
	}
	else if (document.getElementById('fbtbfunc-f').getAttribute('selected') == 'true')
	{
	    QuickNote_pref.setIntPref('quicknote.openqn', '1');
	}
	else if (document.getElementById('fbtbfunc-t').getAttribute('selected') == 'true')
	{
	    QuickNote_pref.setIntPref('quicknote.openqn', '2');
	}
	
	//## Set Tab Font Colors
	try{
	var TabOneFontColor = document.getElementById('QNTabOneFontColor').color;
	QuickNote_pref.setCharPref('quicknote.fontcolor1', TabOneFontColor);
	var TabOneFontSize = document.getElementById('QNTabOneFontsizetb').value;
	QuickNote_pref.setIntPref('quicknote.fontsize1', TabOneFontSize);
	var TabOneFontName = document.getElementById('QNTabOneFontName').value;
	QuickNote_pref.setCharPref('quicknote.fontname1', TabOneFontName);
	var TabOneUserStyle = document.getElementById('UserStyleDefTab1').value;
	QuickNote_pref.setCharPref('quicknote.userstyle1', TabOneUserStyle);
	var TabOneBGColor = document.getElementById('QNTabOneBGColor').color;
	QuickNote_pref.setCharPref('quicknote.bgcolortab1', TabOneBGColor);
	
	var TabTwoFontColor = document.getElementById('QNTabTwoFontColor').color;
	QuickNote_pref.setCharPref('quicknote.fontcolor2', TabTwoFontColor);
	var TabTwoFontSize = document.getElementById('QNTabTwoFontsizetb').value;
	QuickNote_pref.setIntPref('quicknote.fontsize2', TabTwoFontSize);
	var TabTwoFontName = document.getElementById('QNTabTwoFontName').value;
	QuickNote_pref.setCharPref('quicknote.fontname2', TabTwoFontName);
	var TabTwoUserStyle = document.getElementById('UserStyleDefTab2').value;
	QuickNote_pref.setCharPref('quicknote.userstyle2', TabTwoUserStyle);
	var TabTwoBGColor = document.getElementById('QNTabTwoBGColor').color;
	QuickNote_pref.setCharPref('quicknote.bgcolortab2', TabTwoBGColor);
	
	var TabThreeFontColor = document.getElementById('QNTabThreeFontColor').color;
	QuickNote_pref.setCharPref('quicknote.fontcolor3', TabThreeFontColor);
	var TabThreeFontSize = document.getElementById('QNTabThreeFontsizetb').value;
	QuickNote_pref.setIntPref('quicknote.fontsize3', TabThreeFontSize);
	var TabThreeFontName = document.getElementById('QNTabThreeFontName').value;
	QuickNote_pref.setCharPref('quicknote.fontname3', TabThreeFontName);
	var TabThreeUserStyle = document.getElementById('UserStyleDefTab3').value;
	QuickNote_pref.setCharPref('quicknote.userstyle3', TabThreeUserStyle);
	var TabThreeBGColor = document.getElementById('QNTabThreeBGColor').color;
	QuickNote_pref.setCharPref('quicknote.bgcolortab3', TabThreeBGColor);
	
	var TabFourFontColor = document.getElementById('QNTabFourFontColor').color;
	QuickNote_pref.setCharPref('quicknote.fontcolor4', TabFourFontColor);
	var TabFourFontSize = document.getElementById('QNTabFourFontsizetb').value;
	QuickNote_pref.setIntPref('quicknote.fontsize4', TabFourFontSize);
	var TabFourFontName = document.getElementById('QNTabFourFontName').value;
	QuickNote_pref.setCharPref('quicknote.fontname4', TabFourFontName);
	var TabFourUserStyle = document.getElementById('UserStyleDefTab4').value;
	QuickNote_pref.setCharPref('quicknote.userstyle4', TabFourUserStyle);
	var TabFourBGColor = document.getElementById('QNTabFourBGColor').color;
	QuickNote_pref.setCharPref('quicknote.bgcolortab4', TabFourBGColor);

	}catch(e){
		//Foobar!
	}
	alert("Some Settings may require either restarting QuickNote, or restarting the XUL application.");
	
	window.close();
}

//Show Hide tab prefs Dynamically!
function QuickNote_showHideTabPaths()
{
    if( document.getElementById('numtab-1').getAttribute('selected') )
    {
	   // ## User File box ##
	   document.getElementById('QNTabTwoFileB').collapsed = true;
	   document.getElementById('QNTabThreeFileB').collapsed = true;
	   document.getElementById('QNTabFourFileB').collapsed = true;
	   // ## Selected to. ##
	   document.getElementById('choose-tab2').disabled = true;
	   document.getElementById('choose-tab3').disabled = true;
	   document.getElementById('choose-tab4').disabled = true;
	   // ## Advanced Tabs. ##
	   document.getElementById('tabadvanced2').collapsed = true;
	   document.getElementById('tabadvanced3').collapsed = true;
	   document.getElementById('tabadvanced4').collapsed = true;
    }
    if( document.getElementById('numtab-2').getAttribute('selected') )
    {
	   document.getElementById('QNTabTwoFileB').collapsed = false;
	   document.getElementById('QNTabThreeFileB').collapsed = true;
	   document.getElementById('QNTabFourFileB').collapsed = true;
	   
	    // ## Selected to. ##
	   document.getElementById('choose-tab2').disabled = false;
	   document.getElementById('choose-tab3').disabled = true;
	   document.getElementById('choose-tab4').disabled = true;
	   
	   document.getElementById('tabadvanced2').collapsed = false;
	   document.getElementById('tabadvanced3').collapsed = true;
	   document.getElementById('tabadvanced4').collapsed = true;
    }
    if( document.getElementById('numtab-3').getAttribute('selected') )
    {
	   document.getElementById('QNTabTwoFileB').collapsed = false; 
	   document.getElementById('QNTabThreeFileB').collapsed = false;
	   document.getElementById('QNTabFourFileB').collapsed = true;
	   
	    // ## Selected to. ##
	   document.getElementById('choose-tab2').disabled = false;
	   document.getElementById('choose-tab3').disabled = false;
	   document.getElementById('choose-tab4').disabled = true;
	   
	   document.getElementById('tabadvanced2').collapsed = false;
	   document.getElementById('tabadvanced3').collapsed = false;
	   document.getElementById('tabadvanced4').collapsed = true;
    }
    if( document.getElementById('numtab-4').getAttribute('selected') )
    {
	   document.getElementById('QNTabTwoFileB').collapsed = false; 
	   document.getElementById('QNTabThreeFileB').collapsed = false;
	   document.getElementById('QNTabFourFileB').collapsed = false;
	   
	    // ## Selected to. ##
	   document.getElementById('choose-tab2').disabled = false;
	   document.getElementById('choose-tab3').disabled = false;
	   document.getElementById('choose-tab4').disabled = false;
	   
	   document.getElementById('tabadvanced2').collapsed = false;
	   document.getElementById('tabadvanced3').collapsed = false;
	   document.getElementById('tabadvanced4').collapsed = false;
    }
}

////////////////////////////////////////////////////////////////////////////////
// loaduserFile
//
// Desc: Loads the files by launching the FilePicker
// Parameters: targetNodeID: tab to which the file will be loaded
// Returns: false on error.
////////////////////////////////////////////////////////////////////////////////
function QuickNote_loaduserFile(targetNodeID) {
	var d = new DirUtils;
	var myUserDirPlease = d.getUserChromeDir();
	var targetNodeID2 = targetNodeID;
	var fName = QuickNote_txtFilePicker("Open a Text File",0,myUserDirPlease);
	if(fName==null){
	    alert("Either you didn't choose a file, or the file you chose was invalid.\n The last used file has been reverted.");
	}else{
		document.getElementById(targetNodeID).value = fName;
	}
	//alert("You must restart your browser or the QuickNote window for the new files to be used.");
		
}

////////////////////////////////////////////////////////////////////////////////
// txtFilePicker
//
// Parameters:
//  aTitle: title to go on file picker window
//  aSave: 1 if picking file to save/overwrite, 0 if picking file to load
//  aStart: directory to start from
//    This must be an nsILocalFile.  new Dir("foo") in jslib/io/dir.js will
//    do the trick, but you have to do it yourself.
// Returns:
//  Name of file picked, in URL format, or null if cancelled
// Original taken and modified from Tagzilla.mozdev.org!
////////////////////////////////////////////////////////////////////////////////
function QuickNote_txtFilePicker(aTitle, aSave) {
  var retVal = null;
  try {
   
    const nsIFilePicker = Components.interfaces.nsIFilePicker;
    var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
    fp.init(window, aTitle, (aSave ? nsIFilePicker.modeSave : nsIFilePicker.modeOpen));
    fp.appendFilters(nsIFilePicker.filterAll | nsIFilePicker.filterText);
    
    /*
    if(aStart) {
      fp.displayDirectory = aStart;
    }
    */
    var result=fp.show();
    if (result == nsIFilePicker.returnOK || result == nsIFilePicker.returnReplace) {
      //retVal=fp.fileURL.spec;
      retVal=fp.file.path;
      //alert("Should return retval: "+retVal+" YES!"); // DEBUG
    }
  }
  catch (ex) {
  }
  return retVal;
}
////////////
