const APP_DISPLAY_NAME = "PasteIP";
const APP_NAME = "pasteip";
const APP_PACKAGE = "/Michael Newton/pasteip";
const APP_VERSION = "1.1";

const APP_JAR_FILE = "pasteip.jar";
const APP_CONTENT_FOLDER = "content/pasteip/";
const APP_LOCALE_FOLDER  = "locale/en-US/pasteip/";

const APP_SUCCESS_MESSAGE = "New menuitems will appear on the textbox context menu.\n\n";


initInstall(APP_NAME, APP_PACKAGE, APP_VERSION);

var chromef = getFolder("Profile", "chrome");

var err = addFile(APP_PACKAGE, APP_VERSION, APP_JAR_FILE, chromef, null)
if(err == SUCCESS) { 
	var jar = getFolder(chromef, APP_JAR_FILE);
	registerChrome(CONTENT | DELAYED_CHROME, jar, APP_CONTENT_FOLDER);
	registerChrome(LOCALE  | DELAYED_CHROME, jar, APP_LOCALE_FOLDER);
	err = performInstall();
	if(err == SUCCESS) {
		alert(APP_DISPLAY_NAME + " " + APP_VERSION + " has been installed to your user profile.\n"
			+APP_SUCCESS_MESSAGE
			+"Please restart your browser before continuing.");
	} else { 
		alert("Install failed.\nError code:" + err);
		cancelInstall(err);
	}
} else { 
	alert("Failed to create " + APP_JAR_FILE + "\nError code:" + err);
	cancelInstall(err);
}
