var pasteipsum = {
	init: function() {
		var menu = document.getElementById('contentAreaContextMenu');
		menu.addEventListener('popupshowing', pasteipsum.showHide, false);
		document.addEventListener('click', pasteipsum.clickCheck, false);
	},
	showHide: function() {
		document.getElementById('context-pasteipsum').hidden = document.getElementById('context-undo').hidden;
	},
	clickCheck: function(e) {
	  if (!e) e = window.event;
	  if (e.button != 2) return;
	  if (!e.target) return;
	  try {
  	  if (e.target.getAttribute("readonly") == "readonly") {
    	  document.getElementById('context-pasteipsum').setAttribute("disabled", true);
  	  }
  	  else {
     	  document.getElementById('context-pasteipsum').setAttribute("disabled", false);
  	  }
  	}
  	catch (e) {}
	},
	pasteipsum: function() {
  	var theBox = document.commandDispatcher.focusedElement;
  	if (!theBox)
  	  return;
    var clip = Components.classes["@mozilla.org/widget/clipboard;1"].createInstance(Components.interfaces.nsIClipboard);
    if (!clip) return false;
    
    var trans = Components.classes["@mozilla.org/widget/transferable;1"].createInstance(Components.interfaces.nsITransferable);
    if (!trans) return false;
    trans.addDataFlavor("text/unicode");
    clip.getData(trans,clip.kGlobalClipboard);
    
    var str=new Object();
    var strLength=new Object();
    
    trans.getTransferData("text/unicode",str,strLength);

    if (str) str=str.value.QueryInterface(Components.interfaces.nsISupportsString);
    if (str) pastetext=str.data.substring(0,strLength.value / 2);
    
		var theBox = document.commandDispatcher.focusedElement;
		var oPosition = theBox.scrollTop;
		var oHeight = theBox.scrollHeight;
		pasteipsum.insertAtCursor(theBox,"Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Quisque sed felis. Aliquam sit amet felis. Mauris semper, velit semper laoreet dictum, quam diam dictum urna, nec placerat elit nisl in quam. Etiam augue pede, molestie eget, rhoncus at, convallis ut, eros. Aliquam pharetra. Nulla in tellus eget odio sagittis blandit. Maecenas at nisl. Nullam lorem mi, eleifend a, fringilla vel, semper at, ligula. Mauris eu wisi. Ut ante dui, aliquet nec, congue non, accumsan sit amet, lectus. Mauris et mauris. Duis sed massa id mauris pretium venenatis. Suspendisse cursus velit vel ligula. Mauris elit. Donec neque. Phasellus nec sapien quis pede facilisis suscipit. Aenean quis risus sit amet eros volutpat ullamcorper. Ut a mi. Etiam nulla. Mauris interdum.\n\n");
		var nHeight = theBox.scrollHeight - oHeight;
		theBox.scrollTop = oPosition + nHeight;
	},
	insertAtCursor: function(myField, myValue) {
  // Function taken from http://www.alexking.org/blog/2003/06/02/inserting-at-the-cursor-using-javascript/
  // Modified to return cursor to correct place
    if (myField.selectionStart || myField.selectionStart == '0') {
      var startPos = myField.selectionStart;
      var endPos = myField.selectionEnd;
      myField.value = myField.value.substring(0, startPos)
      + myValue
      + myField.value.substring(endPos, myField.value.length);
      var cursorPos = endPos + myValue.length;
      myField.selectionStart = cursorPos;
      myField.selectionEnd = cursorPos;
    } 
    else {
      myField.value += myValue;
    }
  }
}
window.addEventListener('load', pasteipsum.init, false); 
