/* install.js, for Open Java Console
 * borrowed from the Tabbrowser Preferences extension
 */
var author      = "Bradley Chapman (jabiru_croc@yahoo.com)"
var displayname = "Open Java Console";
var version     = "0.3";
var packagename = "javaconsole";
var packagefile = packagename + ".jar";

var cflag       = CONTENT | PROFILE_CHROME;
var lflag       = LOCALE | PROFILE_CHROME;
var error       = null;
var installdir  = getFolder("Current User", "chrome");
var folder      = null;

var msg = "Do you wish to install Open Java Console " + version + " into the profile directory (OK) or the browser directory (Cancel)?";
var ok = confirm(msg);
if(!ok) {
  cflag = CONTENT | DELAYED_CHROME;
  lflag = LOCALE | DELAYED_CHROME;
  installdir = getFolder("chrome");
}

// Begin the installation
initInstall(displayname + " " + version, "/" + author + "/" + displayname, version);
setPackageFolder(installdir);
error = addFile(packagename, version, "chrome/" + packagefile, installdir, null);

if(error == SUCCESS) {
  folder = getFolder(installdir, packagefile);

  // Register the chrome content and locale data
  registerChrome(cflag, folder, "content/" + packagename + "/");
  registerChrome(lflag, folder, "locale/en-US/" + packagename + "/");
 
  // Install the extension
  if(getLastError() == SUCCESS)
  {
    error = performInstall();
    if(error) {
      alert("An error occured during installation !\nErrorcode: " + error);
    }
  }
  else
  {
    alert("An error occurred, installation will be cancelled.\nErrorcode: " + error);
    cancelInstall(error);
  }
}
