
function webfolderView() {
  webfolderViewForUrl(gBrowser.currentURI.spec);
  return true;
}

function webfolderViewForUrl(url) {

  var oldcursor = window.content.document.body.style.cursor;
  window.content.document.body.style.cursor = "wait";

  var wscript = Components.classes["@mozilla.org/file/directory_service;1"].
	  getService(Components.interfaces.nsIProperties).
	  get("WinD", Components.interfaces.nsIFile);
  wscript.append("system32");
  wscript.append("wscript.exe");
  
  if (! wscript.exists()) {
    alert("Windows Script engine not found at '" + wscript.path + "'!");
  }
  else {
    var content = getContents("chrome://openwebfolder/content/open-webfolder.js");
  
    var process = Components.classes['@mozilla.org/process/util;1'].getService(Components.interfaces.nsIProcess);
    process.init(wscript);
    var arguments = [] ;
  
    var tmpfile = Components.classes["@mozilla.org/file/directory_service;1"].
  	  getService(Components.interfaces.nsIProperties).
  	  get("TmpD", Components.interfaces.nsIFile);
    tmpfile.append("open-webfolder.js");
    tmpfile.createUnique(Components.interfaces.nsIFile.NORMAL_FILE_TYPE, 0664);
  
    var foStream = Components.classes["@mozilla.org/network/file-output-stream;1"]
  	  .createInstance(Components.interfaces.nsIFileOutputStream);
  
    foStream.init(tmpfile, 0x02 | 0x08 | 0x20, 0664, 0); // write, create, truncate
    foStream.write(content, content.length);
    foStream.close();
  
    arguments.push(tmpfile.path);
    arguments.push(url);
  
    var result = {};
    
    process.run(true, arguments, arguments.length, result);
      
    tmpfile.remove(false);
  }
  
  window.content.document.body.style.cursor = oldcursor;
  return false;
}


function getContents(aURL){
  var ioService=Components.classes["@mozilla.org/network/io-service;1"]
    .getService(Components.interfaces.nsIIOService);
  var scriptableStream=Components
    .classes["@mozilla.org/scriptableinputstream;1"]
    .getService(Components.interfaces.nsIScriptableInputStream);

  var channel=ioService.newChannel(aURL,null,null);
  var input=channel.open();
  scriptableStream.init(input);
  var str=scriptableStream.read(input.available());
  scriptableStream.close();
  input.close();
  return str;
}

function openwebfolderChangeState(e) {

  e.view.webfolderViewForUrl = webfolderViewForUrl;
  
  var anchors = window.content.document.getElementsByTagName("a");
  if (anchors) {
    for (i = 0; i < anchors.length; i++) {
      var anch = anchors[i];
      var stattr = anch.getAttribute("folder");
      if (stattr) {
        anch.setAttribute("onclick", "javascript:webfolderViewForUrl('" + stattr + "');");
      }
    }
  }
}

// add listeners to various necessary parts of the browser, to handle page load
function openwebfolderInit(e) {
    var contentArea = document.getElementById("appcontent");
    contentArea.addEventListener("load", openwebfolderChangeState, true);
}

window.addEventListener("load", openwebfolderInit, false);
