/*
 * ============================================================================
 *                             Private Functions
 * ============================================================================
 */

//-----------------------------------------------------------------------------

function _getLinkTypesList()
{
    /*
     * Returns a resource corresponding to the containing list of link types
     */

    // get an RDF service:
    var rdfService = Components.classes["@mozilla.org/rdf/rdf-service;1"].getService(Components.interfaces.nsIRDFService);
    // get my datasource into memory:
    var rdfDataSource = rdf_getMakeLinkDataSource();
    // get all link types:
    var linkTypesList  = Components.classes["@mozilla.org/rdf/container;1"].createInstance(Components.interfaces.nsIRDFContainer);
    var linkTypesResource = rdfService.GetResource( "http://www.soylentred.net/makelink/linktypes" );
    linkTypesList.Init( rdfDataSource , linkTypesResource );

    return linkTypesList;
}

//-----------------------------------------------------------------------------

/*
 * ============================================================================
 *                             Public Functions
 * ============================================================================
 */

//-----------------------------------------------------------------------------

function rdf_getMakeLinkDataSource()
{
    var directoryService = Components.classes['@mozilla.org/file/directory_service;1'].getService( Components.interfaces.nsIProperties );
    var ioService = Components.classes['@mozilla.org/network/io-service;1'].getService( Components.interfaces.nsIIOService );
    var rdfService = Components.classes['@mozilla.org/rdf/rdf-service;1'].getService( Components.interfaces.nsIRDFService );

    var rdfFile = directoryService.get( 'ProfD' , Components.interfaces.nsILocalFile );
    rdfFile.append( "extensions" );
    rdfFile.append( "{0B6B0D55-DFAC-4006-AEE6-25667F55A2A8}" );
    rdfFile.append( "defaults" );
    rdfFile.append( "makelink.rdf" );

    if ( !rdfFile.exists() ) rdfFile.create( rdfFile.NORMAL_FILE_TYPE , 0666 );

    return rdfService.GetDataSourceBlocking( ioService.newFileURI( rdfFile ).spec );
}

//-----------------------------------------------------------------------------

function rdf_deleteLinkTypeByName( linkType )
{
    // get my data source:
    var ds = rdf_getMakeLinkDataSource();

    // get an RDF service:
    var rdfService = Components.classes["@mozilla.org/rdf/rdf-service;1"].getService(Components.interfaces.nsIRDFService);

    // identify the RDF predicates:
    var predicateName = rdfService.GetResource( "http://www.soylentred.net/makelink/rdf#name" );
    var predicateFormat = rdfService.GetResource( "http://www.soylentred.net/makelink/rdf#format" );

    // make the name into a resource:
    var nameRes = rdfService.GetLiteral( linkType );

    // find the link type resource with the right name:
    var linkTypeRes = ds.GetSource( predicateName , nameRes , true);
    // get the format resource:
    var formatRes = ds.GetTarget( linkTypeRes , predicateFormat , true );

    // unassert the name:
    ds.Unassert( linkTypeRes , predicateName , nameRes );
    // unassert the format:
    ds.Unassert( linkTypeRes , predicateFormat , formatRes );

    // get the resource for the container list:
    var linkTypesList = _getLinkTypesList()

    //delete the resource:
    linkTypesList.RemoveElement( linkTypeRes , true );

    ds.QueryInterface( Components.interfaces.nsIRDFRemoteDataSource );
    ds.Flush();

    return true;
}

//-----------------------------------------------------------------------------

function rdf_addNewLinkType( name , format )
{
    // get an RDF service:
    var rdfService = Components.classes["@mozilla.org/rdf/rdf-service;1"].getService(Components.interfaces.nsIRDFService);
    // get my data source:
    var ds = rdf_getMakeLinkDataSource();

    // create a resource for the linktype:
    var linkTypeResource = rdfService.GetAnonymousResource();

    // identify the RDF predicates:
    var predicateName = rdfService.GetResource( "http://www.soylentred.net/makelink/rdf#name" );
    var predicateFormat = rdfService.GetResource( "http://www.soylentred.net/makelink/rdf#format" );

    // make the name and format into resources:
    var nameRes = rdfService.GetLiteral( name );
    var formatRes = rdfService.GetLiteral( format );

    // assert the name and format:
    ds.Assert( linkTypeResource , predicateName , nameRes , true );
    ds.Assert( linkTypeResource , predicateFormat , formatRes , true );

    // add to the Seq:
    // get the resource for the container list:
    var linkTypesList = _getLinkTypesList()
    // append the new resource:
    linkTypesList.AppendElement( linkTypeResource );

    ds.QueryInterface( Components.interfaces.nsIRDFRemoteDataSource );
    ds.Flush();

    return true;
}

//-----------------------------------------------------------------------------

function rdf_getLinkFormatByName( name )
{
    // get an RDF service:
    var rdfService = Components.classes["@mozilla.org/rdf/rdf-service;1"].getService(Components.interfaces.nsIRDFService);
    // get my data source:
    var ds = rdf_getMakeLinkDataSource();

    // identify the RDF predicates:
    var predicateName = rdfService.GetResource( "http://www.soylentred.net/makelink/rdf#name" );
    var predicateFormat = rdfService.GetResource( "http://www.soylentred.net/makelink/rdf#format" );

    // make the name into a resource:
    var nameResource = rdfService.GetLiteral( name );

    // find the link type resource with the right name:
    var linkType = ds.GetSource( predicateName , nameResource , true);
    var formatResource = ds.GetTarget( linkType , predicateFormat , true );
    if ( formatResource instanceof Components.interfaces.nsIRDFLiteral )
    {
        var format = formatResource.Value;
        return format;
    }
    else
    {
        return false;
    }
}

//-----------------------------------------------------------------------------

function rdf_getAllLinkTypes()
{
    // get an RDF service:
    var rdfService = Components.classes["@mozilla.org/rdf/rdf-service;1"].getService(Components.interfaces.nsIRDFService);
    // get my datasource into memory:
    var rdfDataSource = rdf_getMakeLinkDataSource();
    // get list of all link types:
    var linkTypesList = _getLinkTypesList();

    // create an array to put them in:
    var linkTypesArray = new Array();
    // identify the RDF predicates:
    var predicateName = rdfService.GetResource("http://www.soylentred.net/makelink/rdf#name");
    var predicateFormat = rdfService.GetResource("http://www.soylentred.net/makelink/rdf#format");

    // loop through the list:
    var linkTypes = linkTypesList.GetElements();
    while ( linkTypes.hasMoreElements() )
    {
        var linkType = linkTypes.getNext();
        if ( linkType instanceof Components.interfaces.nsIRDFResource )
        {
            // get the name and format:
            var nameResource = rdfDataSource.GetTarget( linkType, predicateName, true );
            if ( nameResource instanceof Components.interfaces.nsIRDFLiteral )
            {
                var name = nameResource.Value;
            }
            var formatResource = rdfDataSource.GetTarget( linkType , predicateFormat , true );
            if ( formatResource instanceof Components.interfaces.nsIRDFLiteral )
            {
                var format = formatResource.Value;
            }

            // store in the array:
            linkTypesArray[name] = format;
        }
    }

    // now linkTypesArray is an associative array of 'linkTypeName'=>'linkTypeValue' pairs
    return linkTypesArray;
}

//-----------------------------------------------------------------------------

/*
 * ============================================================================
 *                             Unused Functions
 * ============================================================================
 */

//-----------------------------------------------------------------------------

function doMagic()
{
    var directoryService = Components.classes['@mozilla.org/file/directory_service;1'].getService( Components.interfaces.nsIProperties );
    var ioService = Components.classes['@mozilla.org/network/io-service;1'].getService( Components.interfaces.nsIIOService );
    var rdfService = Components.classes['@mozilla.org/rdf/rdf-service;1'].getService( Components.interfaces.nsIRDFService );

    var rdfFile = directoryService.get( 'ProfD' , Components.interfaces.nsILocalFile );
    rdfFile.append( "makelink-linktypes.rdf" );
    if( !rdfFile.exists() )
        rdfFile.create( rdfFile.NORMAL_FILE_TYPE , 0666 );
    var myDatasource = rdfService.GetDataSource( ioService.newFileURI( rdfFile ).spec );

    /* Start TODO(tm) microsoft */

    var myResource = rdfService.GetResource( "http://forums.mozillazine.org/RDF#myResource" );
    var myArc = rdfService.GetResource( "http://forums.mozillazine.org/RDF#myarc" );
    var myValue = rdfService.GetLiteral( "Hello, World!" );
    myDatasource.Assert( myResource , myArc , myValue , true );

    /* End TODO */

    myDatasource.QueryInterface( Components.interfaces.nsIRDFRemoteDataSource );
    myDatasource.Flush();
}