/*
 * ============================================================================
 *                             Private Functions
 * ============================================================================
 */

//-----------------------------------------------------------------------------

function _getSelectedTreeRows( tree )
{
    /*
     * Returns an Array of all treerow elements from the given tree element
     * that are selected
     */
    var idList = new Array();
    var rangeCount = tree.view.selection.getRangeCount();
    for( var i = 0 ; i < rangeCount ; i++ )
    {
        var start = new Array();
        var end = new Array();
        tree.view.selection.getRangeAt( i , start , end );
        for( var c = start.value ; c <= end.value ; c++ )
        {
            idList.push( tree.view.getItemAtIndex(c).firstChild );
        }
    }

    return idList;
}

//-----------------------------------------------------------------------------

function _verifyDeleteRows( rowCount )
{
    /*
     * Prompts the user to delete rowCount number of rows
     */
    // for now just return true:
    return Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                    .getService(Components.interfaces.nsIPromptService)
                    .confirm( window , "Are you sure?" , "Are you sure you wnat to delete the " + rowCount + " link types selected?" );
}

//-----------------------------------------------------------------------------

function _deleteRows( rows )
{
    /*
     * Tries to delete the treerows 'rows'
     * Returns an associative array of success values
     * success['true'] is an array of successful deletions
     * success['false'] is an array of unsuccessful deletions
     */
    // create an array to hold the results of deletion attempts:
    var success = new Array();
    success['true'] = new Array();
    success['false'] = new Array();
    // for each row...
    for ( var i = 0 ; i < rows.length ; i++ )
    {
        // get the name of the link type:
        var linkType = rows[i].firstChild.getAttribute('label');
        // store the success code for the deletion atempt:
        if ( rdf_deleteLinkTypeByName( linkType ) )
            success['true'].push( linkType );
        else
            success['false'].push( linkType );
    }
    return success;
}

//-----------------------------------------------------------------------------

function _getDeleteSuccessMessage( deleted , notDeleted )
{
    /*
     * Constructs a message relating the success or failure of an attempt to
     * delete link-type rows
     */
    var message = ""
    if ( deleted.length > 0 ) message = message + "The following rows were successfully deleted:\n";
    for ( var i = 0 ; i < deleted.length ; i++ )
    {
        message = message + " * " + deleted[i] + "\n";
    }
    if ( notDeleted.length > 0 ) message = message + "The following rows were NOT deleted:\n";
    for ( var i = 0 ; i < notDeleted.length ; i++ )
    {
        message = message + " * " + notDeleted[i]  + "\n";
    }
    return message;
}

//-----------------------------------------------------------------------------

/*
 * ============================================================================
 *                             Public Functions
 * ============================================================================
 */

//-----------------------------------------------------------------------------

function options_populateTree()
{
    /*
     * Populates the tree of link types with data from my RDF source
     */
    var ds = rdf_getMakeLinkDataSource();
    var tree = document.getElementById( "link-types" );
    tree.database.AddDataSource( ds );
    tree.builder.rebuild();
}

//-----------------------------------------------------------------------------

function options_deleteSelectedLinkTypes()
{
    /*
     * Delete's the selected rows from the tree of link types
     */
    // get the tree element:
    var tree = document.getElementById( "link-types" );
    // get an array of selected rows:
    var selectedRows = _getSelectedTreeRows( tree );
    // make sure the user wants to delete:
    if ( _verifyDeleteRows( selectedRows.length ) )
    {
        // success is an associative array of success values:
        var success = _deleteRows( selectedRows );
        // split into successful and unsuccessful:
        var deleted = success['true'];
        var notDeleted = success['false'];
        // alert the user to the results:
        alert( _getDeleteSuccessMessage( deleted , notDeleted ) );
    }
    // repopulate the tree:
    options_populateTree();
}

//-----------------------------------------------------------------------------

function options_modifySelectedLinkType()
{
    /*
     * Presents a dialog allowing the user to modify the selected link type
     */
    // get the tree element:
    var tree = document.getElementById( "link-types" );
    // get an array of selected rows:
    var selectedRows = _getSelectedTreeRows( tree );
    if ( selectedRows.length == 1 )
    {
        var name = selectedRows[0].firstChild.getAttribute('label');
        window.openDialog( "chrome://makelink/content/options/editlinktype.xul" , "editlinktype" , "chrome" , name );
    }
    else
    {
        // there wasn't exactly one row selected:
        // put some error handling here, even if only an alert
    }
}

//-----------------------------------------------------------------------------

function options_showNewLinkTypeDialog()
{
    /*
     * Presents a dialog allowing the user to add a new link type
     */
    window.openDialog( "chrome://makelink/content/options/editlinktype.xul" , "editlinktype" , "chrome" , "_new" );
}

//-----------------------------------------------------------------------------

function options_enableButtons()
{
    /*
     * Enables or disables buttons based on selection in the tree element
     */
    var buttonDel = document.getElementById( "button-delete" );
    var buttonMod = document.getElementById( "button-modify" );

    // get the tree element:
    var tree = document.getElementById( "link-types" );
    // get an array of selected rows:
    var selectedRows = _getSelectedTreeRows( tree );

    buttonDel.disabled = ( selectedRows.length <= 0 );
    buttonMod.disabled = ( selectedRows.length != 1 );
}

//-----------------------------------------------------------------------------

function options_enableContextMenu()
{
    /*
     * Enables or disables context menu items based on selection in the tree element
     */
    var menuMod = document.getElementById( "link-types-modify-selected" );

    // get the tree element:
    var tree = document.getElementById( "link-types" );
    // get an array of selected rows:
    var selectedRows = _getSelectedTreeRows( tree );
    if ( selectedRows.length != 1 ) menuMod.setAttribute( "disabled" , true );
    else menuMod.removeAttribute( "disabled" );
}

//-----------------------------------------------------------------------------

function init()
{
    options_populateTree();
    options_enableButtons();
    document.getElementById( "link-types" ).addEventListener( "select" , options_enableButtons , false );
    document.getElementById( "link-types-context" ).addEventListener( "popupshowing" , options_enableContextMenu , false );
}

//-----------------------------------------------------------------------------

/*
 * ============================================================================
 *                      Run when Options Dialog is loaded
 * ============================================================================
 */

//-----------------------------------------------------------------------------

window.addEventListener( "load" , init , false );

//-----------------------------------------------------------------------------
