//-----------------------------------------------------------------------------

/*
 * ============================================================================
 *                             Public Functions
 * ============================================================================
 */

//-----------------------------------------------------------------------------

function editLinkTypes_initialise()
{
    var dialog = document.getElementById( "makelink-newlinktype-dialog" );
    // flag to mark new link types from existing ones:
    var boolNewLinkType = ( window.arguments[0] == "_new" );
    // set the dialog title:
    var dialogTitle = boolNewLinkType ? "Make Link :: New Link Type" : "Make Link :: Edit Link Type :: " + window.arguments[0];
    dialog.setAttribute( "title" , dialogTitle );

    var contextHelpNew = document.getElementById( "makelink-newlinktype-contexthelp-new" );
    var contextHelpEdit = document.getElementById( "makelink-newlinktype-contexthelp-edit" );
    contextHelpNew.style.display = "block";
    contextHelpEdit.style.display = "none";

    if ( !boolNewLinkType )
    {
        // prefill form fields:
        var linkTypeName = window.arguments[0];
        var linkTypeFormat = rdf_getLinkFormatByName( linkTypeName );
        document.getElementById( "editlinktype-name" ).value = linkTypeName;
        document.getElementById( "editlinktype-name" ).disabled = true;
        document.getElementById( "editlinktype-format" ).value = linkTypeFormat;
        contextHelpEdit.style.display = "block";
        contextHelpNew.style.display = "none";
    }
}

//-----------------------------------------------------------------------------

function editLinkTypes_accept()
{
    // if we're modifying an existing linktype, delete the old one:
    if ( window.arguments[0] != "_new" )
    {
        rdf_deleteLinkTypeByName( window.arguments[0] );
    }
    // add the new linktype:
    var linkTypeName = document.getElementById( "editlinktype-name" ).value;
    var linkTypeFormat = document.getElementById( "editlinktype-format" ).value;

    rdf_addNewLinkType( linkTypeName , linkTypeFormat );
}

//-----------------------------------------------------------------------------

function editLinkTypes_displayHelp()
{
    //display a page describing the available options:
    window.open("chrome://makelink/content/help/defininglinktypes.html");
}

//-----------------------------------------------------------------------------

/*
 * ============================================================================
 *                  Run when Edit Link Type Dialog is loaded
 * ============================================================================
 */

//-----------------------------------------------------------------------------

window.addEventListener( "load" , editLinkTypes_initialise , false );

//-----------------------------------------------------------------------------
