// MakeLink object:
var MakeLink = {
    init: function()
    {
        var linkTypes = rdf_getAllLinkTypes()

        var subMenu = document.getElementById( "makelink-submenu" );
        for ( linkType in linkTypes )
        {
            var menu = document.createElement( "menuitem" );
            menu.setAttribute( "label" , linkType );
            menu.setAttribute( "format" , linkTypes[linkType] );
            menu.setAttribute( "oncommand" , "MakeLink.makeSelectionLink( event , this.getAttribute('format') );" );
            subMenu.insertBefore( menu , document.getElementById( "makelink-configsep" ) );
        }
    },

    makeLink: function( format , info )
    {
        info['url'] = info['url'].replace(/&/g, "&amp;");

        // split into pieces on %:
        var piece = format.split( "%" );
        // flag to record if the current piece is potentially a makelink variable:
        var inVar = false;
        // final text:
        copyText = "";
        // loop through the pieces:
        for ( var i in piece )
        {
            // if it's not a makelink variable...:
            if ( !inVar )
            {
                // just add it as it is:
                copyText += piece[i];
                // next piece could be a variable:
                inVar = true;
            }
            // if it could be a makelink variable...:
            else
            {
                switch ( piece[i] )
                {
                    case "TEXT":
                        copyText += info['text'];
                        inVar = false;
                        break;
                    case "URL":
                        copyText += info['url'];
                        inVar = false;
                        break;
                    case "TITLE":
                        copyText += info['title'];
                        inVar = false;
                        break;
                    case "INPUT":
                        copyText += prompt( format + "\n\nPlease enter the %INPUT% text." );
                        inVar = false;
                        break;
                    // default (not actually a make link variable) means inVar
                    // is still true for the next piece
                    default:
                        copyText += "%" + piece[i];
                }
            }
        }

        var mimeType = new Array( "text/unicode" );

        // Create a clipboard object:
        /*
         * the remainder of this function is based on code by Ben Basson (Cusser)
         * used with permission
         */
        netscape.security.PrivilegeManager.enablePrivilege('UniversalXPConnect');
        var clip = Components.classes['@mozilla.org/widget/clipboard;1'].createInstance(Components.interfaces.nsIClipboard);
        if ( !clip ) return;

        var trans = Components.classes['@mozilla.org/widget/transferable;1'].createInstance(Components.interfaces.nsITransferable);
        if ( !trans ) return;

        trans.addDataFlavor('text/unicode');

        var str = new Object();
        var len = new Object();
        var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);

        str.data = copyText;
        for ( var i = 0 ; i < mimeType.length ; i++ )
        {
            trans.setTransferData(mimeType[i],str,copyText.length*2);
        }
        var clipid=Components.interfaces.nsIClipboard;

        if ( !clip ) return false;

        clip.setData(trans,null,clipid.kGlobalClipboard);
        return false;
    },

    makeSelectionLink: function( event , format )
    {
        // What element was clicked on:
        var target = document.popupNode;
        // move up the DOM tree to a link or block level element:
        target = getCorrectTarget( target );

        // array to store link info:
        var info = new Array();

        // look to see if there's selected text:
        if ( ( selection = getSelectedText( target ) ) != "" )
        {
            // some text is selected:
            info['text'] = selection;
            info['url'] = window.content.document.location.href;
            info['title'] = window.content.document.title;
        }
        // or if it's a link:
        else if ( isLink( target ) )
        {
            // get anchor text/URL:
            info['text'] = getLinkText( target , format );
            info['url'] = target.href;
            info['title'] = getLinkTitle( target );
        }
        else
        {
            // not an anchor (get page title/URL):
            info['text'] = window.content.document.title;
            info['url'] = window.content.document.location.href;
            info['title'] = getPageDescription( window.content.document );
        }
        // make the link:
        MakeLink.makeLink( format , info );
    },
}

// do the init on load:
window.addEventListener( "load" , MakeLink.init , false );

