function getLinkText( element , format )
{
    // text to output:
    var text = "";

    // for every sub-element:
    for ( var i = 0 ; i < element.childNodes.length ; i++ )
    {
        var currentNode = element.childNodes[i];

        // if it's a text node, add it to the output text:
        if ( currentNode.nodeValue != null )
            text += currentNode.nodeValue.replace(/</g, "&lt;")
                                         .replace(/>/g, "&gt;")
                                         .replace(/\"/g, "&quot;")
                                         .replace(/&/g, "&amp;");
        // if it's an image, add its alt text:
        else if ( currentNode.tagName == "IMG" )
            text += currentNode.alt;
        // otherwise just recurse it's children:
        else
            text += getLinkText( currentNode , outputMode );
    }
    // replace whitespace with a single space:
    return text.replace(/[ \n\r\t]+/g," ");
}

function getSelectedText( node )
{
    /*
     * original code taken from text/plain extension by Gilles Durys <mozbug@durys.net>
     * used (and modified) under the terms of the MPL/GPL bi-licence.
     */
    var selection = "";
    var nodeLocalName = node.localName.toUpperCase();
    if ( ( nodeLocalName == "TEXTAREA" ) || ( nodeLocalName == "INPUT" && ( node.type == "text" || node.type == "password" ) ) )
    {
        selection = node.value.substring( node.selectionStart , node.selectionEnd );
    }
    else if ( nodeLocalName == "OPTION" )
    {
        var parentSelect = node.parentNode;
        if ( parentSelect.localName.toUpperCase() == "SELECT" )
        {
            if ( parentSelect.multiple )
            {
                var anOption;
                for ( var i = 0 ; i < parentSelect.options.length ; i++ )
                {
                    anOption = parentSelect.options[i];
                    if ( anOption.selected )
                    {
                        selection += " " + anOption.value;
                    }
                }
            }
            else
            {
                selection = node.value;
            }
        }
    }
    else if ( nodeLocalName == "SELECT" )
    {
        selection = node.options[node.selected].value;
    }
    else
    {
        var focusedWindow = document.commandDispatcher.focusedWindow;
        selection = focusedWindow.__proto__.getSelection.call( focusedWindow ).toString();
    }
    selection = selection.toString();

    // collapse white space:
    selection = selection.replace(/[ \n\r\t]+/g, " ");
    // trim white space:
    selection = selection.replace(/(^\s+)|(\s+$)/, "");
    return selection;
}

function getSelectionType( node )
{
    var tag = node.localName.toUpperCase();

    if (tag == "IMG" && node.parentNode.localName.toUpperCase() == "A")
    {
        node = node.parentNode;
        tag = node.localName.toUpperCase();
    }

    if (tag == "A" && node.href)
    {
        // link:
        return "link";
    }
    else
    {
        // not a link:
        return "nolink";
    }
}

function getLinkTitle( node )
{
    return node.title;
}

function getPageDescription( document )
{
    // get a list of meta elements:
    var metas = document.getElementsByTagName( "meta" );
    var desc = "";
    for ( var i = 0 ; i < metas.length ; i++ )
    {
        // look for the "description" meta element:
        var name;
        if ( name = metas[i].getAttribute( "name" ) )
        {
            if ( name.toLowerCase() == "description" ) desc = metas[i].getAttribute("content");
        }
    }
    // then return the description:
    return desc;
}

/* returns the link ultimately containing the node or the block
   level element ultimately containing the node, nearest ancestor in
   both cases */
function getCorrectTarget( node )
{
    while ( !isBlockLevel( node ) && !isLink( node ) )
    {
        // work up the tree if there is a parent:
        if ( node.parentode )
            node = node.parentNode;
        // return the current node if it's at the top:
        else
            return node;
    }
    return node;
}

function isLink( node )
{
    // true if node is a link (<a href>)
    // false otherwise
    if ( tagName( node ) == 'a' && node.href ) return true;
    return false;
}

function isBlockLevel( node )
{
    // array of all block level elements:
    var blocks = new Array( 'html' , 'body' , 'h1' , 'h2' , 'h3' , 'h4' , 'h5' , 'h6' , 'ul' , 'OL' , 'DIR' , 'MENU' , 'LI' , 'DL' , 'DT' , 'DD' , 'p' , 'pre' , 'blockquote' , 'address' , 'div' , 'center' , 'form' , 'table' , 'tr' , 'td' );
    return inArray( tagName( node ) , blocks );
}

function tagName( node )
{
    return node.localName.toLowerCase();
}

function inArray( needle , haystack )
{
    // true if needle is an element of array haystack
    // false otherwise
    for ( var i = 0 ; i < haystack.length ; i++ )
    {
        if ( needle == haystack[i] )
        {
            return true;
        }
    }
    return false;
}