const APP_DISPLAY_NAME = "JS Console Extras";
const APP_NAME = "jscex";
const APP_PACKAGE = "/Jordan Callicoat/jscex";
const APP_VERSION = "0.2";

const APP_JAR_FILE = "chrome/jscex.jar";
const APP_CONTENT_FOLDER = "content/jscex/";
const APP_LOCALE_FOLDER = "locale/en-US/jscex/";
const APP_SUCCESS_MESSAGE = "You need to restart your browser before the extension will work.";

initInstall(APP_NAME, APP_PACKAGE, APP_VERSION);

var chromef;
var contenttype;
var localetype;
var skintype;

if(confirm("Press OK to install to the current profile directory.\n\n" +  "Press Cancel to install to the global Firefox directory.")) {
	chromef = getFolder("Profile", "chrome");
	contenttype = CONTENT | PROFILE_CHROME;
	localetype = LOCALE | PROFILE_CHROME;
}
else {
	chromef = getFolder("Chrome");
	contenttype = CONTENT | DELAYED_CHROME;
	localetype = LOCALE | DELAYED_CHROME;
}

var err = addFile(APP_PACKAGE, APP_VERSION, APP_JAR_FILE, chromef, null);
		
if(err >= SUCCESS) {
	var jar = getFolder(chromef, APP_JAR_FILE);
	registerChrome(contenttype, jar, APP_CONTENT_FOLDER);
	registerChrome(localetype, jar, APP_LOCALE_FOLDER);
	err = performInstall();
	if(err >= SUCCESS) {
		alert("The " + APP_DISPLAY_NAME + " " + APP_VERSION + " extension has been succesfully installed.\n"
			+APP_SUCCESS_MESSAGE);
	} else { 
		alert("Install failed. Error code:" + err);
		cancelInstall(err);
	}
} else { 
	alert("Failed to create " +APP_JAR_FILE +"\n"
		+"You probably don't have appropriate permissions \n"
		+"(write access to the profile directory). \n"
		+"_____________________________\nError code:" + err);
	cancelInstall(err);
}
