// JavaScript Console Status extension for Mozilla Firefox
// Copyright (C) 2004  Michael O'Rourke / Cosmic Cat Creations (http://www.cosmicat.com/)
// For licensing terms, please refer to readme.txt in this extension's XPInstall 
// package or its installation directory on your computer.

var ConsoleWatcher = {
	arrTabs: new Array(),
	arrErrors: new Array(),
	
	init: function() {
		this.Browser = document.getElementById("content");
		this.StatusButton = document.getElementById("scriptstatus-button");
		this.Browser.addEventListener("error", ConsoleWatcher_handleError, true);
		this.Browser.addEventListener("select", ConsoleWatcher_updateStatusButton, true);
		this.Browser.addEventListener("unload", ConsoleWatcher_resetErrorLevel, true);
		try {
			var isupports = Components.classes['@mozilla.org/consoleservice;1'].getService();
			this.mCService = isupports.QueryInterface(Components.interfaces.nsIConsoleService);
			this.mCService.registerListener(ConsoleWatcher);
		} catch (ex) {}
	},
	destruct: function() {
		
	},
	unloader: function() {
		this.Browser.removeEventListener("error", ConsoleWatcher_handleError, true);
		this.Browser.removeEventListener("select", ConsoleWatcher_updateStatusButton, true);
		this.Browser.removeEventListener("unload", ConsoleWatcher_resetErrorLevel, true);
		try {
			var isupports = Components.classes['@mozilla.org/consoleservice;1'].getService();
			this.mCService = isupports.QueryInterface(Components.interfaces.nsIConsoleService);
			this.mCService.unregisterListener(ConsoleWatcher);
		} catch (ex) {}
	},
	observe: function(oError) {
		if (!oError || !oError.QueryInterface) { return; }
		try { var x = oError.QueryInterface(Components.interfaces.nsIScriptError); } catch(ex) {}
		try {
			if ((oError.message == "") && (oError.category == undefined)) {
				this.fadeStatus();
			}
		} catch(ex) {}
	},
	handleError: function(event) {
		if (!event.view) { return; }
		if (event.view.name == "") { event.view.name = "tb" + (new Date().getTime()); }
		this.setError(event.view.name, "error");
		this.updateStatusButton();
	},
	updateStatusButton: function() {
		try {
			var mPC = this.Browser.mPanelContainer;
			this.StatusButton.setAttribute("level", this.getError(mPC.childNodes[mPC.selectedIndex].contentWindow.name));
		} catch(ex) {}
	},
	fadeStatus: function() {
		for (i=0; i < this.arrErrors.length; i++) {
			if (this.arrErrors[i] == "error") {
				this.arrErrors[i] = "errorFade";
			}
		}
		this.updateStatusButton();
	},
	resetErrorLevel: function(event) {
		if (event.view) {
			this.setError(event.view.name, "");
		} else {
			this.trimArrays();
		}
		this.updateStatusButton();
	},
	getCurrentViewName: function() {
		try {
			var mPC = this.Browser.mPanelContainer;
			return mPC.childNodes[mPC.selectedIndex].contentWindow.name;
		} catch(ex) { return ""; }
	},
	getTabIndex: function(strName) {
		for (var i=0; i < this.arrTabs.length; i++) {
			if (this.arrTabs[i] == strName) { return i; }
		}
		return -1;
	},
	addError: function(strName) {
		if (this.getTabIndex(strName) < 0) {
			var i = this.arrTabs.length;
			this.arrTabs[i] = strName;
			this.arrErrors[i] = "";
			return i;
		}
		return -1;
	},
	getError: function(strName) {
		var i = this.getTabIndex(strName);
		return (i >= 0) ? this.arrErrors[i] : "";
	},
	setError: function(strName, strValue) {
		if (!strName) { return; }
		var i = this.getTabIndex(strName);
		if (i < 0) { i = this.addError(strName); }
		this.arrErrors[i] = strValue;
	},
	trimArrays: function() {
		try {
			var arrViewNodes = ConsoleWatcher.Browser.mPanelContainer.childNodes;
			var i, j, found, junk;
			for (i=0; i < this.arrTabs.length; i++) {
				found = false;
				for (j=0; j < arrViewNodes.length; j++) {
					if (this.arrTabs[i] == arrViewNodes[j].contentWindow.name) { found = true; break; }
				}
				if (!found) {
					junk = this.arrTabs.splice(i, 1);
					junk = this.arrErrors.splice(i, 1);
					i--;
				}
			}
		} catch(ex) { alert(ex); }
	}
}
window.addEventListener("load", function() { ConsoleWatcher.init(); }, false);
window.addEventListener("unload", function() { ConsoleWatcher.destruct(); }, false);

function ConsoleWatcher_handleError(event) {
	ConsoleWatcher.handleError(event);
}
function ConsoleWatcher_updateStatusButton() {
	ConsoleWatcher.updateStatusButton();
}
function ConsoleWatcher_resetErrorLevel(event) {
	ConsoleWatcher.resetErrorLevel(event);
}
