/*
 * pref-inauto.js
 *
 */

/***** Preference Dialog Functions *****/
//
var gPref = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
var checkboxes = ["inauto","clickSelectsAll","matchOnlyTyped"];

// load all preferences into the dialog
function inauto_EMinit()
{
  try {
    var i;
    for (i = 0; i < checkboxes.length; ++i) {
      var checkbox = document.getElementById(checkboxes[i]);
      checkbox.checked = gPref.getBoolPref(checkbox.getAttribute("prefstring"));
    }

    for (i = 0; i < lists.length; i++) {
      var element = document.getElementById(lists[i]);
      var prefstring = element.getAttribute("prefstring");
      element.selectedItem = element.getElementsByAttribute("value", gPref.getIntPref(prefstring))[0];
    }
    inauto_invertTabUI(true);
  }
  catch (e) {}
}

// save all preferences entered into the dialog
function inauto_EMsave()
{
  try {
    var i;
    for (i = 0; i < checkboxes.length; ++i) {
      var checkbox = document.getElementById(checkboxes[i]);
      gPref.setBoolPref(checkbox.getAttribute("prefstring"), checkbox.checked);
    }

    for (i = 0; i < lists.length; i++) {
      var element = document.getElementById(lists[i]);
      gPref.setIntPref(element.getAttribute("prefstring"), element.selectedItem.value);
    }
  }
  catch (e) {}

  return true;
}

// disables some of the dialog UI
function inauto_invertTabUI(how)
{
   var inauto = document.getElementById("inauto");
   var matchOnlyTyped = document.getElementById("matchOnlyTyped");
   var setting = null;
   if (how)
      setting = (inauto.checked) ? true : false;
   else
      setting = (!inauto.checked) ? true : false;

   // twiddle the setting
   if (setting) {
  	  matchOnlyTyped.disabled = false;
   }
   else {
      matchOnlyTyped.disabled = true;
   }
}