/* ***************
Desc: Installation script for HONcode Status
Modified version of Jed Brown installscript from QuickNote.
Author: Thierry Raguin <t.raguin@netunion.com>
Version: 1.0
Last modified: November 9th, 2004
****************** */
const author              = "Thierry Raguin";
const displayName         = "HONcode Status";
const name                = "honstatus";
const version             = "1.5";
var contentFlag           = CONTENT | PROFILE_CHROME;
var error                 = null;
var folder                = getFolder("Profile", "chrome");
var skinFlag              = SKIN | PROFILE_CHROME;
var jarName               = "chrome/" + name + ".jar";
var existsInApplication   = File.exists(getFolder(getFolder("chrome"), jarName));
var existsInProfile       = File.exists(getFolder(folder, jarName));
const SUCCESS_MESSAGE     = " can be enabled / disabled in 'Tools > Options > Extensions > HONcode Status Extension v1.5 > Settings'. \n Please restart your browser to continue.";

initInstall(displayName, name, version);

// If the extension exists in the application folder or it doesn't exist in the profile folder and the user doesn't want it installed to the profile folder
if(existsInApplication || (!existsInProfile && !confirm("Do you want to install the extension into your profile folder?\n(Cancel will install into the application folder)")))
{
    contentFlag = CONTENT | DELAYED_CHROME;
    folder      = getFolder("chrome");
    skinFlag    = SKIN | DELAYED_CHROME;
}

setPackageFolder(folder);
error = addFile(author, version, jarName, folder, null);

// If adding the JAR file succeeded
if(error == SUCCESS)
{
    folder = getFolder(folder, jarName);

    registerChrome(contentFlag, folder, "content/");

    error = performInstall();

    // If the install failed
    if(error == SUCCESS || error == 999)
    {
    	alert(displayName+" "+version+" has been succesfully installed.\n"+displayName + SUCCESS_MESSAGE);
    }else{
	alert("Install failed. Error code:" + error);
	cancelInstall(error);
    }
}
else
{
	alert("The installation of the extension failed.\n" + error + "\n Failed to create " +jarName+ " \n"
	      +"Make sure you have the correct permissions");
	cancelInstall(error);
}
