/* ***** BEGIN LICENSE BLOCK *****
 * - Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * -
 * - The contents of this file are subject to the Mozilla Public License Version
 * - 1.1 (the "License"); you may not use this file except in compliance with
 * - the License. You may obtain a copy of the License at
 * - http://www.mozilla.org/MPL/
 * -
 * - Software distributed under the License is distributed on an "AS IS" basis,
 * - WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * - for the specific language governing rights and limitations under the
 * - License.
 * -
 * - The Original Code is HONcode Status.
 * -
 * - The Initial Developer of the Original Code is Thierry Raguin
 * - This plugin is Copyright (C) 2003 NetUnion SARL. All Rights Reserved.
 * -
 * - Contributor(s):
 * -
 * -   Thierry Raguin <t.raguin@netunion.com>
 * -
 * - Alternatively, the contents of this file may be used under the terms of
 * - either the GNU General Public License Version 2 or later (the "GPL"), or
 * - the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * - in which case the provisions of the GPL or the LGPL are applicable instead
 * - of those above. If you wish to allow use of your version of this file only
 * - under the terms of either the GPL or the LGPL, and not to allow others to
 * - use your version of this file under the terms of the MPL, indicate your
 * - decision by deleting the provisions above and replace them with the notice
 * - and other provisions required by the LGPL or the GPL. If you do not delete
 * - the provisions above, a recipient may use your version of this file under
 * - the terms of any one of the MPL, the GPL or the LGPL.
 * -
 * - ***** END LICENSE BLOCK ***** */

var honList       = null;
var pref          = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
var honCode       = "";
var retrievedList = false;
var previousPage  = "";

function doClickHONcodeStatus()
{
  if (honCode == "")
  {
    getBrowser().addTab('http://www.hon.ch/HONcode/Conduct.html');
  }
  else
  {
    getBrowser().addTab('http://www.hon.ch/HONcode/Conduct.html?' + honCode);
  }
}

function getHONcodeStatus() 
{
	if (pref.getBoolPref("browser.toolbars.showbutton.honstatus"))
  {
    if (window.content != null) 
    {
      if (window.content.document.location.href != "about:blank")
      {
        if (!retrievedList)
        {
          honList        = new XMLHttpRequest();
          honList.onload = displayHONcodeStatus;
          honList.open("GET", "http://www.hon.ch/HONcode/Plugin/listeMD5.txt");
          honList.send(null);
          
          retrievedList = true;
        }
        else
        {
          if (honList == null)
          {
            retrievedList = false;  
          }
          
          if ((window.content != null) 
              && (previousPage != window.content.document.location.href))
          {
            window.setTimeout(displayHONcodeStatus, 1000);
          }
        }
      }
    }
    
    window.setTimeout(getHONcodeStatus, 1000);
  }
}

function displayHONcodeStatus()
{
  if ((window.content != null) 
      && (honList != ""))
  {
    if (previousPage != window.content.document.location.href)
    {
      previousPage = window.content.document.location.href;
      
      var topLevelDomain = window.content.document.location.hostname;
      
      // Removes starting "www."
      if (topLevelDomain.indexOf("www.") == 0)
        topLevelDomain = topLevelDomain.substr(topLevelDomain.indexOf("www.") + 4);
      
      // Change the icon superimposed on the box to reflect HONcode status.
      var icon    = document.getElementById('honstatus-icon');
      var tooltip = document.getElementById('honstatus-tooltip-text');
      
      var myHONaccreditedURL = checkURLInHONList(topLevelDomain + window.content.document.location.pathname);

      if (myHONaccreditedURL == "")
      {
        icon.setAttribute("honstatus", "invalid");

        tooltip.value = "This website is not HONcode accredited";
        honCode       = "";
      }
      else
      {
        icon.setAttribute("honstatus", "valid");
        
        indexURL      = honList.responseText.search("\n" + hex_md5(topLevelDomain + "/") + " HONConduct");
        //indexHON      = honList.responseText.indexOf("HONConduct", indexURL);
        //honCode       = honList.responseText.substring(indexHON, indexHON + 16);
        tooltip.value = "This site subscribes to the HONcode principles. Click to view certificate"; //"This website is HONcode accredited (" + honCode + "). Click to view certificate";
      }    
    }
  }
}

function checkURLInHONList(myURL)
{
  var result = "";
  
  // Invert myURL
  var tempURL = "";
  for (i = myURL.length - 1; i >= 0; --i)
  {
    tempURL += myURL.charAt(i);
  }
  myURL = tempURL;

  var indexLastSlash = myURL.indexOf("/");

  if (indexLastSlash != -1)
    myURL = myURL.substring(indexLastSlash + 1, myURL.length);

  // Invert myURL
  var tempURL = "";
  for (i = myURL.length - 1; i >= 0; --i)
  {
    tempURL += myURL.charAt(i);
  }
  myURL = tempURL;

  if (honList.responseText.search("\n" + hex_md5(myURL + "/") + " HONConduct") != -1)
  {
    result   = myURL;
    indexURL = honList.responseText.search("\n" + hex_md5(myURL + "/") + " HONConduct");
    indexHON = honList.responseText.indexOf("HONConduct", indexURL);
    honCode  = honList.responseText.substring(indexHON, indexHON + 16);
  }
  else if (myURL.indexOf("/") != (myURL.length - 1)) // sub directories
  {
    myURL = myURL.substring(0, myURL.length - 1);

    if (myURL.indexOf("/") != -1)
      result = checkURLInHONList(myURL);
  }
  
  return result;
}

function honstatusUpdateTooltip(tipElement)
{
  if (tipElement != document.getElementById("honstatus-button"))
  {
    return false;
  }
  else
  {
    return true;
  }
}

// Check the status a second after the browser loads.
if (pref.getBoolPref("browser.toolbars.showbutton.honstatus"))
{
  window.setTimeout(getHONcodeStatus, 1000);
}
