const HM_PREF_SERVICE = Components.classes["@mozilla.org/preferences-service;1"]
        .getService(Components.interfaces.nsIPrefService);

const HM_PREF_BRANCH = HM_PREF_SERVICE.getBranch("extensions.headermonitor.");

const HM_OBSERV_SERVICE = Components.classes["@mozilla.org/observer-service;1"]
        .getService(Components.interfaces.nsIObserverService);

function hmPrefsLoad() {

	document.getElementById("hm-maxwidth").value = HM_PREF_BRANCH.getIntPref("maxWidth");
	document.getElementById("hm-header-ifexist").checked = HM_PREF_BRANCH.getBoolPref("DisplayIfExistHeader");
	document.getElementById("hm-header-displayname").checked = HM_PREF_BRANCH.getBoolPref("DisplayHeaderName");
	var hmSH = HM_PREF_BRANCH.getCharPref("header");
	var hmList = document.getElementById("hm-headerselect");
	var items = hmList.firstChild.childNodes;
    for (i = 0; i < items.length; i++)
	{
		if( items[i].label == hmSH ) {hmList.selectedItem = items[i]; break;}
	}

}


function hmSaveSettings() {

        HM_PREF_BRANCH.setCharPref("header",document.getElementById("hm-headerselect").selectedItem.label);
	HM_PREF_BRANCH.setIntPref("maxWidth",document.getElementById("hm-maxwidth").value);
	HM_PREF_BRANCH.setBoolPref("DisplayIfExistHeader",document.getElementById("hm-header-ifexist").checked);
	HM_PREF_BRANCH.setBoolPref("DisplayHeaderName",document.getElementById("hm-header-displayname").checked);

	HM_OBSERV_SERVICE.notifyObservers(null, "hm-load-prefs", false);


}
