function gm_xpcom_connection(){

}

gm_xpcom_connection.prototype.observer = function(aCallbackFunc){
  return ({
    data : "",
   
    onStartRequest : function (aRequest, aContext) {
      this.data = "";
    },

    onDataAvailable : function (aRequest, aContext, aStream, aSourceOffset, aLength){
      netscape.security.PrivilegeManager.enablePrivilege('UniversalXPConnect');

      var scriptableInputStream = Components.classes["@mozilla.org/scriptableinputstream;1"].createInstance(Components.interfaces.nsIScriptableInputStream);
      scriptableInputStream.init(aStream);

      this.data += scriptableInputStream.read(aLength);
    },

    onStopRequest : function (aRequest, aContext, aStatus) {
      netscape.security.PrivilegeManager.enablePrivilege('UniversalXPConnect');

      aCallbackFunc(this.data, aRequest);
    },

    QueryInterface : function(aIID) {
      if (aIID.equals(Components.interfaces.nsIStreamListener) ||
          aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
         aIID.equals(Components.interfaces.nsISupports))
        return this;
        throw Components.results.NS_NOINTERFACE;
      }            
    } 
  );
}

gm_xpcom_connection.prototype.start = function (aURL, aPostData, aCookieData, aReferrer, aCallbackFunc){

  netscape.security.PrivilegeManager.enablePrivilege('UniversalXPConnect');

  // the IO service
  var ioService = Components.classes[kIOSERVICE_CONTRACTID].getService(nsIIOService);
      
  // create an nsIURI
  var uri = ioService.newURI(aURL, null, null);

  //nsIInputStream
  var uploadStream = Components.classes["@mozilla.org/io/string-input-stream;1"].createInstance(Components.interfaces.nsIStringInputStream);

  if (aPostData)
    uploadStream.setData(aPostData, aPostData.length);

  // get a channel for that nsIURI
  var channel = ioService.newChannelFromURI(uri);
     
  // get a httpchannel and make it a post
  var httpChannel = channel.QueryInterface(Components.interfaces.nsIHttpChannel);
      
  // set a referrer
  if (aReferrer) {
    var referrerUri = ioService.newURI(aReferrer, null, null);
    httpChannel.referrer = referrerUri;
  }  

  if (aPostData) {
    var uploadChannel = channel.QueryInterface(Components.interfaces.nsIUploadChannel);
    uploadChannel.setUploadStream(uploadStream, "application/x-www-form-urlencoded", -1);
      
    // order important - setUploadStream resets to get/put
    httpChannel.requestMethod = "POST";
  }  

  if (aCookieData){
//    httpChannel.setRequestHeader("Cookie", aCookieData, false);
    for (var run = 0; run < aCookieData.length; run++){
      httpChannel.setRequestHeader("Cookie", aCookieData[run], true);
    }  
  }

  var observer = new this.observer(aCallbackFunc);

  channel.asyncOpen(observer, null);
}