function gm_prefs(){
  this.prefBranch = null;
  
  // pref values
  this.PREF_STATUSBAR_ENABLED     = "gm-notifier.sidebar.enabled"; // oops, sidebar?
  this.PREF_UPDATE_INTERVAL       = "gm-notifier.update.interval";
  this.PREF_LOAD_LOCATION         = "gm-notifier.loadgm.location";
  this.PREF_AUTOLOGIN_ENABLED     = "gm-notifier.autologin.enabled";
  this.PREF_NOTIFICATIONS_ENABLED = "gm-notifier.ui.notification.enabled";
  this.PREF_DEFAULT_USER          = "gm-notifier.users.default";
  this.PREF_REMEMBER_PASSWORD     = "gm-notifier.users.remember-password";
  this.PREF_IS_LOGGED_IN          = "gm-notifier.loggedin";
}

gm_prefs.prototype.getPrefBranch = function(){
  if (!this.prefBranch){ 
    this.prefBranch = Components.classes['@mozilla.org/preferences-service;1'];
    this.prefBranch = this.prefBranch.getService();
    this.prefBranch = this.prefBranch.QueryInterface(Components.interfaces.nsIPrefBranch);
  }
  
  return this.prefBranch;
}

gm_prefs.prototype.setBoolPref = function(aName, aValue){
  var myPrefs = this.getPrefBranch();
  
  myPrefs.setBoolPref(aName, aValue);
}


gm_prefs.prototype.getBoolPref = function(aName){
  var myPrefs = this.getPrefBranch();
  var rv = null;

  try{
    rv = myPrefs.getBoolPref(aName);
  } catch (e){
  
  }
  
  return rv;
}

gm_prefs.prototype.setIntPref = function(aName, aValue){
  var myPrefs = this.getPrefBranch();
  
  myPrefs.setIntPref(aName, aValue);
}


gm_prefs.prototype.getIntPref = function(aName){
  var myPrefs = this.getPrefBranch();
  var rv = null;

  try{
    rv = myPrefs.getIntPref(aName);
  } catch (e){
  
  }
  
  return rv;
}

gm_prefs.prototype.setCharPref = function(aName, aValue){
  var myPrefs = this.getPrefBranch();
  
  myPrefs.setCharPref(aName, aValue);
}


gm_prefs.prototype.getCharPref = function(aName){
  var myPrefs = this.getPrefBranch();
  var rv = null;

  try{
    rv = myPrefs.getCharPref(aName);
  } catch (e){
  
  }
  
  return rv;
}

gm_prefs.prototype.addObserver = function(aDomain, aFunction){
  var myPrefs = this.getPrefBranch();
  var prefBranchInternal = myPrefs.QueryInterface(Components.interfaces.nsIPrefBranchInternal);
                                                                                             
  if (prefBranchInternal)
    prefBranchInternal.addObserver(aDomain, aFunction, false);
}
