/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Gmail Notifier code.
 *
 * The Initial Developer of the Original Code is
 * Doron Rosenberg.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

/*
   XXX: automatically login on new window if username/password is known.
        The pref gm-notifier.loggedin already exists.

*/
const kCOOKIESERVICE_CONTRACTID = "@mozilla.org/cookieService;1";
const kIOSERVICE_CONTRACTID = "@mozilla.org/network/io-service;1";
const nsISupports = Components.interfaces.nsISupports;
const nsIIOService = Components.interfaces.nsIIOService;
const nsICookieService = Components.interfaces.nsICookieService;
const nsICookieManager = Components.interfaces.nsICookieManager;
const nsIProtocolHandler = Components.interfaces.nsIProtocolHandler;
const nsIURI = Components.interfaces.nsIURI;

function gm_notifier() {

  this.observer;
  this.gm_browser;
  this.user_name;
  this.password;
  this.is_logged_in = false;
  this.login_window;
  
  this.check_interval_num;
  this.check_interval = null;

  this.new_emails_num = 0;
  this.space_used_mb = 0;
  this.space_used_percent = "0%";
  
  this.gm_prefs = new gm_prefs();
  
  this.labels = new Array();
  
  // init prefs
  var arePrefsSet = this.gm_prefs.getBoolPref(this.gm_prefs.PREF_NOTIFICATIONS_ENABLED);
  
  if (arePrefsSet == null){
    //prefs haven't been set yet
    this.initPref(this.gm_prefs.PREF_STATUSBAR_ENABLED , "bool", true);
    this.initPref(this.gm_prefs.PREF_UPDATE_INTERVAL, "int", 10);
    this.initPref(this.gm_prefs.PREF_DEFAULT_USER, "char", "");
    this.initPref(this.gm_prefs.PREF_REMEMBER_PASSWORD, "bool", false);
    this.initPref(this.gm_prefs.PREF_LOAD_LOCATION, "int", 0);
    this.initPref(this.gm_prefs.PREF_AUTOLOGIN_ENABLED, "bool", false);
    this.initPref(this.gm_prefs.PREF_IS_LOGGED_IN, "bool", false);
    this.initPref(this.gm_prefs.PREF_NOTIFICATIONS_ENABLED, "bool", true);
  }

  // add pref observers
  this.PrefChangeObserver = {
  
    observe: function(aSubject, aTopic, aData)
    {
      gGMailNotifier.prefChanged(aData);
    }
  };

  this.gm_prefs.addObserver("gm-notifier", this.PrefChangeObserver);
}

gm_notifier.prototype.initPref = function (aPrefName, aPrefType, aDefaultValue){

  switch (aPrefType) {
    case "bool" :
      var prefExists = this.gm_prefs.getBoolPref(aPrefName);
      if (prefExists == null)
        this.gm_prefs.setBoolPref(aPrefName, aDefaultValue);
      break;

    case "int" :
      var prefExists = this.gm_prefs.getIntPref(aPrefName);
      if (prefExists == null)
        this.gm_prefs.setIntPref(aPrefName, aDefaultValue);
      break;

    case "char" :
      var prefExists = this.gm_prefs.getCharPref(aPrefName);
      if (prefExists == null)
        this.gm_prefs.setCharPref(aPrefName, aDefaultValue);
      break;
  }
}

gm_notifier.prototype.prefChanged = function (aPrefName){
  switch(aPrefName){
    case gGMailNotifier.gm_prefs.PREF_STATUSBAR_ENABLED:
      gGMailNotifier.showSidebarItem();
      break;

    case gGMailNotifier.gm_prefs.PREF_UPDATE_INTERVAL:
      gGMailNotifier.check_interval_num = gGMailNotifier.gm_prefs.getIntPref(gGMailNotifier.gm_prefs.PREF_UPDATE_INTERVAL);
      gGMailNotifier.set_interval_listener();
      break;
  }
}

gm_notifier.prototype.onload = function (){

  document.getElementById("gm-notifier-statusbar").collapsed = !gGMailNotifier.gm_prefs.getBoolPref(gGMailNotifier.gm_prefs.PREF_STATUSBAR_ENABLED);
  document.getElementById("gm-notifier-statusbar").setAttribute("logged-in", "false")
  document.getElementById("gm-context-menu-statusbar-item").setAttribute("checked", gGMailNotifier.gm_prefs.getBoolPref(gGMailNotifier.gm_prefs.PREF_STATUSBAR_ENABLED));

  gGMailNotifier.check_interval_num = gGMailNotifier.gm_prefs.getIntPref(gGMailNotifier.gm_prefs.PREF_UPDATE_INTERVAL);

  window.removeEventListener("load", gGMailNotifier.onload, false);
  
  // autologin or not?
  var autologin = gGMailNotifier.gm_prefs.getBoolPref(gGMailNotifier.gm_prefs.PREF_AUTOLOGIN_ENABLED);

  if (autologin){
    gGMailNotifier.user_name = gGMailNotifier.gm_prefs.getCharPref(gGMailNotifier.gm_prefs.PREF_DEFAULT_USER);
    if (gGMailNotifier.user_name) {
      gGMailNotifier.password = gGMailNotifier.getLoginDetails(gGMailNotifier.user_name);
      gGMailNotifier._talkToServer();
    }  
  }
}

gm_notifier.prototype.setLoginStatus = function (aStatusNum){
  if (this.login_window && this.login_window.document){
    this.login_window.setStatus(aStatusNum);
  }
}

gm_notifier.prototype.onFinishLoad = function (){
  this.trying_to_login = false;

  this.is_logged_in = true;

  this.setLoginStatus(2);
  
  this.gm_prefs.setBoolPref(this.gm_prefs.PREF_IS_LOGGED_IN, true);

  // set UI labels         
  this.updateLabels();

  document.getElementById("gm-context-menu-logout").setAttribute("disabled", false);

  this.set_interval_listener();
}

gm_notifier.prototype.updateLabels = function (){

  document.getElementById("gm-notifier-statusbar").setAttribute("logged-in", this.is_logged_in);

  if (this.is_logged_in){
    if (document.getElementById("gmail-emailnum"))
      document.getElementById("gmail-emailnum").value = this.is_logged_in ? this.new_emails_num : " ";

    if (document.getElementById("gm-notifier-statusbar")) {
      document.getElementById("gm-notifier-statusbar").setAttribute("label",
        this.is_logged_in ? ("(" + this.new_emails_num + ")") : "");
    }

    // window.content.document.body.innerHTML +="<div style='padding:5px; background-color:yellow; border: 1px solid black; -moz-border-radius:3px; position:absolute; right:10px; bottom:10px;'><b>New Gmail!</b></div>"
  } else {
    if (document.getElementById("gmail-emailnum")) {
      document.getElementById("gmail-emailnum").value = "";
      //document.getElementById("gmail-emailnum").className = "logged-out";
    }  

    if (document.getElementById("gm-notifier-statusbar")) {
      document.getElementById("gm-notifier-statusbar").setAttribute("label", "");
    }
  }
}

gm_notifier.prototype.set_interval_listener = function(){
  if (this.check_interval)
    clearInterval(this.check_interval);
  
  // if interval is 0, do nothing.
  
  if (this.is_logged_in && (this.check_interval_num > 0) )
    this.check_interval = setInterval("gGMailNotifier.interval_listener()", this.check_interval_num*60000)
}

gm_notifier.prototype.interval_listener = function(){
  gGMailNotifier._talkToServer();
}

gm_notifier.prototype.init = function (aUserName, aPassword){

  this.user_name = aUserName;
  this.password = aPassword;


  this.setLoginStatus(1);

  this._talkToServer();
}

gm_notifier.prototype.login = function (aEvent){
  // on windows, right click calls this method
  if (aEvent && (aEvent.button == 2))
    return;

  if (!this.is_logged_in) {
    this.openLoginWindow();
  } else {
    // middle click should open in new tab - from statusbar
    if ((this.is_logged_in) && (aEvent) && (aEvent.button == 1))
      this.loadGM(1);
    else
      this.loadGM();
  }  
}

gm_notifier.prototype.openLoginWindow = function (){
  this.login_window = window.openDialog("chrome://gm-notifier/content/gm-login.xul", "_blank", "chrome,resizable=no,dependent=yes");
}

gm_notifier.prototype._talkToServer = function (){

  var con = new gm_xpcom_connection();
  var data = "service=mail&Email=" + encodeURI(this.user_name) + "&Passwd=" + encodeURI(this.password) + "&null=Sign%20in";

  con.start("https://www.google.com/accounts/ServiceLoginBoxAuth", data, null,
            "https://www.google.com/", gGMailNotifier.callback_1);
}

gm_notifier.prototype.callback_1 = function (aData, aRequest){
  var httpChannel = aRequest.QueryInterface(Components.interfaces.nsIHttpChannel)
  var cookieData = httpChannel.getRequestHeader("cookie");

  var con = new gm_xpcom_connection();

  var val = aData.match(/var cookieVal= "([^"]+)";/);

  if (!val) {
    // failed to login
    gGMailNotifier.loginFailed();
    document.getElementById("gm-context-menu-logout").setAttribute("disabled", true);
    return;
  }
  
  var cookieD = "GV=" + val[1];

  // due to bug 250375, have to use the cookieservice rather than httpChannel.setRequestHeader
  var ios = Components.classes[kIOSERVICE_CONTRACTID].getService(nsIIOService);
  var cookURI = ios.newURI("http://gmail.google.com", null, null);
  var cookChan = ios.newChannelFromURI(cookURI);
  var cookServ = Components.classes[kCOOKIESERVICE_CONTRACTID].getService(nsICookieService);
  cookServ.setCookieString(cookURI, null, cookieD, cookChan);

  con.start("https://www.google.com/accounts/CheckCookie?service=mail&chtml=LoginDoneHtml", 
             null, null, "https://www.google.com/", gGMailNotifier.callback_2);
}

gm_notifier.prototype.callback_2 = function (aData, aRequest){
  var httpChannel = aRequest.QueryInterface(Components.interfaces.nsIHttpChannel)
  var cookieData = httpChannel.getRequestHeader("cookie");
      
  var con = new gm_xpcom_connection();

  con.start("https://gmail.google.com/gmail?search=adv&as_subset=unread&view=tl&start=0", 
             null, null, "https://www.google.com/", gGMailNotifier.callback_3);
}

gm_notifier.prototype.callback_3 = function (aData, aRequest){
  var val = aData.match(/\["ds",.*\]/);
 
  var myArray = eval(val[0]);
  if (myArray[1] > gGMailNotifier.new_emails_num)
    gGMailNotifier.newMailNotification(myArray[1] - gGMailNotifier.new_emails_num);

  gGMailNotifier.new_emails_num = myArray[1];

  val = aData.match(/\["qu",.*\]/);
  myArray = eval(val[0]);
  gGMailNotifier.space_used_mb = myArray[1];
  gGMailNotifier.space_used_percent = myArray[3];

  // handle gmail labels
  var x = aData.indexOf("D([\"ct\"");
  var y = aData.indexOf("D([\"ts\"");
  var z = aData.substr(x+2, y-x-5);

  var myAr = eval(z)[1];

  // new array, so that removed labels get removed.
  /*
  var new_labels_array = new Array();

  for (var run = 0; run < myAr.length; run++){
    var l_name = myAr[run][0];
    var l_unread = myAr[run][1];

    if (gGMailNotifier.labels[l_name])
      new_labels_array[l_name] = new gm_label(l_name, l_unread, gGMailNotifier.labels[l_name].unread);
    else 
      new_labels_array[l_name] = new gm_label(l_name, l_unread);
  }
  
  gGMailNotifier.labels = new_labels_array;

  var myTooltipRows = document.getElementById("gm-tooltip-row");
  */
  // clear current entries
/*  for (var run = myTooltipRows.childNodes.length; run--; run > 0){
    myTooltipRows.removeChild(myTooltipRows.childNodes.item(run))
  }

  for (var labelName in gGMailNotifier.labels) {
    var myRow = document.createElement("row");
    
    var myLabel = document.createElement("label");
    myLabel.setAttribute("value", labelName);
    myRow.appendChild(myLabel);

    myLabel = document.createElement("label");
    
    if (gGMailNotifier.labels[labelName].prev_unread && (gGMailNotifier.labels[labelName].unread > gGMailNotifier.labels[labelName].prev_unread) )
      myLabel.setAttribute("value", gGMailNotifier.labels[labelName].unread + " (" + (gGMailNotifier.labels[labelName].unread - gGMailNotifier.labels[labelName].prev_unread) + ")");
    else
      myLabel.setAttribute("value", gGMailNotifier.labels[labelName].unread);
    myRow.appendChild(myLabel);
    
    myTooltipRows.appendChild(myRow);
  }*/

  gGMailNotifier.onFinishLoad();     
}
gm_notifier.prototype.fillInTooltip = function(aTooltipElement){
  document.getElementById("gm-notifier-tooltip-logged-in").collapsed = !this.is_logged_in;
  document.getElementById("gm-notifier-tooltip-logged-out").collapsed = this.is_logged_in;

  if (this.is_logged_in) {
     document.getElementById("gm-notifier-tooltip-username").value = this.user_name;

     document.getElementById("gm-notifier-tooltip-unread").value = 
         "You have " + this.new_emails_num + " unread emails in your inbox.";

     document.getElementById("gm-notifier-tooltip-quota").value = 
         "You are currently using " + this.space_used_mb + " (" + this.space_used_percent + ") of your 1000 MB.";
  } else {
  }
}

gm_notifier.prototype.storeLoginDetails = function(aStoreInfo){
  var url = "chrome://gm-notifier/";

  var passwordManager = Components.classes["@mozilla.org/passwordmanager;1"].createInstance();

  if (passwordManager) {
    passwordManager = passwordManager.QueryInterface(Components.interfaces.nsIPasswordManager);

    try{
      passwordManager.removeUser(url, this.user_name);
    } catch (e) {  
    }
  
    if (aStoreInfo) {
      this.gm_prefs.setBoolPref("gm-notifier.users.remember-password", true);
      this.gm_prefs.setCharPref("gm-notifier.users.default", this.user_name);
      passwordManager.addUser(url, this.user_name, this.password);
    }  
  }    
}

gm_notifier.prototype.getLoginDetails = function(aUsername){
  var url = "chrome://gm-notifier/";

  var passwordManager = Components.classes["@mozilla.org/passwordmanager;1"].createInstance(Components.interfaces.nsIPasswordManagerInternal);
  var host = {value:""};
  var user =  {value:""};
  var password = {value:""}; 

  try {
    passwordManager.findPasswordEntry(url, aUsername, "", host, user, password);
  } catch(e){
  }  

  return password.value;
}

gm_notifier.prototype.showSidebarItem = function (aShowItem){
   if (aShowItem != null){
     this.gm_prefs.setBoolPref(this.gm_prefs.PREF_STATUSBAR_ENABLED, aShowItem);
   }

   var prefValue = aShowItem ? aShowItem : this.gm_prefs.getBoolPref(this.gm_prefs.PREF_STATUSBAR_ENABLED);

   document.getElementById("gm-notifier-statusbar").collapsed = !prefValue;
   document.getElementById("gm-context-menu-statusbar-item").checked = prefValue;
}

gm_notifier.prototype.loadPrefWindow = function (){
  window.openDialog("chrome://gm-notifier/content/gm-preferences.xul", "_blank", "chrome,resizable=no,dependent=yes")
}

// loadGM location is determined by gm-notifier.loadgm.location
// 0 - current tab
// 1 - new tab
// 2 - new window  
gm_notifier.prototype.loadGM = function (aOverride){
  const gm_url = "https://gmail.google.com/gmail";
  var location = aOverride ? aOverride : this.gm_prefs.getIntPref(this.gm_prefs.PREF_LOAD_LOCATION);
  
  if (location == 2){
    window.open(gm_url);
  } else if (location == 1){
    document.getElementById("content").addTab(gm_url, null, null);
  } else {
    document.getElementById("content").loadURI(gm_url);
  }
}

gm_notifier.prototype.checkNow = function (){
  if (this.is_logged_in){
    this._talkToServer();  
  } else {
    this.openLoginWindow();
  }
}

gm_notifier.prototype.logout = function (){
  if (this.is_logged_in){
    this.is_logged_in = false;
    
    this.set_interval_listener();
    
    this.gm_prefs.setBoolPref(this.gm_prefs.PREF_IS_LOGGED_IN, false);

    // clear the login cookie
    try{
      var ios = Components.classes[kIOSERVICE_CONTRACTID].getService(nsIIOService);
      var cookMan = Components.classes[kCOOKIESERVICE_CONTRACTID].getService(nsICookieManager);
      cookMan.remove("gmail.google.com", "GV", "/", false);
    }catch(e){}

    document.getElementById("gm-context-menu-logout").setAttribute("disabled", true);
    this.updateLabels();
  }
}

gm_notifier.prototype.openMiddleClick = function (aEvent){
  // middle click should open in new tab
  if ((this.is_logged_in) && (aEvent) && (aEvent.button == 1))
    this.loadGM(1);
}

gm_notifier.prototype.loginFailed = function (){
   this.setLoginStatus(3);
   this.is_logged_in = false;
   this.gm_prefs.setBoolPref(this.gm_prefs.PREF_IS_LOGGED_IN, false);
   this.updateLabels();
}

gm_notifier.prototype.newMailNotification = function (aNewNum){
  var isNotificationEnabled = gGMailNotifier.gm_prefs.getBoolPref(gGMailNotifier.gm_prefs.PREF_NOTIFICATIONS_ENABLED);

  if (!isNotificationEnabled)
    return;

  var msg = "You have " + aNewNum + " unread messages in your Gmail inbox.";

  try {
    var alertService = Components.classes["@mozilla.org/alerts-service;1"]
                                 .getService(Components.interfaces.nsIAlertsService);
    alertService.showAlertNotification("chrome://gm-notifier/content/gm-logo.png",
                                  "You have new Gmail", msg, true, "", this);
  } catch(e) {}
}

gm_notifier.prototype.onAlertFinished = function (aCookie){
}

gm_notifier.prototype.onAlertClickCallback = function (aCookie){
  this.loadGM();
}

// shutdown
gm_notifier.prototype.onunload = function (){
  gGMailNotifier = null;
}

var gGMailNotifier = new gm_notifier();

// gm labels
function gm_label(aName, aUnread, aPrevUnread) {
  this.name = aName;
  this.unread = aUnread;
  
  this.prev_unread = null;
  
  if (aPrevUnread)
    this.prev_unread = aPrevUnread;
}

window.addEventListener("load", gGMailNotifier.onload, false);
window.addEventListener("unload", gGMailNotifier.onunload, false);