function onLoad(){
  sizeToContent();
  
  document.getElementById("status").value = getLocalizedString("LoggingStatusLoggedOut");
  
  var username = window.opener.gGMailNotifier.gm_prefs.getCharPref("gm-notifier.users.default");
  
  if (username){
    document.getElementById("username").value = username;
    
    document.getElementById("password").value = window.opener.gGMailNotifier.getLoginDetails(username);

    document.getElementById("store-password").checked = window.opener.gGMailNotifier.gm_prefs.getBoolPref("gm-notifier.users.remember-password");
      
  }
}

function getLocalizedString(aName){
  var strbundle=document.getElementById("strings");
  return strbundle.getString(aName);
}

function onAccept(){
  window.opener.gGMailNotifier.init(
       document.getElementById("username").value, 
       document.getElementById("password").value
       );

  return false;
}

function setStatus(aStatusNum){
  var statusMsg = "";
  var statusErrorMsg = "";

  switch (aStatusNum){
 
    // trying to log in 
    case 1:
      document.getElementById("login").disabled = true;
      statusMsg = getLocalizedString("LoggingStatusLoggingIn");
      break;

    // logged in
    case 2:
      statusMsg = getLocalizedString("LoggingStatusLogedIn");

      window.opener.gGMailNotifier.storeLoginDetails(document.getElementById("store-password").checked);
      
      setTimeout("window.close()", 1000)
      break;

    // failed to login
    case 3:
      statusMsg = getLocalizedString("LoggingStatusFailed1");
      statusErrorMsg = getLocalizedString("LoggingStatusFailed2");
      document.getElementById("login").disabled = false;
      break;

    default:
      statusMsg = getLocalizedString("LoggingStatusError");
      break
  }
  
  document.getElementById("status").value = statusMsg;
  document.getElementById("status-error").value = statusErrorMsg;      

}