// User defined constants

const myProductName = "gm-notifier";
const myProductRegKey = "/gm-notifier";
const myProductRegVersion = "0.3.3";
const myJarFileName = "gm-notifier.jar";

// Installation Script - no user modifications needed

// OS type detection
// which platform?
function getPlatform()
{
  var platformStr;
  var platformNode;

  if('platform' in Install)
  {
    platformStr = new String(Install.platform);

    if (!platformStr.search(/^Macintosh/))
      platformNode = 'mac';
    else if (!platformStr.search(/^Win/))
      platformNode = 'win';
    else if (!platformStr.search(/^OS\/2/))
      platformNode = 'win';
    else
      platformNode = 'unix';
  }
  else
  {
    var fOSMac  = getFolder("Mac System");
    var fOSWin  = getFolder("Win System");

    logComment("fOSMac: "  + fOSMac);
    logComment("fOSWin: "  + fOSWin);

    if(fOSMac != null)
      platformNode = 'mac';
    else if(fOSWin != null)
      platformNode = 'win';
    else
      platformNode = 'unix';
  }

  return platformNode;
}

var err = initInstall(myProductName, myProductRegKey, myProductRegVersion);
logComment("initInstall: " + err);

//fChrome = getFolder("Chrome");
fChrome = getFolder("Profile", "chrome");

setPackageFolder(fChrome);
err = addFile("chrome/"+myJarFileName);
                     
logComment("addFile() returned: " + err);

logComment("Url is: " + getFolder(fChrome,myJarFileName) + "content/");

regErr = registerChrome(PACKAGE | PROFILE_CHROME, getFolder(fChrome,myJarFileName), "content/gm-notifier/");
logComment("regChrome (package) returned: " + regErr);

regErr = registerChrome(LOCALE | PROFILE_CHROME, getFolder(fChrome,myJarFileName), "locale/en-US/gm-notifier/"); 
logComment("regChrome (locale) returned: " + regErr);

if ((getLastError() == 0) || (getLastError() == -202))
  performInstall(); 
else
  cancelInstall(err);
