/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is FirefoxView Mozilla Extension.
 * The Initial Developer of the Original Code is Alex Sirota <alex@elbrus.com>. 
 * Portions created by Alex Sirota are Copyright (C) 2004 Alex Sirota. All Rights Reserved.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

function firefoxViewGetOpenPageText() {
	var strbundle = document.getElementById("firefoxview-strings");
	var str = strbundle.getString("viewPage");
	return str;
}

function firefoxViewGetOpenLinkText() {
	var strbundle = document.getElementById("firefoxview-strings");
	var str = strbundle.getString("viewLink");
	return str;
}

function firefoxViewGetHome() {
	var directoryService = Components.classes['@mozilla.org/file/directory_service;1']
						.getService(Components.interfaces.nsIProperties);
	var homeDir = directoryService.get('ProfD',
                   	Components.interfaces.nsILocalFile);
                   	
	homeDir.append("extensions");
	homeDir.append("{5D558C43-550F-4b12-84AB-0D8ABDA9F975}");

	return homeDir;
}

function firefoxViewInstall() {
	var homeDir = firefoxViewGetHome();
	var installFile = homeDir.clone().QueryInterface(Components.interfaces.nsILocalFile);
	installFile.append("install.vbs");
	var outputStream = Components.classes["@mozilla.org/network/file-output-stream;1"]
					.createInstance( Components.interfaces.nsIFileOutputStream );		
	outputStream.init(installFile, 0x04 | 0x08 | 0x20, 420, 0 );
	var output = '';
	output += 'Dim WshShell';
	output += '\n' + 'Set WshShell = WScript.CreateObject("WScript.Shell")';

	output += '\n' + 'WSHShell.RegWrite ';
	output += '"HKEY_CURRENT_USER\\Software\\Microsoft\\Internet Explorer\\MenuExt\\' + 
			firefoxViewGetOpenPageText() + '\\", ';
	output += '"file://' + homeDir.path + '\\' + 'firefoxviewpage.html"';
	output += '\n' + 'WSHShell.RegWrite "HKEY_CURRENT_USER\\Software\\Microsoft\\Internet Explorer\\MenuExt\\' + 
			firefoxViewGetOpenPageText() + '\\Contexts",';
	output += ' 1, "REG_DWORD"';

	output += '\n' + 'WSHShell.RegWrite ';
	output += '"HKEY_CURRENT_USER\\Software\\Microsoft\\Internet Explorer\\MenuExt\\' + 
			firefoxViewGetOpenLinkText() + '\\", ';
	output += '"file://' + homeDir.path + '\\' + 'firefoxviewlink.html"';
	output += '\n' + 'WSHShell.RegWrite "HKEY_CURRENT_USER\\Software\\Microsoft\\Internet Explorer\\MenuExt\\' + 
			firefoxViewGetOpenLinkText() + '\\Contexts",';
	output += ' 34, "REG_DWORD"';
	output += '\n';
	output += '\n' + 'set fso = CreateObject("Scripting.FileSystemObject")';
	output += '\n' + 'fso.deletefile(WScript.ScriptFullName)';

	var result = outputStream.write(output, output.length);
	outputStream.close();
	// the script will delete itself after running:
        installFile.launch();	
	firefoxviewSetInstalled(true);
}

function firefoxViewUnInstall() {
	var homeDir = firefoxViewGetHome();
	var uninstallFile = homeDir.clone().QueryInterface(Components.interfaces.nsILocalFile);
	uninstallFile.append("uninstall.vbs");
	var outputStream = Components.classes["@mozilla.org/network/file-output-stream;1"]
					.createInstance( Components.interfaces.nsIFileOutputStream );		
	outputStream.init(uninstallFile, 0x04 | 0x08 | 0x20, 420, 0 );
	var output = '';
	output += 'Dim WshShell';
	output += '\n' + 'Set WshShell = WScript.CreateObject("WScript.Shell")';

	output += '\n' + 'WSHShell.RegDelete ';
	output += '"HKEY_CURRENT_USER\\Software\\Microsoft\\Internet Explorer\\MenuExt\\' + 
			firefoxViewGetOpenPageText() + '\\"';

	output += '\n' + 'WSHShell.RegDelete ';
	output += '"HKEY_CURRENT_USER\\Software\\Microsoft\\Internet Explorer\\MenuExt\\' + 
			firefoxViewGetOpenLinkText() + '\\"';
	output += '\n';
	output += '\n' + 'set fso = CreateObject("Scripting.FileSystemObject")';
	output += '\n' + 'fso.deletefile(WScript.ScriptFullName)';

	var result = outputStream.write(output, output.length);
	outputStream.close();
	// the script will delete itself after running:
        uninstallFile.launch();	
	firefoxviewSetInstalled(false);
}

// return true/false or null if nothing is set (first run)
function firefoxviewIsInstalled() {
   var bInstalled = null;
   try {
     bInstalled = gFirefoxViewPref.getBoolPref("is_installed");
   } 
   catch (err) {
   }

   return bInstalled;
}

function firefoxviewSetInstalled(bInstalled) {
   try {
     gFirefoxViewPref.setBoolPref("is_installed", bInstalled);
   } 
   catch (err) {
     dump("\nSetting preference for is_installed failed: " + err + "\n");
     return;
   }
   try {
	gFirefoxViewPref.savePrefFile(null);
   }
   catch (err) {
        dump("\nSaving preferences failed: " + err + "\n");
   }
}

function firefoxviewInstallUninstallWithConfirmation(bInstall) {
try {
   var strbundle = document.getElementById("firefoxview-strings");
   var promptOK;
   var promptProblem;

   if (bInstall) {
	   promptOK = strbundle.getString("installOKPrompt");
	   promptProblem = strbundle.getString("installProblemPrompt");
   } else {
	   promptOK = strbundle.getString("uninstallOKPrompt");
	   promptProblem = strbundle.getString("uninstallProblemPrompt");
   }

   try {
	if (bInstall) {
		firefoxViewInstall();
	} else {
		firefoxViewUnInstall();
	}
   } catch (err) {
	alert(promptProblem);
	return;
   }
   alert(promptOK);
} catch (e) { alert(e); }
}

var gFirefoxViewPrefService = Components.classes["@mozilla.org/preferences-service;1"]
                            .getService(Components.interfaces.nsIPrefService);
var gFirefoxViewPref = gFirefoxViewPrefService.getBranch("firefoxview."); 
