var EvoBar_req;
var EvoBar_timer;

/* EvoBar Preferences Service */
const EvoBar_prefService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService);
const EvoBar_preferences = EvoBar_prefService.getBranch("extensions.evobar.");

function EvoBar_getPreference(name) {
	switch (name) {
		case 'alert': vtype = 'bool'; vdefault = true; break;
		case 'gameUrl': vtype = 'string'; vdefault = 'http://ev5.neondragon.net/'; break;
		case 'updateService': vtype = 'string'; vdefault = 'http://ev5.neondragon.net/toolbarrpc'; break;
		case 'updateInterval': vtype = 'integer'; vdefault = 20; break;
	}
	
	if(EvoBar_preferences.prefHasUserValue(name)) {
		switch (vtype) {
			case 'string':
				return EvoBar_preferences.getCharPref(name);
				break;
			case 'integer':
				return EvoBar_preferences.getIntPref(name);
				break;
			case 'bool':
				return EvoBar_preferences.getBoolPref(name);
				break;
		}
	} else {
		switch (vtype) {
			case 'string':
				EvoBar_preferences.setCharPref(name, vdefault);
				return vdefault;
				break;
			case 'integer':
				EvoBar_preferences.setIntPref(name, vdefault);
				return vdefault;
				break;
			case 'bool':
				EvoBar_preferences.setBoolPref(name, vdefault);
				return vdefault;
				break;
		}		
	}
}

/* EvoBar Alerter Service */
function EvoBar_Alert(mtitle, message, murl) {
	this.mtitle = mtitle;
	this.message = message;
	this.murl = murl;
}

EvoBar_Alert.prototype.showAlert = function (){
	var alertService = Components.classes["@mozilla.org/alerts-service;1"].getService(Components.interfaces.nsIAlertsService);
    if (alertService) {
		alertService.showAlertNotification("chrome://evobar/skin/evologo.png", this.mtitle, this.message, true, "", this);
	}
}

EvoBar_Alert.prototype.onAlertFinished = function (aCookie){ }
EvoBar_Alert.prototype.onAlertClickCallback = function (aCookie){
	window._content.document.location = this.murl;
	window.content.focus();	
}

function EvoBar_Go(event, wheretogo) {
	switch (wheretogo) {
		case 'ev5': var url = EvoBar_getPreference('gameUrl') + 'overview'; break;
		case 'portal': var url = 'http://evolution.neondragon.net/'; break;
		case 'ndnet': var url = 'http://www.neondragon.net/'; break;
	}
	
	window._content.document.location = url;
	window.content.focus();
}

function EvoBar_Browse(event, wheretogo) {
	window._content.document.location = EvoBar_getPreference('gameUrl') + wheretogo;
	window.content.focus();
}

function EvoBar_Update() {
	/*alerter = new EvoBar_Alert('uberpenguin has been killed', 'Whoops!', 'http://www.callofduty.com');
	alerter.showAlert();
	
	var sound = Components.classes["@mozilla.org/sound;1"].createInstance(Components.interfaces.nsISound);
    sound.playSystemSound("file://C:\Program Files\Messenger\online.wav");*/
	
	try {
		EvoBar_req = new XMLHttpRequest();
		EvoBar_req.onreadystatechange = EvoBar_doUpdate;
		EvoBar_req.open ("GET", EvoBar_getPreference('updateService'));
		EvoBar_req.send (null);
	} catch (e) {
		document.getElementById('EvoBar-Update').className = 'EvoBar-Update-Error';
		document.getElementById('EvoBar-Update').setAttribute('label', 'Update Error');
	} finally {
		/* Schedule next update */
		updateMins = EvoBar_getPreference('updateInterval');
		if (!updateMins) {
			updateMins = 20;
		}
		updateTimeout = updateMins * 60000;
		if (!updateTimeout || updateTimeout < 300000) { /* Stop hammering the server */
			updateTimeout = 300000;
		}
		EvoBar_timer = window.setTimeout (EvoBar_Update, updateTimeout);
	}
	
	return;
}

function EvoBar_doUpdate() {
    if (EvoBar_req.readyState == 4) {
        if (EvoBar_req.status == 200) {
	        response = EvoBar_req.responseXML.documentElement;
	        
	        /* Are we logged in? */
	        memberid = response.getElementsByTagName('id')[0].firstChild.data;
	        if (memberid == 0) {
		        document.getElementById('EvoBar-Login').setAttribute('hidden', false);
		        document.getElementById('EvoBar-Messages-Count').setAttribute('hidden', true);
		        document.getElementById('EvoBar-News-Count').setAttribute('hidden', true);
		        document.getElementById('EvoBar-Ranking').setAttribute('hidden', true);
		        document.getElementById('EvoBar-Ranking').setAttribute('label', 'Ranking: '+rank+' ('+score+')');
		        document.getElementById('EvoBar-Update').setAttribute('label', 'Enable');
	        } else {
		        document.getElementById('EvoBar-Login').setAttribute('hidden', true);
		        document.getElementById('EvoBar-Messages-Count').setAttribute('hidden', false);
		        document.getElementById('EvoBar-News-Count').setAttribute('hidden', false);
		        document.getElementById('EvoBar-Ranking').setAttribute('hidden', false);
		        
		        /* Messages */
		        messages = response.getElementsByTagName('messages')[0].firstChild.data;
		        if (messages > 0) {
			        document.getElementById('EvoBar-Messages-Count').style.fontWeight='bold';
			        document.getElementById('EvoBar-Messages-Count').className = 'EvoBar-Unread';
	            	document.getElementById('EvoBar-Messages-Count').setAttribute('label', 'New Messages ('+messages+')');
	            	document.getElementById('EvoBar-Messages-Count').onclick = function() { document.getElementById('EvoBar-Messages-Count').style.fontWeight='normal'; document.getElementById('EvoBar-Messages-Count').className = 'EvoBar-Read'; document.getElementById('EvoBar-Messages-Count').setAttribute('label', 'No New Messages'); }
	            	
				} else {
					document.getElementById('EvoBar-Messages-Count').style.fontWeight='normal';
					document.getElementById('EvoBar-Messages-Count').className = 'EvoBar-Read';
					document.getElementById('EvoBar-Messages-Count').setAttribute('label', 'No New Messages');
				}
				
				/* News */
	            news = response.getElementsByTagName('news')[0].firstChild.data;
		        if (news > 0) {
			        document.getElementById('EvoBar-News-Count').style.fontWeight='bold';
			        document.getElementById('EvoBar-News-Count').className = 'EvoBar-Unread';
	            	document.getElementById('EvoBar-News-Count').setAttribute('label', 'New News ('+news+')');
	            	document.getElementById('EvoBar-News-Count').onclick = function() { document.getElementById('EvoBar-News-Count').style.fontWeight='normal'; document.getElementById('EvoBar-News-Count').className = 'EvoBar-Read'; document.getElementById('EvoBar-News-Count').setAttribute('label', 'No New News'); }
				} else {
					document.getElementById('EvoBar-News-Count').style.fontWeight='normal';
					document.getElementById('EvoBar-News-Count').className = 'EvoBar-Read';
					document.getElementById('EvoBar-News-Count').setAttribute('label', 'No New News');
				}
				
				/* Rankings */
				rank = response.getElementsByTagName('rank')[0].firstChild.data;
				players = response.getElementsByTagName('players')[0].firstChild.data;
				score = response.getElementsByTagName('score')[0].firstChild.data;
				
				document.getElementById('EvoBar-Ranking').setAttribute('label', 'Ranking: '+rank+'/'+players+' ('+score+')');
				
				/* Update Time */
				d = new Date();
				hrs = d.getHours();
				mins = d.getMinutes();
				if (mins < 10) {
					mins = "0"+mins;
				}
				document.getElementById('EvoBar-Update').className = 'EvoBar-Update-Success';
				document.getElementById('EvoBar-Update').setAttribute('label', 'Updated '+hrs+':'+mins);	
			}
				
		} else {
			document.getElementById('EvoBar-Update').className = 'EvoBar-Update-Error';
			document.getElementById('EvoBar-Update').setAttribute('label', 'Update Error');
        }
    }
}

function EvoBar_getUsername() {
	var cookieManager = Components.classes["@mozilla.org/cookiemanager;1"].getService(Components.interfaces.nsICookieManager);
	var iter = cookieManager.enumerator;
	while (iter.hasMoreElements()){
    	var cookie = iter.getNext();
		if (cookie instanceof Components.interfaces.nsICookie){
			if (cookie.host == ".neondragon.net" && cookie.name == "user_name") {
				return cookie.value;
			}
		}
	}
}

function EvoBar_Signature_insertText(aText) {
	try {
		var command = "cmd_insertText";
		var controller = document.commandDispatcher.getControllerForCommand(command);
		if (controller && controller.isCommandEnabled(command)) {
			controller = controller.QueryInterface(Components.interfaces.nsICommandController);
			var params = Components.classes["@mozilla.org/embedcomp/command-params;1"];
			params = params.createInstance(Components.interfaces.nsICommandParams);
			params.setStringValue("state_data", aText);
			controller.doCommandWithParams(command, params);
		}
	}
	catch (e) {
		dump("Can't do cmd_insertText! ");
		dump(e+"\n")
	}
}

function EvoBar_Signature(mode, markup) {
	if (memberid == 0) {
		alert ("You must be logged in to use this feature.");
		return;
	}
	
	switch (markup) {
		case 'html':
			text = '<a href="http://evolution.neondragon.net"><img src="http://evo-sigs.neondragon.net/'+EvoBar_getUsername()+'" alt="Join the battle at http://evolution.neondragon.net/" border="0" /></a>';
			break;
		case 'bbcode':
			text = '[url=http://evolution.neondragon.net][img]http://evo-sigs.neondragon.net/'+EvoBar_getUsername()+'[/img][/url]';
			break;
	}
	
	switch (mode) {
		case 'clipboard':
			var gClipboardHelper = Components.classes["@mozilla.org/widget/clipboardhelper;1"].getService(Components.interfaces.nsIClipboardHelper);
			gClipboardHelper.copyString(text);
			break;
		case 'insert':
			EvoBar_Signature_insertText(text);
			break;
	}
}

/* Initial Data Load */
EvoBar_Update();