/******************************************************************************
* Version: MPL 1.1
*
* The contents of this file are subject to the Mozilla Public License Version
* 1.1 (the "License"); you may not use this file except in compliance with
* the License. You may obtain a copy of the License at
* http://www.mozilla.org/MPL/
*
* Software distributed under the License is distributed on an "AS IS" basis,
* WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
* for the specific language governing rights and limitations under the
* License.
*
* The Original Code is EditCSS.
* Portions of the Original Code are  taken from
* - quicknote.mozdev.org
* - tagzilla.mozdev.org
* -'Edit Styles' bookmarklet from Jesse Ruderman http://www.squarefree.com/bookmarklets/webdevel.html#edit_styles
*
* Code uses jslib (jslib.mozdev.org)
*
*
* The Initial Developer of the Original Code is Pascal Guimier.
* Portions created by the Initial Developer are Copyright (C) 2003
* the Initial Developer. All Rights Reserved.
*
* Contributor(s): Gerard, Jonathan Gough

******************************************************************************/

var countLoads = 0;
var dataHistory = new Array();
var mediaList = new Array();
var dataOrig;
function init() {

  var newline = unescape("%0A"), importCount = 0, L = [];
  dead = false;
  oldCSS = null;
  x = window._content;
  ta = window.document.getElementById('ecText');
  ta.select();
   
  if (x.editStyles) {
    ta.value = x.editStyles.innerHTML; 
    update(); 
    return; 
    }
    
    ta.value = "/* Edited with EditCSS */" + newline; 
    /* Add a stylesheet to the panel */
    function add(s){
      /* test the media type */
      var isscreen=s.media.length==0?true:false;
      for(var j=0;j<s.media.length;j++)
        if(s.media.item(j)=="screen")
	  isscreen=true;
      var mediaName=s.media.item(j);
      if(!s.disabled&&isscreen){
        var y = {sheet:s, readable:true, label:"Imported", inline:false, shorturl:"", fulltext:""};
        try { for (var k = 0, m; m = s.cssRules[k]; ++k) { if (m.type == 3) { add(m.styleSheet); } } }
        catch (er) { y.readable = false; }
        L.push(y);

        if (s.ownerNode) {
          y.label = s.ownerNode.tagName.toUpperCase() + "-tag";

          if (!s.ownerNode.getAttribute("src") && !s.ownerNode.href) {y.inline = true; }
        }

        if (y.inline) {
          y.label = "Inline " + y.label; y.fulltext = fix(s.ownerNode.innerHTML);
        }
        else {

          if (s.href.substr(0, 13) == "data:text/css") {
            y.shorturl = " contained in a data: URL"; y.fulltext = fix(unescape(s.href.slice(14)));
          }
          else {
            ++importCount;
            y.importtext = "@import \"" + s.href + "\";";
            y.shorturl = " " + s.href.split("/").reverse()[0];

            if (!y.readable) {
              y.fulltext = "/* Out-of-domain; imported above. */";
            }
            else {
              
              if (s.href.substr(0, 4) != "http") {
                y.fulltext = "/* Non-http; imported above. */";
              }
              else {
                
                var loadingText = "/* Loading (" + (L.length - 1) + ") */";
                y.fulltext = loadingText;
                var p = new XMLHttpRequest();
                p.onload = ( function (e) {
                    ta.value = ta.value.replace(y.importtext + newline, "");
                    y.fulltext = p.responseText;
                    ta.value = ta.value.replace(loadingText, fix(y.fulltext));
                    ta.value = ta.value.replace(firstNote + newline, "");
                    }
                );
                p.open("GET", s.href); 
                p.send(null); 
              }
            }
          }
        }
      } 
    }
    
    function fix(s) {
      
      while ((s[0] == newline) && s.length > 1) {
        s = s.slice(1);
      }
      
      while ((s[s.length - 1] == newline) && s.length > 1) {
        s = s.substr(0, s.length - 1);
      }

      s = s.replace(/@import.*;/gi, (function () { return "/* " + RegExp.lastMatch + " */"; }));
      return s;
    }

    for (var i = 0, ss; ss = x.document.styleSheets[i]; ++i) { add(ss); }

    var imports = "", main = "";
    var firstNote = "/**** Style sheets whose contents could be loaded were ****/" + newline +
                    "/**** imported instead. Rule order may be incorrect ****/" + newline +
                    "/**** as a result. ****/" + newline;

    if (importCount) {
        ta.value += firstNote;
    }

    for (var i = 0; ss = L[i]; ++i) {
      
      if (ss.importtext) {
        imports += ss.importtext + newline;
      }
      
      main += "/**** " + ss.label + " style sheet" + ss.shorturl + " ****/" + newline;
      main += newline;
      main += ss.fulltext;
      main += newline;
      main += newline;
      main += newline;
    }
    
    ta.value += imports + newline + main;
    /*dataHistory[countLoads] = ta.value;*/
    dataOrig = getTextareaText('ecText');
    countLoads++;
    update();
}
function done(){
	notSavedDlg();
}

function update() {
  /* first, test current selected tab corresponds withe the original loaded page */
  try {
    if (!x || x.closed) {
      ta.style.backgroundColor = "#ddd";
      return;
    }
    
    x.editStyles;
  }
  catch (er) {
    ta.style.backgroundColor = "#fdc";
    setTimeout(update, 150);
    dead = true;
    return;
  }

  if (dead) {
    dead = false;
    ta.style.backgroundColor = "";
    oldCSS = null;
  }
  /*  */ 
  if (!x.editStyles) {
    var newSS;
    newSS = x.document.createElement("style");
    newSS.type = "text/css";
    x.document.getElementsByTagName("head")[0].appendChild(newSS);
    x.editStyles = newSS;
    oldCSS = null;
    
    for (var i = 0, ss; ss = x.document.styleSheets[i]; ++i) {
      ss.disabled = true;
    }

  }

  if (oldCSS != ta.value) {
    oldCSS = ta.value;
    x.editStyles.innerHTML = ta.value;
  }

  setTimeout(update, 150); 

}
function resetContent(idx, tNodeID) {
  /*var fContents = dataHistory[idx];*/
  /*setTextareaText(fContents,tNodeID);*/
  setTextareaText(dataOrig,tNodeID);
}

function closeWindow() {
  window.close();
}
function getTextareaText(tNodeID) {
  var tat = document.getElementById(tNodeID).value
  return tat
}
function setTextareaText(thetext,tNodeID) {
  document.getElementById(tNodeID).value= thetext
}

/* Easyer FilePicker */
function txtFilePicker(aTitle, aSave) {
  var retVal = null;
  try {
    const nsIFilePicker = Components.interfaces.nsIFilePicker;
    var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
    fp.init(window, aTitle, (aSave ? nsIFilePicker.modeSave : nsIFilePicker.modeOpen));
    fp.appendFilter("Stylesheet","*.css");
    fp.appendFilters(nsIFilePicker.filterAll | nsIFilePicker.filterText);
    var result=fp.show();
    if (result == nsIFilePicker.returnOK || result == nsIFilePicker.returnReplace) {
      retVal=fp.file;
    }
  }
  catch (ex) {
  }
  return retVal;
}

/* Saves the CSS file */
function saveTextAs(tNodeID) {
  const outputStream = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);
  var data = getTextareaText(tNodeID);
  var theFile = txtFilePicker("Save the File as",1);
  if(!theFile.exists()){
	theFile.create(Components.interfaces.nsIFile.NORMAL_FILE_TYPE, 444);
  } 
  outputStream.init(theFile, 0x04, 0444, null);
  outputStream.write(data, data.length);
  outputStream.close();
}
/* Loads a CSS file */
function loadFile(tNodeID) {
  const inputStream = Components.classes["@mozilla.org/network/file-input-stream;1"].createInstance(Components.interfaces.nsIFileInputStream);
  const scriptableStream = Components.classes["@mozilla.org/scriptableinputstream;1"].createInstance(Components.interfaces.nsIScriptableInputStream);
  var theFile=txtFilePicker("Open a CSS File",0);
  inputStream.init(theFile, 0x01, 0444, null);
  scriptableStream.init(inputStream);
  var fContents = scriptableStream.read(scriptableStream.available());
  scriptableStream.close();
  inputStream.close();
  /*var dataHistory[countLoads] = fContents;
  countLoads++;*/
  setTextareaText(fContents,tNodeID);
}