/******************************************************************************
* Version: MPL 1.1
*
* The contents of this file are subject to the Mozilla Public License Version
* 1.1 (the "License"); you may not use this file except in compliance with
* the License. You may obtain a copy of the License at
* http://www.mozilla.org/MPL/
*
* Software distributed under the License is distributed on an "AS IS" basis,
* WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
* for the specific language governing rights and limitations under the
* License.
*
* The Original Code is EditCSS.
* Portions of the Original Code are  taken from
* - quicknote.mozdev.org
* -tagzilla.mozdev.org
* -'Edit Styles' bookmarklet from Jesse Ruderman http://www.squarefree.com/bookmarklets/webdevel.html#edit_styles
*
* Code uses jslib (jslib.mozdev.org)
*
*
* The Initial Developer of the Original Code is Pascal Guimier.
* Portions created by the Initial Developer are Copyright (C) 2003
* the Initial Developer. All Rights Reserved.
*
* Contributor(s): Gerard, Jonathan Gough
*
******************************************************************************
editcss.js template for JAR based XPI-Package distributions.

$Id: editcss.js,v 1.4 2004/10/18 09:31:37 talou Exp $

******************************************************************************/

function init() {

  var newline = unescape("%0A"), importCount = 0, L = [];
  dead = false;
  oldCSS = null;
  x = window._content;
  ta = window.document.getElementById('ecText');
  ta.select();
   
  if (x.editStyles) {
    ta.value = x.editStyles.innerHTML; 
    update(); 
    return; 
    }
    
    ta.value = "/* Type CSS rules here and they will be applied" + newline +
               "to pages from '" + location.host + "'" + newline +
               "immediately as long as you keep this window open. */" + newline +
               newline; 
    function add(s){
      var isscreen=s.media.length==0?true:false;
      for(var j=0;j<s.media.length;j++)
        if(s.media.item(j)=="screen")
	  isscreen=true;
      if(!s.disabled&&isscreen){
        var y = {sheet:s, readable:true, label:"Imported", inline:false, shorturl:"", fulltext:""};
        try { for (var k = 0, m; m = s.cssRules[k]; ++k) { if (m.type == 3) { add(m.styleSheet); } } }
        catch (er) { y.readable = false; }
        L.push(y);

        if (s.ownerNode) {
          y.label = s.ownerNode.tagName.toUpperCase() + "-tag";

          if (!s.ownerNode.getAttribute("src") && !s.ownerNode.href) {y.inline = true; }
        }

        if (y.inline) {
          y.label = "Inline " + y.label; y.fulltext = fix(s.ownerNode.innerHTML);
        }
        else {

          if (s.href.substr(0, 13) == "data:text/css") {
            y.shorturl = " contained in a data: URL"; y.fulltext = fix(unescape(s.href.slice(14)));
          }
          else {
            ++importCount;
            y.importtext = "@import \"" + s.href + "\";";
            y.shorturl = " " + s.href.split("/").reverse()[0];

            if (!y.readable) {
              y.fulltext = "/* Out-of-domain; imported above. */";
            }
            else {
              
              if (s.href.substr(0, 5) != "http:") {
                y.fulltext = "/* Non-http; imported above. */";
              }
              else {
                
                var loadingText = "/* Loading (" + (L.length - 1) + ") */";
                y.fulltext = loadingText;
                var p = new XMLHttpRequest();
                p.onload = ( function (e) {
                    ta.value = ta.value.replace(y.importtext + newline, "");
                    y.fulltext = p.responseText;
                    ta.value = ta.value.replace(loadingText, fix(y.fulltext));
                    ta.value = ta.value.replace(firstNote + newline, "");
                    }
                );
                p.open("GET", s.href); 
                p.send(null); 
              }
            }
          }
        }
      } 
    }
    
    function fix(s) {
      
      while ((s[0] == newline) && s.length > 1) {
        s = s.slice(1);
      }
      
      while ((s[s.length - 1] == newline) && s.length > 1) {
        s = s.substr(0, s.length - 1);
      }

      s = s.replace(/@import.*;/gi, (function () { return "/* " + RegExp.lastMatch + " */"; }));
      return s;
    }

    for (var i = 0, ss; ss = x.document.styleSheets[i]; ++i) { add(ss); }

    var imports = "", main = "";
    var firstNote = "/**** Style sheets whose contents could be loaded were ****/" + newline +
                    "/**** imported instead. Rule order may be incorrect ****/" + newline +
                    "/**** as a result. ****/" + newline;

    if (importCount) {
        ta.value += firstNote;
    }

    for (var i = 0; ss = L[i]; ++i) {
      
      if (ss.importtext) {
        imports += ss.importtext + newline;
      }
      
      main += "/**** " + ss.label + " style sheet" + ss.shorturl + " ****/" + newline;
      main += newline;
      main += ss.fulltext;
      main += newline;
      main += newline;
      main += newline;
    }
    
    ta.value += imports + newline + main;
    update();
}
function done(){
	notSavedDlg();
}


function update() {

  try {
    if (!x || x.closed) {
      ta.style.backgroundColor = "#ddd";
      return;
    }
    
    x.editStyles;
  }

  catch (er) {
    ta.style.backgroundColor = "#fdc";
    setTimeout(update, 150);
    dead = true;
    return;
  }

  if (dead) {
    dead = false;
    ta.style.backgroundColor = "";
    oldCSS = null;
  }

  if (!x.editStyles) {
    var newSS;
    newSS = x.document.createElement("style");
    newSS.type = "text/css";
    x.document.getElementsByTagName("head")[0].appendChild(newSS);
    x.editStyles = newSS;
    oldCSS = null;
    
    for (var i = 0, ss; ss = x.document.styleSheets[i]; ++i) {
      ss.disabled = true;
    }

  }

  if (oldCSS != ta.value) {
    oldCSS = ta.value;
    x.editStyles.innerHTML = ta.value;
  }

  setTimeout(update, 150); 

}



function closeWindow() {
  window.close();
}



function getTextareaText(tNodeID) {
  var tat = document.getElementById(tNodeID).value
  return tat
}



function setTextareaText(thetext,tNodeID) {
  document.getElementById(tNodeID).value= thetext
}


//**** SaveAS and FilePicker ******

////////////////////////////////////////////////////////////////////////////////
// txtFilePicker
//
// Parameters:
//  aTitle: title to go on file picker window
//  aSave: 1 if picking file to save/overwrite, 0 if picking file to load
//  aStart: directory to start from
//    This must be an nsILocalFile.  new Dir("foo") in jslib/io/dir.js will
//    do the trick, but you have to do it yourself.
// Returns:
//  Name of file picked, in URL format, or null if cancelled
// Original taken and modified from quicknote.mozdev.org!
////////////////////////////////////////////////////////////////////////////////
function txtFilePicker(aTitle, aSave) {
  var retVal = null;
  try {
   
    const nsIFilePicker = Components.interfaces.nsIFilePicker;
    var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
    fp.init(window, aTitle, (aSave ? nsIFilePicker.modeSave : nsIFilePicker.modeOpen));
    fp.appendFilter("Stylesheet","*.css");
    fp.appendFilters(nsIFilePicker.filterAll | nsIFilePicker.filterText);
    
    /*
    if(aStart) {
      fp.displayDirectory = aStart;
    }
    */
    var result=fp.show();
    if (result == nsIFilePicker.returnOK || result == nsIFilePicker.returnReplace) {
      //retVal=fp.fileURL.spec;
      retVal=fp.file.path;
      //alert("Should return retval: "+retVal+" YES!"); // DEBUG
    }
  }
  catch (ex) {
  }
  return retVal;
}

////////////////////////////////////////////////////////////////////////////////
// saveTextAs
//
// Parameters: targetNodeID: What to save
// button: Which button was pressed
// Returns: true if list saved, false otherwise
// Original taken and modified from quicknote.mozdev.org!
////////////////////////////////////////////////////////////////////////////////
function saveTextAs(targetNodeID, button) {
  var d = new DirUtils;
  var myUserDirPlease = d.getMozHomeDir();
  var targetNodeID2 = targetNodeID;
  var fName = txtFilePicker("Save the File as",1,myUserDirPlease);
  if(fName==null){
    return false;
  }
  
  var isSaved = saveAFile(fName, targetNodeID2, button);
  //if(isSaved){
    //document.getElementById(button).setAttribute("disabled", "true");
  //}
  return isSaved;
}

////////////////////////////////////////////////////////////////////////////////
// saveAFile
//
// Parameters:
//  aUrl: string name of file to open, in platform-specific or file:// format
//  targetNodeID: where the data is to save!
//  button: The button that makes the call (for disable/enable)
// Returns: true if list saved, false otherwise
////////////////////////////////////////////////////////////////////////////////
function saveAFile(aUrl, targetNodeID, button) {

  var aFile=aUrl;
  if(aUrl.substring(0,4)=="file") {
    var fUtils = new FileUtils();
    aFile = fUtils.urlToPath(aUrl);
  }

  var f = new File(aFile);
  if(!f.open("w")) {
    alert("File could not be opened!");
    return false;
  }
  var data = getTextareaText(targetNodeID);
  f.write(data);
  f.close();

  //document.getElementById(button).setAttribute("disabled", "true");
  return true;
}

////////////////////////////////////////////////////////////////////////////////
// notSavedDlg
//
// Parameters: none
// Returns:
//  0 if user wishes to save the modified list
//  1 if user presses cancel
//  2 if user does not wish to save (or if list isn't modified)
////////////////////////////////////////////////////////////////////////////////
function notSavedDlg() {
  if(ecText.getAttribute("changed")=="true") {
    var promptService = Components.classes[ "@mozilla.org/embedcomp/prompt-service;1" ].
                        getService(Components.interfaces.nsIPromptService);
    var promptFlags = promptService.BUTTON_TITLE_CANCEL * promptService.BUTTON_POS_1;
    promptFlags += promptService.BUTTON_TITLE_SAVE * promptService.BUTTON_POS_0;
    promptFlags += promptService.BUTTON_TITLE_DONT_SAVE * promptService.BUTTON_POS_2;

    var retVal = promptService.confirmEx( window,getText("notSavedHdr"),
       getText("notSavedMsg"), promptFlags,
       "button1", "button2", "button3", null, {value:0});
    return retVal;
  }
  else
    return 2;
}

////////////////////////////////////////////////////////////////////////////////
// loadList
//
// Parameters: none
// Returns: false if list not loaded, true otherwise
////////////////////////////////////////////////////////////////////////////////
function loadFile(tNodeID) {
  var d = new DirUtils;
//  var notSaved = notSavedDlg();
//  if(notSaved==1) return false;                 // cancel
//  if(notSaved==0 && !saveList()) return false;  // save

  var oldDir = d.getMozHomeDir();
  var newDir = null;
  oldDir = oldDir.substring(0,oldDir.lastIndexOf("/")+1);
  if(oldDir) {
    newDir = new Dir(oldDir);
  }

  var fName=txtFilePicker("Open a CSS File",0,newDir);
  if(fName==null)
    return false;

  loadFileInText(fName, tNodeID);
  //setTimeout(tzOnSel,10);
  return true;
}

////////////////////////////////////////////////////////////////////////////////
// loadFileInText
//  loads the given file and displays it in the listbox
//
// Parameters:
//  aUrl: string name of file to open in file:// format
//
// Returns:
//  -1 if file doesn't exist
////////////////////////////////////////////////////////////////////////////////
function loadFileInText(aUrl, tNodeID) {

  var aFile=aUrl;
  if(aUrl.substring(0,4)=="file") {
    var fUtils = new FileUtils();
    aFile = fUtils.urlToPath(aUrl);
  }
  var f = new File(aFile);

  if(!f.exists()) {
    alert(getText("notFoundMsg"));
    return -1;
  }

  f.open("r");
  var fContents = f.read();
  f.close();

  // Determine the newline flavour. unix is \n, mac is \r, dos is \r\n
  // (If we can't figure it out, stick with the old value)
  tzNL = fContents.match(/\r?\n|\r\n?/) || tzNL;

  // use \n internally
  var nlRE = new RegExp(tzNL, "g");
  fContents = fContents.replace(nlRE, "\n");
  
  setTextareaText(fContents,tNodeID);

  //tNodeID.setAttribute("changed","false");

  return 0;
}

