/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Outliner Extension code.
 *
 * The Initial Developer of the Original Code is
 * James Graham
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):James Graham <jg307@cam.ac.uk>
 *               
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

DocumentMap.modules.xhtml = new Object();


DocumentMap.modules.xhtml.supportsDocument = function(document) {
  return (document instanceof HTMLDocument)&&(document.contentType == "application/xhtml+xml" || document.contentType == "text/xml");
}


DocumentMap.modules.xhtml.NSResolver = function(prefix) {
  if (prefix == 'html') {
    return 'http://www.w3.org/1999/xhtml';
  }
  else {
    return null;
  }
}

DocumentMap.modules.xhtml.headingList  = function(xulTree) {
  /* This is the container object which holds a list of all the headings in the current document 
     Each heading is represented by a headingItem object stored as an array in the headings property
     This object also contains methods for constructing an XUL tree for the headings

     The object constructor takes a single argument; 
     a DOM element at the root of an XUL tree in which the tree nodes should be added

     To obtain a fresh list of headings in the document, use the fill method.
     To clean the current list and remove the tree, use the clear method
     The update method simply clears and refills the tree
  */

  DocumentMap.utils.inheritFrom(this, new DocumentMap.prototypes.headingList());

  this.headingTagNames = ['h1', 'h2', 'h3', 'h4', 'h5', 'h6','section'];

  this.getHeadingItems = function(rootNode) {
    /* Return an array of heading nodes that are the children of a document nod*/

    var xpathExpression = ".//html:h1 | .//html:h2 | .//html:h3 | .//html:h4 | .//html:h5 | .//html:h6";
    var nodes = this.document.evaluate(xpathExpression, rootNode,DocumentMap.modules.xhtml.NSResolver,XPathResult.ORDERED_NODE_SNAPSHOT_TYPE,null);
    var list = new Array();
    for(var i=0; i<nodes.snapshotLength; i++) {
      list.push(new DocumentMap.headingItem(nodes.snapshotItem(i), this));
    }
    
    return list;

  };

  this.getNextHeading = function(headingNode) {
    /*Find the heading following another
      Principally useful in knowing where a heading has been inserted into a document*/

    //Slightly horrific expressions to find the heading node /after/ the one that has been inserted into the document
    var xpathExpression = "(following::html:h1 | following::html:h2 | following::html:h3 | following::html:h4 | following::html:h5 | following::html:h6)";
    
    var nodes = this.document.evaluate(xpathExpression,headingNode,DocumentMap.modules.xhtml.NSResolver,XPathResult.FIRST_ORDERED_NODE_TYPE,null);
    return nodes.singleNodeValue;
  };

  this.tagAffectsOutline = function(tagname) {

    for (var i=0; i<tags.length; i++) {
      if(tagname == tags[i]) {
	return true;
      }
    }
    return false;
  };

}

DocumentMap.modules.xhtml.headingItem = function(node, list) {
  /*Object representing an individual html heading item*/
  DocumentMap.utils.inheritFrom(this, new DocumentMap.prototypes.headingItem(node,list));

  this.getLevel = function() {
    /* HTML 4 behavior : the tag name is used to determine the level */
    
    if(this.list.dirty || !this.level) {
      switch(node.tagName.toLowerCase()) {
      case 'h1':
	level=1;
	break;
      case 'h2':
	level=2;
	break;
      case 'h3':
	level=3;
	break;
      case 'h4':
	level=4;
	break;
      case 'h5':
	level=5;
	break;
      case 'h6':
	level=6;
	break;
      }
    }
    else {
      level = this.level;
    }
    return level;
  };
  
  //Create a set of nodes to insert into the outline tree for the current element
  //The treeNodes variable always points at the treeitem node and will point to the node in the tree after it's updated
  this.treeNodes =  this.createTreeNodes();
}

DocumentMap.registerModule(DocumentMap.modules.xhtml);
