/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Outliner Extension code.
 *
 * The Initial Developer of the Original Code is
 * James Graham
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):James Graham <jg307@cam.ac.uk>
 *               
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

DocumentMap.modules.html = new Object();


DocumentMap.modules.html.supportsDocument = function(document) {
  return (document instanceof HTMLDocument)&&(document.contentType == "text/html");
}

DocumentMap.modules.html.headingList  = function(xulTree) {
  /* This is the container object which holds a list of all the headings in the current document 
     Each heading is represented by a headingItem object stored as an array in the headings property
     This object also contains methods for constructing an XUL tree for the headings

     The object constructor takes a single argument; 
     a DOM element at the root of an XUL tree in which the tree nodes should be added

     To obtain a fresh list of headings in the document, use the fill method.
     To clean the current list and remove the tree, use the clear method
     The update method simply clears and refills the tree
  */

  DocumentMap.utils.inheritFrom(this, new DocumentMap.prototypes.headingList());

  this.headingTagNames = ['H1', 'H2', 'H3', 'H4', 'H5', 'H6','SECTION'];

  this.getHeadingItems = function(rootNode) {
    /*Construct a XUL:tree from the headings in the document
      This method constructs an initial tree using all the avaliable headings*/

    var xpathExpression = "descendant-or-self::h1 | descendant-or-self::h2 | descendant-or-self::h3 | descendant-or-self::h4 | descendant-or-self::h5 | descendant-or-self::h6";

    var nodes = this.document.evaluate(xpathExpression,rootNode,null,XPathResult.ORDERED_NODE_SNAPSHOT_TYPE,null);
    var list = new Array();
    for(var i=0; i<nodes.snapshotLength; i++) {
      list.push(new DocumentMap.headingItem(nodes.snapshotItem(i), this));

    }    
    return list;

  };

  this.getNextHeading = function(headingNode) {
    /*Find the heading following another
      Principally useful in knowing where a heading has been inserted into a document*/

    //Slightly horrific expressions to find the heading node /after/ the one that has been inserted into the document
    var xpathExpression = "(following::h1 | following::h2 | following::h3 | following::h4 | following::h5 | following::h6)";
    
    var nodes = this.document.evaluate(xpathExpression,headingNode,null,XPathResult.FIRST_ORDERED_NODE_TYPE,null);
    return nodes.singleNodeValue;
  };
}

DocumentMap.modules.html.headingItem = function(node, list) {
  /*Object representing an individual html heading item*/
  DocumentMap.utils.inheritFrom(this, new DocumentMap.prototypes.headingItem(node,list));

  this.getLevel = function() {
    /*For Web-Apps 1 (i.e. HTML 5) compatibility, we implement  the following behavior:
      -- If the heading is a descendant of a <section> element, the number of section 
      elements in the ancestor axis determines the heading level
      -- Otherwise HTML 4 behavior is used and the tag name is used to determine the level */

    var level;
    if(this.list.dirty || !this.level) {
      switch(node.tagName.toLowerCase()) {
      case 'h1':
	level=1;
	break;
      case 'h2':
	level=2;
	break;
      case 'h3':
	level=3;
	break;
      case 'h4':
	level=4;
	break;
      case 'h5':
	level=5;
	break;
      case 'h6':
	level=6;
	break;
      }
    }
    else {
      level = this.level;
    }

    return level;
  };
  
  //Create a set of nodes to insert into the outline tree for the current element
  //The treeNodes variable always points at the treeitem node and will point to the node in the tree after it's updated
  this.treeNodes =  this.createTreeNodes();
}

DocumentMap.registerModule(DocumentMap.modules.html);
