/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Outliner Extension code.
 *
 * The Initial Developer of the Original Code is
 * James Graham
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):James Graham <jg307@cam.ac.uk>
 *               
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

DocumentMap = new Object();

DocumentMap.consts = {TREE:0, NO_HEADINGS:1,NO_MODULE:2}

DocumentMap.list = null;
DocumentMap.module = null;

DocumentMap.modules = new Array();
DocumentMap.prototypes = new Object();
DocumentMap.listeners = new Object();
DocumentMap.utils = new Object();

DocumentMap.prototypes.headingList = function() {
  /* This is the container object which holds a list of all the headings in the current document 
     Each heading is represented by a headingItem object stored as an array in the headings property
     This object also contains methods for constructing an XUL tree for the headings

     To obtain a fresh list of headings in the document, use the fill method.
     To clean the current list and remove the tree, use the clear method
     The update method simply clears and refills the tree
  */

  //List of all headings, in document order
  this.headings = new Array(); 
  this.lastEvent = false;

  if(DocumentMap.utils.prefs.getPrefType("extensions.DocumentMap.depth") == DocumentMap.utils.prefs.PREF_INT) {
     this.openToDepth = DocumentMap.utils.prefs.getIntPref('extensions.DocumentMap.depth'); 
  }
  else {
    this.openToDepth =0;
  }

  //Has the document been modified since the headingNodes were updated?
  this.dirty = false;

  //XXX - change this to return a list of heading items

  this.getHeadingItems = function(rootNode) {
    /*Get a list of all nodes to appear in the outline */
    return [];
  }

  this.fill = function() {
    /*XXX Useful comment here */
    if(this.document && this.document != window.content.document) {
      this.clean();
    }
    this.document = window.content.document;
    this.document.addEventListener('DOMNodeInserted', this.nodeInsertListener, false);
    this.document.addEventListener('DOMNodeRemoved', this.nodeRemoveListener, false);
    this.document.addEventListener('DOMSubtreeModified', this.nodeModifiedListener, false);
    this.document.addEventListener('DOMCharacterDataModifed', this.charListener, false);

    this.createTagList();

    this.headings = this.getHeadingItems(this.document);

    for(var i=0; i<this.headings.length;i++) {
      this.appendToTree(this.headings[i], i);
    }    
  };

  this.addHeading =  function(newHeadings) {
    /* Add a new set of heading to the outline after it is added  to the document
     To do this, we will need to rebuild quite a lot of the tree
    as we cannot in general be sure that the new heading hasn't changed the structure
    However the current approach, rebuild everything after the inserted heading, is very
    conservative and can be improved*/

    var nextHeading = this.getNextHeading(newHeadings[newHeadings.length - 1].node);

    if(nextHeading) {
      //Remove all the headings below the last added heading from the tree
      var i = this.headings.length-1;
      var currentItem = this.headings[i];
      while (currentItem.node != nextHeading) {
	currentItem.removeFromTree();
	i--;
	var currentItem = this.headings[i];
      }
      this.headings[i].removeFromTree();

      for (var k=0; k < newHeadings.length; k++) {
	this.headings.splice(i+k, 0, newHeadings[k]);
      }

      //Re-add the removed headings. This is needed to recalc the levels
      //Nice languages might not need this but in HTML it's possible to add a few headings
      //and totally change the tree
      for(var j = i; j<this.headings.length; j++) {
	this.appendToTree(this.headings[j], j);
      }
    } 
    else {
      for (var i=0; i<newHeadings.length; i++) {
	//Add to the end of the tree
	this.headings.push(newHeadings[i]);
	this.appendToTree(newHeadings[i]);
      }
    }
  };

  this.removeHeading = function(headingItems) {
    /*Take a heading out of the tree following DOM modifcation 
      Recalculate the tree for all following headings
    */
    //XXX - this needs serious optimisation
    //Optimise where heading doesn't have subheadings
    for (var i=headingItems.length -1; i>=0; i--) {
      headingItem = headingItems[i];
      var currentItem = this.headings.pop();
      var subsequentHeadings = new Array();
      while(currentItem.node != headingItem.node) {
	subsequentHeadings.push(currentItem);
	currentItem.removeFromTree();
	currentItem = this.headings.pop();
      }
      currentItem.removeFromTree();
      while (currentItem = subsequentHeadings.pop()) {
	this.headings.push(currentItem);
	this.appendToTree(currentItem);
      }
    }
  };

  this.clean = function() {
    var topHeadings= document.getElementById('DocumentMap_tree_top_children');
    while(topHeadings.childNodes.length > 0 ) {
      topHeadings.removeChild(topHeadings.childNodes[0]);
    }
    //Clean the heading list
    while (this.headings.pop()) {
    }

    /*Finally, unload the event listeners*/
    try {
      this.document.removeEventListener("DOMNodeInserted", this.insertNodeListener, false);
    } catch(error) {
      //If we have no event listener we get an error which can be ignored
    }
    try {
      this.document.removeEventListener("DOMNodeRemoved", this.removeNodeListener, false);
    } catch(error) {
    }
    try {
      this.document.removeEventListener("DOMCharacterDataModified", this.charListener, false);
    } catch(error) {
    }
    try {
      this.document.removeEventListener("DOMSubtreeModified", this.charListener, false);
    } catch(error) {
    }
  };

  this.appendToTree = function(heading, index) {
    /*Do all the stuff needed to add the heading  in the right place in the XUL tree
      The algorithm is:
      For a heading, work backwards through the list of headings until we find a heading 
      with heading.level lower than the current heading. Append the current heading as a 
      child to that heading. If no such heading is found place the heading at the top level 
      of the tree
      Index is the index in the headings array of the item to add
    */

    if(!index) {
      index = this.headings.length - 1;
    }
    var headinglevel=heading.getLevel();
    var parentFound =false;
    var i = index;
    while(i>= 0) {
      if(this.headings[i].getLevel() < headinglevel) {
	heading.treeDepth = this.headings[i].treeDepth + 1;
	this.headings[i].appendSubheading(heading);
	parentFound=true;
	break;
      }
      i = i-1;
    }
    if(parentFound == false) {
      //We are appending to the top level of the tree 
      var topChildren= document.getElementById('DocumentMap_tree_top_children');
      heading.treeNodes = topChildren.appendChild(heading.treeNodes);
      heading.treeDepth = 1;
    }
  };

  this.focusHeading = function(){
    /*This is defined here in case other doctypes want to override the default focus behavior*/
    var selectedIndex = DocumentMap.tree.view.selection.currentIndex;
    for(var i=0; i<=this.headings.length-1; i++){
      var heading = this.headings[i];
      if(DocumentMap.tree.view.getIndexOfItem(heading.treeNodes) == selectedIndex) {
	top.getBrowser().markupDocumentViewer.scrollToNode(heading.node);
	break;
      }
    }
  };
  
  this.getHeadingItemFromNode = function(node) {
    var headingFound = false;
    for(var i=this.headings.length-1; i>=0; i--) {
      if(this.headings[i].node == node) {
	headingFound = true;
	break;
      }
    }
    if (headingFound) {
      return this.headings[i];
    }
    else {
      return null;
    }
  };

  this.createTagList = function() {
    /*Convert the array of heading tags into a more useful form*/
    this.headingTags = new Array();
    for (var i = 0; i<this.headingTagNames.length; i++) {
      this.headingTags[this.headingTagNames[i]] = true;
    };
  }

  this.tagAffectsOutline = function(tagName) {
    return this.headingTags[tagName];
  };

  this.nodeModifiedListener = function(event) {
    DocumentMap.utils.dump("Modified " + event.target.tagName);
    var thisList = DocumentMap.list;
     if(thisList.lastEvent != event) {
       thisList.dirty = true;
       var oldHeadingItems = thisList.getHeadingItems(event.relatedNode);
       var newHeadingItems = thisList.getHeadingItems(event.target);
       if(oldHeadingItems.length) {
	 thisList.removeHeading(oldHeadingItems);
       }
       if (newHeadingItems.length) {
	 thisList.addHeading(newHeadingItems);
	 DocumentMap.setPanel(DocumentMap.consts.TREE);
       }
       thisList.dirty = false;
     }
     thisList.lastEvent = event;
    return 0;
  };

  this.nodeInsertListener = function(event) {
    //The 'this' keyword won't work from an event handler. This is a pain.
    //XXX - If we start to support multiple list items  per window (A Good Thing), we'll need a proper solution here
    var thisList = DocumentMap.list;
    if(thisList.lastEvent != event) {
      var newHeadingItems = thisList.getHeadingItems(event.target);
      thisList.dirty = true;
      if(newHeadingItems.length) {
	DocumentMap.setPanel(DocumentMap.consts.TREE);
	thisList.addHeading(newHeadingItems);
      }
      thisList.dirty = false;
    }
    thisList.lastEvent = event;
    return 0;
};

  this.nodeRemoveListener = function(event) {
    var thisList = DocumentMap.list;
    if(thisList.lastEvent != event) {
      thisList.dirty = true;
      var removedHeadingItems = thisList.getHeadingItems(event.target);
      if(removedHeadingItems.length) {
	thisList.removeHeading(removedHeadingItems);
	if(!thisList.headings.length) {
	  DocumentMap.setPanel(DocumentMap.consts.NO_HEADINGS);
	}
      }
      thisList.dirty = false;
    }
    thisList.lastEvent = event;
    return 0;
  };

  this.charListener = function(event) {
  //Check for character changes and then set a timeout for the changes
    var thisList = DocumentMap.list;
    if(thisList.tagAffectsOutline(event.target.tagName)) {
      var headingItem = thisList.getHeadingItemFromNode(event.target);
      headingItem.treeNodes.childNodes[0].setAttribute("label", headingItem.getText())
    }
  return 0;
  };

}

 DocumentMap.prototypes.headingItem = function(node, list) {
  /*Object representing an individual  heading item*/

  //The node is the heading element in the source document
  this.node = node;
  //Are there subheadngs  
  this.hasSubHeadings = false;
  //The headingList object to which the heading belongs
  this.list= list;


  this.getText = function() {
    var headingText = this.node.textContent; 
    if(!headingText) {
      //If the heading has no text we want to do something
      headingText = document.getElementById("bundle_DocumentMap").getString('unnamed');
    }
    return headingText;
  };

  this.createTreeNodes = function() {
    //Create the nodes that will be inserted into the tree
    item = document.createElement('treeitem');
    var treeRow  = document.createElement('treerow');
    var treeCell = document.createElement('treecell');
    
    treeCell.setAttribute("label", this.getText());
    
    treeRow.appendChild(treeCell);
    item.appendChild(treeRow);
    return item;
  };

  this.getLevel = function() {
    return 1;
  };

  this.appendSubheading = function(subHeading) {
    //Do all the foo needed to set up a subtree with the current node as the parent
    //subHeading is a headingItem for the child to append
    if(this.hasSubHeadings==false) {
      //There is no existing subtree to append to so we have to create one
      this.treeNodes.setAttribute('container', 'true');
      if (this.treeDepth < this.list.openToDepth || !this.list.openToDepth) {
	this.treeNodes.setAttribute('open', 'true');
      }

      var treeChildren = document.createElement('treechildren');
      this.treeNodes.appendChild(treeChildren);
      this.hasSubHeadings=true;
    }
    subHeading.treeNodes = this.treeNodes.childNodes[1].appendChild(subHeading.treeNodes);
    subHeading.parent = this;
  };
  
  this.removeFromTree = function() {
    //do some stuff to remove a tree element
    var parentNodes;
    if (this.parent && !this.parent.treeNodes) {
      parentNodes=document.getElementById('DocumentMap_tree_top_children');
    }
    else {
      parentNodes = this.parent.treeNodes;
    }
    //The  first child node is a 'treechildren' node
    parentNodes.childNodes[1].removeChild(this.treeNodes);
    //XXX - do we need to test for length here?
    if(this.parent) {
      if(!this.parent.treeNodes.childNodes[1].childNodes) {
	this.parentNodes.setAttribute('container', 'false');
	this.parentNodes.setAttribute('open', 'false');
	//Get rid of the empty treechildren element
	parentNodes.removeChild(parentNodes.childNodes[1]);
	this.parent.hasSubHeadings = false;
      }
    }
  };

}


DocumentMap.listeners.progressListener =  {
  stateIsRequest:false,
  
  QueryInterface : function(aIID) {
    if (aIID.equals(Components.interfaces.nsIWebProgressListener) ||
	aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
	aIID.equals(Components.interfaces.nsISupports))
      return this;
    throw Components.results.NS_NOINTERFACE;
  },
  
  onStateChange : function(aProgress,aRequest,aFlag,aStatus) {
    //This fires if the loading state changes. We want to make sure we update when the document has finished loading
    if (aFlag & Components.interfaces.nsIWebProgressListener.STATE_STOP) {
      //This isn't ideal because it clears the list every time when it should just append 
      //It might be nice to make the time a hidden pref
      //gTimerID = setInterval("DocumentMap.list.update()", 500);
      this.stateIsRequest = true;
      DocumentMap.destroyOutline();
    }
    if (aFlag & Components.interfaces.nsIWebProgressListener.STATE_STOP) {
      //clearInterval(gTimerID);
      this.stateIsRequest = false;
      DocumentMap.createOutline();
    }
    return 0;
  },

  onLocationChange : function(aProgress,aRequest,aLocation) {
      DocumentMap.createOutline();
    return 0;
  },
  onProgressChange : function(a,b,c,d,e,f){},
  onStatusChange : function(a,b,c,d){},
  onSecurityChange : function(a,b,c){},
  onLinkIconAvailable : function(a){} 
}

DocumentMap.load = function() {
  top.getBrowser().addProgressListener(DocumentMap.listeners.progressListener, Components.interfaces.nsIWebProgress.NOTIFY_STATUS);
  DocumentMap.tree = document.getElementById('DocumentMap_tree');
  try {
    this.createOutline();
  }
  catch(error) {
    DocumentMap.utils.dump(error);
  }
}

DocumentMap.unload = function() {
 top.getBrowser().removeProgressListener(DocumentMap.listeners.progressListener);
 if (this.list && this.list.document) {
   this.list.clean();
 }
 DocumentMap = null;
}

DocumentMap.createOutline = function() {
  var document = window.content.document;

  //Use an existing list object if we can
  if (!(this.hasModule) && this.module) {
    if(this.modules[this.module].supportsDocument(document)) {
      this.setPanel(DocumentMap.consts.TREE);
      this.list.fill();
      this.hasModule = true;
    }
  }
  else {
    //Otherwise create a new heading object
    this.hasModule = false;
    try {
      this.destroyOutline();
    } catch(error) {
      DocumentMap.utils.dump(error);
    }
    var i = 0;
    while(this.modules[i]) {
      if(this.modules[i].supportsDocument(document)) {
	this.hasModule = true;
	this.module = i;
	this.headingList = this.modules[i].headingList;
	this.headingItem = this.modules[i].headingItem;
      }
      i++;
    }
    if(this.hasModule) {
      this.list = new DocumentMap.headingList();
      this.setPanel(DocumentMap.consts.TREE);
      this.list.fill();
    }
    else {
      this.setPanel(DocumentMap.consts.NO_MODULE);
    }
  }
  //Display an error message if there are no headings
  if(this.hasModule && !this.list.headings.length) {
    this.setPanel(DocumentMap.consts.NO_HEADINGS);
  }
};

DocumentMap.destroyOutline = function() {
  if(this.list) {
    this.list.clean();
  }
}

DocumentMap.focusHeading = function() {
  this.list.focusHeading();
}

DocumentMap.setPanel = function(index) {
  document.getElementById("deckPanels").setAttribute('selectedIndex', index);
}

DocumentMap.registerModule = function(moduleObject) {
  this.modules.push(moduleObject);
}

DocumentMap.utils.inheritFrom = function(aThis, aParent) {
  var excp;
  for (var property in aParent) {
    try {
      aThis[property] = aParent[property];
    }
    catch(excp) {
      DocumentMap.utils.dump(excp);
    }
  }
}

DocumentMap.utils.prefs = Components.classes['@mozilla.org/preferences-service;1'].getService(Components.interfaces.nsIPrefBranch);

DocumentMap.utils.dump = function(text) {
  dump("DocumentMap: " + text + '\n');
}

/* Nvu todo:
   Character data modificatons
   Editing in tree? */
