var djPrefs = null;
var djIsJunkFolder = false;

// Start prefs service
function djGetPrefs() {
  try {
    var prefsService = Components.classes["@mozilla.org/preferences-service;1"];
    if (prefsService)
		prefsService = prefsService.getService();
    if (prefsService)
		djPrefs = prefsService.QueryInterface(Components.interfaces.nsIPrefBranch);

    if (!djPrefs)
		dump("failed to get prefs service!\n");
  }
  catch(ex) { dump("failed to get prefs service!\n"); }
}

// Show menu item
function djFillMenu() {
	if (IsFakeAccount())
		return false;

	var folderTree = GetFolderTree();
	var startIndex = {};
	var endIndex = {};
	folderTree.view.selection.getRangeAt(0, startIndex, endIndex);
	if (startIndex.value < 0)
		return false;
	var numSelected = endIndex.value - startIndex.value + 1;
	var folderResource = GetFolderResource(folderTree, startIndex.value);

	var isServer = GetFolderAttribute(folderTree, folderResource, "IsServer") == 'true';
	var serverType = GetFolderAttribute(folderTree, folderResource, "ServerType");
	var specialFolder = GetFolderAttribute(folderTree, folderResource, "SpecialFolder");
	var isMailFolder = !isServer && serverType != 'nntp';

	var djShowMenu = ((numSelected == 1) && isMailFolder);
	djIsJunkFolder = (specialFolder == "Junk");
	
	try	{
		if (!djPrefs) 
			djGetPrefs();

		if (djPrefs.getIntPref("deletejunk.showmenufor") == 1)
			djShowMenu = (djShowMenu && djIsJunkFolder);
	} catch (ex) {}

	ShowMenuItem("folderPaneContext-deletejunk", djShowMenu);
	EnableMenuItem("folderPaneContext-deletejunk", djShowMenu);
}

function djDeleteJunk() {
	var folderTree = GetFolderTree();
	if (folderTree) {
		var selectedFolders = GetSelectedMsgFolders();
		var selectedFolder = selectedFolders[0];

		// Save old selections
		var currentFolder = GetThreadPaneFolder();
		var currentMessages = GetSelectedMessages();

		// Select folder if not current
		if (selectedFolder != currentFolder) {
			ClearThreadPane();
			ClearMessagePane();
			folderTree.view.selection.clearSelection();
			SelectFolder(selectedFolder.URI);
		}

		var enabled = new Object();
		enabled.value = false;
		var checkStatus = new Object();
		if (gDBView)
			gDBView.getCommandStatus(nsMsgViewCommandType.deleteJunk, enabled, checkStatus);

		// Run command if valid
		if (enabled.value) {
			var djBypassTrash = 0;
			
			try { djBypassTrash = djPrefs.getIntPref("deletejunk.bypasstrash"); } catch (ex) {}
			if (!djBypassTrash || (djBypassTrash == 1 && !djIsJunkFolder)) {
				// Delete junk into Trash
				deleteJunkInFolder();
			} else {
				// Delete junk bypassing Trash
				/* Copied from deleteJunkInFolder() in mailCommands.js
				   Changed if statements so we don't return out of function
				*/
				MsgJunkMailInfo(true);
				var view = GetDBView();

				// need to expand all threads, so we find everything
				view.doCommand(nsMsgViewCommandType.expandAll);

				var treeView = view.QueryInterface(Components.interfaces.nsITreeView);
				var count = treeView.rowCount;
				if (count) {
					var treeSelection = treeView.selection;

					var clearedSelection = false;

					// select the junk messages
					for (var i = 0; i < count; i++) {
						var messageUri = view.getURIForViewIndex(i);
						var msgHdr = messenger.messageServiceFromURI(messageUri).messageURIToMsgHdr(messageUri);
						var junkScore = msgHdr.getStringProperty("junkscore"); 
						var isJunk = ((junkScore != "") && (junkScore != "0"));
						// if the message is junk, select it.
						if (isJunk) {
						  // only do this once
						  if (!clearedSelection) {
							// clear the current selection
							// since we will be deleting all selected messages
							treeSelection.clearSelection();
							clearedSelection = true;
							treeSelection.selectEventsSuppressed = true;
						  }
						  treeSelection.rangedSelect(i, i, true /* augment */);
						}
					}

					// if we didn't clear the selection
					// there was no junk, so bail.
					if (clearedSelection) {
						treeSelection.selectEventsSuppressed = false;
						// delete the selected messages
						//
						// XXX todo
						// should we try to set next message after delete 
						// to the message selected before we did all this, if it was not junk?
                        view.doCommand(nsMsgViewCommandType.deleteNoTrash);
                        ClearMessageSelection();
					}
				}
			}

			/* Commenting out 'compact folder' because it's dangerous!
			   Several times, all mails in my trash that were marked as junk lost their junk status

			if (djPrefs.getBoolPref("deletejunk.compactfolder")) {
				try {
					messenger.CompactFolder(GetFolderDatasource(), selectedFolder.QueryInterface(Components.interfaces.nsIRDFResource), false);
				} catch (ex) {}
			}
			*/
		}

		// Restore selections
		if (selectedFolder != currentFolder && djPrefs.getBoolPref("deletejunk.restoreselection")) {
			try {
				ClearThreadPaneSelection();
				ClearMessagePane();
                ClearThreadPane();

				SelectFolder(currentFolder.URI);

				ClearThreadPaneSelection();
				ClearMessagePane();
			} catch (ex) {}
		}
	}
}