
function copyplaintext(){
	try{
		// Get String
		var str = copyplaintext_getSelection() + "";
		
		// Format
			var oPrefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
			
			// Trim
			if(oPrefs.prefHasUserValue("copyplaintext.formatting.trim") && oPrefs.getBoolPref("copyplaintext.formatting.trim"))
				str = str.replace(/^\s*|\s*$/g, "");
			
			// Extra Lines
			if(oPrefs.prefHasUserValue("copyplaintext.formatting.extra.newline") && oPrefs.getBoolPref("copyplaintext.formatting.extra.newline"))
				str = str.replace(/[\n\r]+/g, "\n");
			
			// Extra Space
			if(oPrefs.prefHasUserValue("copyplaintext.formatting.extra.space") && oPrefs.getBoolPref("copyplaintext.formatting.extra.space"))
				str = str.replace(/[ \t]+/g, " ");
		
		
		// Copy
		if(str != null && str.length > 0){
			var oClipBoard = Components.classes["@mozilla.org/widget/clipboardhelper;1"].getService(Components.interfaces.nsIClipboardHelper);
				oClipBoard.copyString(str);
		}
				
	}catch(err) { alert("An unknown error occurred\n"+ err) }
}

function copyplaintext_init(){
	var oContext = document.getElementById('contentAreaContextMenu');
	
	if(oContext){
		oContext.setAttribute("onpopupshowing", "copyplaintext_showContextMenu(); "+ oContext.getAttribute("onpopupshowing"));
	}
}

function copyplaintext_showMenu(){

	// Is Text Select
	try{		
		var str = copyplaintext_getSelection();
		if(str != null && str.length > 0) {
			return true;
		}
				
	}catch(err) { }
	
	return false;
}

function copyplaintext_getSelection() {
	var focusedWindow = document.commandDispatcher.focusedWindow;
	var searchStr = focusedWindow.__proto__.getSelection.call(focusedWindow);
	searchStr = searchStr.toString();
	
	return searchStr;
}

function copyplaintext_showEditMenu(){
	document.getElementById('copyplaintext-edit-menu').setAttribute("disabled", !copyplaintext_showMenu());
}

function copyplaintext_showMozEditMenu(){
	document.getElementById('copyplaintext-moz-edit-menu').setAttribute("disabled", !copyplaintext_showMenu());
}

function copyplaintext_showContextMenu(){
	document.getElementById('copyplaintext-context-menu').setAttribute("collapsed", !copyplaintext_showMenu());
}