/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is bbs2chreader.
 *
 * The Initial Developer of the Original Code is
 * flyson.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    flyson <flyson at users.sourceforge.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */




/**
 * bbs2ch: ץȥϥɥ
 */


// ********** ********* ݡͥ ID ********** **********


const BBS2CH_P_HANDLER_CONTRACTID =
			"@mozilla.org/network/protocol;1?name=bbs2ch";
const BBS2CH_P_HANDLER_CID =
			Components.ID("{e40dcbe9-0d0a-44c2-b135-3b2a2afe8b97}");

const BBS2CH_C_HANDLER_CONTRACTID =
			"@mozilla.org/uriloader/content-handler;1?type=x-application-bbs2ch";
const BBS2CH_C_HANDLER_CID =
			Components.ID("{409FF8BB-32AB-49c7-AD66-8E2BA8530A49}");


// ********** ********* bbs2ch: ץȥϥɥ ********** **********


function Bbs2chProtocolHandler(){
	this.init();
}


Bbs2chProtocolHandler.prototype = {
	// ********** implements nsIProtocolHandler **********
	
	scheme: "bbs2ch",
	defaultPort: -1,
	protocolFlags: Components.interfaces.nsIProtocolHandler.URI_NOAUTH,


	allowPort: function(aPort, aScheme){
		return false;
	},


	newURI: function(aSpec, aCharset, aBaseURI){
		var simpleURI = Components.classes["@mozilla.org/network/simple-uri;1"]
								.createInstance(Components.interfaces.nsIURI);
		
		if(aBaseURI && aSpec.charAt(0)=="#"){ // 󥫡 URL
			var baseURISprc = aBaseURI.spec.replace(/#[^\/]+/, "");
			simpleURI.spec = baseURISprc + aSpec;
		}else{ // ̾ URL
			try{
				simpleURI.spec = aSpec;
			}catch(ex){
				dump("ERROR: Bbs2chProtocolHandler.newURI : " + aSpec + "\n");
			}
		}
		return simpleURI;
	},


	newChannel: function(aURI){
		var mode = "";
		if(aURI.spec.match(/bbs2ch:([\w-]+:?)/)) mode = RegExp.$1;

		var tmpChannel;
		switch(mode){
			case "bbsmenu":
				tmpChannel = this.redirectChannel("chrome://bbs2chreader/content/bbsmenu-page.xul");
				break;
			case "board:":
				tmpChannel = this.redirectChannel("chrome://bbs2chreader/content/board-page.xul");
				break;
			case "thread:" :
				tmpChannel = new Bbs2chChannel(aURI, "text/html", "Shift_JIS", Bbs2chThread);
				break;
			case "board-rss:" :
				tmpChannel = new Bbs2chChannel(aURI, "text/xml", "Shift_JIS", Bbs2chBoardRss);
				break;
			default:
				tmpChannel = this.createStringChannel(aURI, "x-application-bbs2ch", aURI.spec);
				break;
		}

		return tmpChannel;
	},


	// ********** ץѥƥ **********


	get ioService(){
		if(!this._ioService){
			this._ioService = Components.classes["@mozilla.org/network/io-service;1"]
									.getService(Components.interfaces.nsIIOService);
		}
		return this._ioService;
	},
	_ioService: null,


	get subScrLoader(){
		if(!this._subScrLoader){
			this._subScrLoader = Components.classes["@mozilla.org/moz/jssubscript-loader;1"]
									.getService(Components.interfaces.mozIJSSubScriptLoader);
		}
		return this._subScrLoader;
	},
	_subScrLoader: null,


	// ********** ᥽å **********


	init: function(){
		this.subScrLoader.loadSubScript("chrome://bbs2chreader/content/global.js");
		this.subScrLoader.loadSubScript("chrome://bbs2chreader/content/channel.js");
			// use Bbs2chThread
		this.subScrLoader.loadSubScript("chrome://bbs2chreader/content/httprequest.js");
		this.subScrLoader.loadSubScript("chrome://bbs2chreader/content/abone.js");
			// use Bbs2chBoardRss
		this.subScrLoader.loadSubScript("chrome://bbs2chreader/content/downloader.js");
		this.subScrLoader.loadSubScript("chrome://bbs2chreader/content/board-items.js");

		this.subScrLoader.loadSubScript("chrome://bbs2chreader/content/thread.js");
		this.subScrLoader.loadSubScript("chrome://bbs2chreader/content/board-rss.js");
		
		Bbs2chGlobal.setSkinResSubstitution();
	},


	redirectChannel: function(aURISpec){
		var channelURI = Components.classes["@mozilla.org/network/standard-url;1"]
							.createInstance(Components.interfaces.nsIURI);
		channelURI.spec = aURISpec;
		return this.ioService.newChannelFromURI(channelURI);
	},


	createStringChannel: function(aURI, aContentType, aContent){
		var inputStreamChannel = Components.classes["@mozilla.org/network/input-stream-channel;1"]
									.createInstance(Components.interfaces.nsIInputStreamChannel);
		var stringInputStream = Components.classes["@mozilla.org/io/string-input-stream;1"]
									.createInstance(Components.interfaces.nsIStringInputStream);

		stringInputStream.setData(aContent, aContent.length);

		inputStreamChannel.setURI(aURI);
		inputStreamChannel.contentType = aContentType;
		inputStreamChannel.contentStream = stringInputStream;
		inputStreamChannel.contentLength = aContent.length;
		return inputStreamChannel;
	}
}


// ********** ********* bbs2ch: ץȥϥɥեȥ ********** **********


var Bbs2chProtocolHandlerFactory = {
	createInstance: function(aOuter, aIID){
		if(aOuter != null)
			throw Components.results.NS_ERROR_NO_AGGREGATION;
		if(!aIID.equals(Components.interfaces.nsIProtocolHandler) && !aIID.equals(Components.interfaces.nsISupports))
			throw Components.results.NS_ERROR_INVALID_ARG;

		return new Bbs2chProtocolHandler();
	}
}


// ********** ********* x-application-bbs2ch ƥȥϥɥ ********** **********


function Bbs2chContentHandler(){}

Bbs2chContentHandler.prototype = {
	QueryInterface: function(aIID){
		if(!aIID.equals(Components.interfaces.nsIContentHandler))
			throw Components.results.NS_ERROR_NO_INTERFACE;
		return this;
	},

	// ********** implements nsIContentHandler **********

	handleContent: function(aContentType, aCommand, aWindowContext, aRequest){
		if(!aRequest){ // Gecko 1.7/1.8 ߴ
			aRequest = aWindowContext;
			aWindowContext = aCommand;
		}

			// ɥμ
		var appShellService = Components.classes["@mozilla.org/appshell/appShellService;1"]
									.getService(Components.interfaces.nsIAppShellService);
		var win = appShellService.hiddenDOMWindow;

		var channel = aRequest.QueryInterface(Components.interfaces.nsIChannel);
		var uriSpec = channel.URI.spec;
		var mode = uriSpec.match(/bbs2ch:(\w+:?)/) ? RegExp.$1 : "";


		switch(mode){
			case "post:": // 񤭹ߥ
				win.openDialog("chrome://bbs2chreader/content/post-wizard.xul",
								"winBbs2chPostWizard", "chrome, resizable", uriSpec);
				break;
			case "void": // ⤷ʤ
				break;
			default:
				break;
		}
	}
}


// ********** ********* x-application-bbs2ch ƥȥϥɥեȥ ********** **********


var Bbs2chContentHandlerFactory = {
	createInstance: function (aOuter, aIID){
		if(aOuter != null)
			throw Components.results.NS_ERROR_NO_AGGREGATION;
		if(!aIID.equals(Components.interfaces.nsIContentHandler) && !aIID.equals(Components.interfaces.nsISupports))
			throw Components.results.NS_ERROR_INVALID_ARG;
		return new Bbs2chContentHandler();
	}
}


// ********** ********* ݡͥ Ͽ ********** **********


var Bbs2chModule = {

	registerSelf: function(aCompMgr, aFileSpec, aLocation, aType){
		aCompMgr = aCompMgr.QueryInterface(Components.interfaces.nsIComponentRegistrar);
		
		aCompMgr.registerFactoryLocation(BBS2CH_P_HANDLER_CID,
				"bbs2ch protocol handler", BBS2CH_P_HANDLER_CONTRACTID,
				aFileSpec, aLocation, aType);

		aCompMgr.registerFactoryLocation(BBS2CH_C_HANDLER_CID,
				"x-application-bbs2ch content handler", BBS2CH_C_HANDLER_CONTRACTID,
				aFileSpec, aLocation, aType);
	},

	unregisterSelf: function(aCompMgr, aFileSpec, aLocation){
		aCompMgr = aCompMgr.QueryInterface(Components.interfaces.nsIComponentRegistrar);
	},

	getClassObject: function(aCompMgr, aCID, aIID){
		if(aCID.equals(BBS2CH_P_HANDLER_CID))
				return Bbs2chProtocolHandlerFactory;

		if(aCID.equals(BBS2CH_C_HANDLER_CID))
				return Bbs2chContentHandlerFactory;

		if(!aIID.equals(Components.interfaces.nsIFactory))
				throw Components.results.NS_ERROR_NOT_IMPLEMENTED;
		
		throw Components.results.NS_ERROR_NO_INTERFACE;
	},

	canUnload: function(aCompMgr){
		return true;
	}

}

function NSGetModule(aCompMgr, aFileSpec){
	return Bbs2chModule;
}