/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is bbs2chreader.
 *
 * The Initial Developer of the Original Code is
 * flyson.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    flyson <flyson at users.sourceforge.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */




function Bbs2chThread(aBbs2chChannel){
	this._channel = aBbs2chChannel;
	this.init();
}

Bbs2chThread.prototype = {


// ********** ********* implements nsITimerCallback ********** **********


	notify: function(aTimer){
		this._timeoutFunc();
	},


// ********** ********* ץѥƥ ********** **********


	get channel(){
		return this._channel;
	},


	get threadURL(){
		return this._threadURL;
	},


	get boardURL(){
		return this._boardURL;
	},


	get datURL(){
		return this._datURL;
	},


	get datFile(){
		return this._datFile;
	},

	get idxFile(){
		return this._idxFile;
	},

	get title(){
		return this._title;
	},

	get lineCount(){
		return this._lineCount;
	},

	get contentLength(){
		return this.datFile.exists() ? this.datFile.fileSize : 0;
	},

	get lastModified(){
		return this._lastModified;
	},

	get eTag(){
		return this._eTag;
	},

	get type(){
		return this._type;
	},

	get datID(){
		return this._datID;
	},


// ********** ********* ᥽å ********** **********


	init: function(){
			// HTML إå true ˤʤ
		this._headerResponded = false;

		this._abone = new Bbs2chAbone();
	
			// åɤ URL
		var threadURLSpec = this.channel.URI.spec.replace(/^bbs2ch:thread:/, "");
		try{
			this._threadURL = Bbs2chGlobal.ioService.newURI(threadURLSpec, null, null)
								.QueryInterface(Components.interfaces.nsIURL);
		}catch(ex){
				// ǧǤʤ URL
			this.requestEnd(false, "BAD URL");
			return;
		}

			// ĤΥפå
		this._type = Bbs2chGlobal.getBoardType(this.threadURL.spec);
		
			// ĤΥפTYPE_PAGE Ǥ⡢
			// URL  /test/read.cgi/ ޤǤ 2chߴȤߤʤ
		if(this._type == Bbs2chGlobal.TYPE_PAGE &&
			this.threadURL.spec.indexOf("/test/read.cgi/") != -1)
				this._type = Bbs2chGlobal.TYPE_2CH;



		switch(this.type){
			case Bbs2chGlobal.TYPE_MACHI:
					//  BBS бƤʤΤǽλ
				this.requestEnd(false, "MACHI-BBS NOT SUPPORTED");
				return;
			case Bbs2chGlobal.TYPE_PAGE:
					// ǧǤʤΤǽλ
				this.requestEnd(false, "BAD URL");
				return;
		}

			
			// åɤ URL
		var boardURLSpec = this.threadURL.resolve("../");
		if(this.type==Bbs2chGlobal.TYPE_2CH || this.type==Bbs2chGlobal.TYPE_BE2CH){
				// 2ch
			boardURLSpec = boardURLSpec.replace("/test/read.cgi/", "/");
		}else if(this.type==Bbs2chGlobal.TYPE_JBBS){
				// JBBS
			boardURLSpec = boardURLSpec.replace("/bbs/read.cgi/", "/");		
		}
		this._boardURL = Bbs2chGlobal.ioService.newURI(boardURLSpec, null, null)
								.QueryInterface(Components.interfaces.nsIURL);

			// DAT ID
		this.threadURL.spec.match(/\/(\d{9,10})/);
		this._datID = RegExp.$1;


			// DAT  URL
		var datURLSpec = "";
		if(this.type==Bbs2chGlobal.TYPE_2CH || this.type==Bbs2chGlobal.TYPE_BE2CH){
				// 2ch
			datURLSpec = this.boardURL.resolve("dat/" + this.datID + ".dat");
		}else if(this.type==Bbs2chGlobal.TYPE_JBBS){
				// JBBS
			var datURLSpec = this.threadURL.resolve("./").replace("read.cgi", "rawmode.cgi");
		}
		this._datURL = Bbs2chGlobal.ioService.newURI(datURLSpec, null, null)
								.QueryInterface(Components.interfaces.nsIURL);


			// ǥ쥯ȥ .dat ե
		this._datFile = Bbs2chGlobal.createLogFile(
							this.boardURL.resolve(this.datID + ".dat"));

			// ǥ쥯ȥ .idx ե
		this._idxFile = Bbs2chGlobal.createLogFile(
							this.boardURL.resolve(this.datID + ".idx"));

			// idx ե뤫饿ȥ
		if(this.idxFile.exists()){
			var idxContent =  Bbs2chGlobal.readFile(this.idxFile.path);

			this._title = idxContent.match(/^title=(.+)/m) ? RegExp.$1 : "";
			this._lineCount = idxContent.match(/^lineCount=(.+)/m) ? Number(RegExp.$1) : 0;
			this._lastModified = idxContent.match(/^lastModified=(.+)/m) ? RegExp.$1 : "";
			this._eTag = idxContent.match(/^etag=(.+)/m) ? RegExp.$1 : "";
		}else{
			this._title = "";
			this._lineCount = 0;
			this._lastModified = "";
			this._eTag = "";
		}

			// ƥץ졼Ȥɤ߹
		this.loadSkinTemplate();


		this._logLineCount = 0;
			// Ѥߥ
		if(this.datFile.exists()){
			var logLines = Bbs2chGlobal.readFile(this.datFile.path);
			logLines = this.convertCharset(logLines);
			logLines = logLines.split("\n");

			this._logLineCount = logLines.length - 1;

				// URL  l ä
			var startLine = 0;
			if(this.threadURL.filePath.match(/\/l(\d{1,3})$/)){
				var half = parseInt(RegExp.$1) + 1;
				startLine = logLines.length - half;
			}
			
			if(startLine < 0) startLine = 0;
			
			if(startLine != 0)// ֤ɬ
					this.requestRespond(this.datLineParse(logLines[0], 1, false) + "\n\n\n");
			
			for(var i=startLine; i<logLines.length; i++){
				this.requestRespond(this.datLineParse(logLines[i], i+1, false) + "\n\n\n");
			}
			
			this.requestRespond(this._tmpNewMark);
		}
		
			// ե饤ʤ齪λ
		if(Bbs2chGlobal.ioService.offline){
			this.requestEnd(false, "OFFLINE MODE");
			return;
		}
		
		this.setTimeout(this.httpGetStart, 500);
	},


	/**
	 * ƥץ졼Ȥɤ߹
	 */
	loadSkinTemplate: function(){
		try{
				// ƥ򤹤뤿ˡresource ͳ
				// Bbs2chGlobal.setSkinResSubstitution() 
			this._skinURISpec = "resource://bbs2ch-skin/";
			this._tmpHeader  = Bbs2chGlobal.readLocalURI(this._skinURISpec + "Header.html");
			this._tmpFooter  = Bbs2chGlobal.readLocalURI(this._skinURISpec + "Footer.html");
			this._tmpRes	 = Bbs2chGlobal.readLocalURI(this._skinURISpec + "Res.html");
			this._tmpNewRes  = Bbs2chGlobal.readLocalURI(this._skinURISpec + "NewRes.html");
			this._tmpNewMark = Bbs2chGlobal.readLocalURI(this._skinURISpec + "NewMark.html");
		}catch(ex){
				// 顼Фƽλ
			this.requestEnd(false, "Load Skin Error");
			return;

				// ɤ߹ߤ˼Ԥϥǥեȥɤ߹
			this._skinURISpec = Bbs2chGlobal.getDefaultValue("fls.bbs2chreader.thread_skin_uri");
			this._tmpHeader   = Bbs2chGlobal.readLocalURI(this._skinURISpec + "Header.html");
			this._tmpFooter   = Bbs2chGlobal.readLocalURI(this._skinURISpec + "Footer.html");
			this._tmpRes	  = Bbs2chGlobal.readLocalURI(this._skinURISpec + "Res.html");
			this._tmpNewRes   = Bbs2chGlobal.readLocalURI(this._skinURISpec + "NewRes.html");
			this._tmpNewMark  = Bbs2chGlobal.readLocalURI(this._skinURISpec + "NewMark.html");
		}

			// ܥ󥿥ִ
		this._tmpHeader = this.replaceBaseTag(this._tmpHeader);
		this._tmpFooter = this.replaceBaseTag(this._tmpFooter);
		this._tmpRes = this.replaceBaseTag(this._tmpRes);		
		this._tmpNewRes = this.replaceBaseTag(this._tmpNewRes);
		this._tmpNewMark = this.replaceBaseTag(this._tmpNewMark);
	},


	/**
	 * ܥ󥿥ִ
	 * @param aString string ִʸ
	 */
	replaceBaseTag: function(aString){
		return aString.replace(/<SKINPATH\/>/g, this._skinURISpec)
							.replace(/<THREADURL\/>/g, this.threadURL.resolve("./"))
							.replace(/<BOARDURL\/>/g, this.boardURL.spec);
	},


	/**
	 * ꥯȤ
	 */
	requestRespond: function(aString){
		this.channel.requestRespond(aString);
	},


	/**
	 * ꥯȤνλ
	 * @param aSuccessed ꥯȤʤ鿿
	 * @param aStatusText λƥȤޤϥ顼ƥ
	 */
	requestEnd: function(aSuccessed, aStatusText){
			// 顼ġޤ HTML إåƤʤ
		if(!aSuccessed && !this._headerResponded){
			var template = Bbs2chGlobal.readLocalURI("chrome://bbs2chreader/content/res/thread-error.txt");
			template = template.replace(/%URL%/g, this.threadURL.spec)
									.replace(/%STATUS%/g, aStatusText);
			this.requestRespond(template);
			this.channel.requestEnd();
			return;
		}	
	
			// HTML եå
		if(!this._tmpFooter.match(/<STATUS\/>/)){
				// ͤθߴ
			this._tmpFooter = '<p class="info"><STATUS/></p>\n' + this._tmpFooter;
		}
		this._tmpFooter = this._tmpFooter.replace(/<STATUS\/>/g, aStatusText)
								.replace(/<GETRESCOUNT\/>/g, this._logLineCount)
								.replace(/<NEWRESCOUNT\/>/g, this.lineCount - this._logLineCount)
								.replace(/<ALLRESCOUNT\/>/g, this.lineCount);
		this.requestRespond(this._tmpFooter);


			// 顼λ
		if(!aSuccessed && this._headerResponded){
			this.channel.requestEnd();
			return;
		}	

		this.channel.requestEnd();
	},



	/**
	 * DAT եιԤβ
	 * @param aLine string Ԥ
	 * @param aNumber number 쥹ֹ
	 * @param aNew boolean 쥹ʤ鿿
	 */
	datLineParse: function(aLine, aNumber, aNew){
		if(!aLine) return "";
		var template = (aNew) ? this._tmpNewRes : this._tmpRes;

		var resArray = aLine.split("<>");
			// JBBS  DAT ϡǽֹ椬ĤΤǺ			
		if(this.type == Bbs2chGlobal.TYPE_JBBS) resArray.shift();
		
		var resNumber = aNumber;
		var resName = "BLOKEN";
		var resMail = "";
		var resDate = "BLOKEN";
		var resID = "";
		var resBeID = "";
		var resMes	= "";
		
		if(resArray.length > 3){
			resName = resArray[0].replace(/<\/?b>|/g, "");
			resMail = resArray[1];			
			resDate = resArray[2];
			resMes = resArray[3];
		}
		
		if(this._abone.shouldAbone(resName, resMail, resDate, resMes)){
			resName = "ABONE";
			resMail = "ABONE";
			resDate = "ABONE";
			resMes	= "ABONE";
		}

			// JSǤ "\" üʰ̣ĤᡢʸȤѴ
		resName=resName.replace(/([^\x81-\xfc]|^)\x5C/g,"$1&#x5C;");
		resMail=resMail.replace(/([^\x81-\xfc]|^)\x5C/g,"$1&#x5C;");

		var resMailName = resName;
		if(resMail) resMailName = '<a href="mailto:' + resMail + '">' + resName + '</a>';


			// BeID Ѵ
			// ͤǤޤäŤͤбϤϤ
		if(resDate.indexOf("javascript:") != -1){
				// JavaScript ľ񤭤 ID  BE:*******-* Ѵ
			resDate = resDate.replace("<a href=javascript:w=window.open('http://be.2ch.net/test/p.php?i=", "BE:")
						.replace("&u=d:'+document.URL);if(w)w.focus();void(0);>?", "-")
						.replace("</a>", "");
		}
			// <a href=/test/p.php?i=******* target=_blank>?*</a>  ν
		var regBeID = /<a href=\/test\/p\.php\?i=(\d+) target=_blank>\?(\*{0,5})<\/a>/;
		if(resDate.match(regBeID)){
			var idInfoUrl = "http://be.2ch.net/test/p.php?i=" + RegExp.$1 +
					"&u=d:" + this.threadURL.resolve("./") + aNumber;
			resDate = resDate.replace(regBeID, "BE: " + String("$1 Lv." + RegExp.$2.length).link(idInfoUrl));
		}
			// BE:*******-*  ν
		var regBeID2 = /BE: ?(\d+)\-(#{0,5})/;
		if(resDate.match(regBeID2)){
			var idInfoUrl = "http://be.2ch.net/test/p.php?i=" + RegExp.$1 +
					"&u=d:" + this.threadURL.resolve("./") + aNumber;
			resDate = resDate.replace(regBeID2, "BE: " + String("$1 Lv." + RegExp.$2.length).link(idInfoUrl));
		}
			// <BE:*******-*>  ν
		var regBeID3 = /<BE:(\d+):(\d+)>/;
		if(resDate.match(regBeID3)){
			var idInfoUrl = "http://be.2ch.net/test/p.php?i=" + RegExp.$1 +
					"&u=d:" + this.threadURL.resolve("./") + aNumber;
			resDate = resDate.replace(regBeID3, "BE: " + String("$1 Lv.$2").link(idInfoUrl));
		}


			// resDate  DATE  BeID ʬ
		if(resDate.match(/(.+)BE:(.+)/)){
			resDate = RegExp.$1;
			resBeID = RegExp.$2;
		}
			// resDate  DATE  ID ʬ
		if(resDate.match(/(.+)ID:(.+)/)){
			resDate = RegExp.$1;
			resID = RegExp.$2;
		}

			// JBBS  ID ϡ5ܤΥ
		if(this.type==Bbs2chGlobal.TYPE_JBBS && resArray.length > 5){
				resID = resArray[5];
		}

		if(!template.match(/<ID\/>/))
			resDate = resDate + " ID: " + resID;
		if(!template.match(/<BEID\/>/))
			resDate = resDate + " Be: " + resBeID;


			// replace ؿǤ "$" üʰ̣ĤᡢʸȤѴ
		resMes = resMes.replace(/\$/g, "&#36;");

			// JSǤ "\" üʰ̣ĤᡢʸȤѴ
		resMes = resMes.replace(/([^\x81-\xfc]|^)\x5C/g, "$1&#x5C;");


			// 쥹֥󥯽
		var regResPointer = /(<a .*?>)?(&gt;&gt;|&gt;)([0-9]{1,4})(\-[0-9]{1,4})?(<\/a>)?/g;
		resMes = resMes.replace(regResPointer, '<a href="#res$3" class="resPointer">$2$3$4</a>'); 

			// ̾󥯽 
		var regUrlLink = /(h?ttp)(s)?\:([\-_\.\!\~\*\'\(\)a-zA-Z0-9\;\/\?\:\@\&\=\+\$\,\%\#]+)/g;
		resMes = resMes.replace(regUrlLink, '<a href="http$2:$3" class="outLink">$1$2:$3</a>');


		var result = template.replace(/<PLAINNUMBER\/>/g, resNumber)
								.replace(/<NUMBER\/>/g, resNumber)
								.replace(/<NAME\/>/g, resName)
								.replace(/<MAIL\/>/g, resMail)
								.replace(/<MAILNAME\/>/g, resMailName)
								.replace(/<DATE\/>/g, resDate)
								.replace(/<ID\/>/g, resID)
								.replace(/<BEID\/>/g, resBeID)
								.replace(/<MESSAGE\/>/g, resMes);


			// åɤΥȥ뤬ĤäȤ HTML إåɲä
		if(!this._headerResponded && resArray[4]){
			this._headerResponded = true;
			this._title = resArray[4];
			this._tmpHeader = this._tmpHeader.replace(/<THREADNAME\/>/g, this.title);
			result = this._tmpHeader + result;
		}

		return result;
	},


	/**
	 * ĤΥפˤ碌ʸѴ
	 * @param aString string Ѵʸ
	 * @return strig Ѵʸ
	 */
	convertCharset: function(aString){
		switch(this.type){
			case Bbs2chGlobal.TYPE_BE2CH:
			case Bbs2chGlobal.TYPE_JBBS:
				aString = Bbs2chGlobal.toSJIS(Bbs2chGlobal.fromEUC(aString));
				break;
		}
		return aString;
	},


	/**
	 * nsITimer Ȥä¹
	 * @param aFunction function ¹Ԥؿ
	 * @param aDelay number ǥ쥤Υߥÿ
	 */
	setTimeout: function(aFunction, aDelay){
		if(this._timer) this._timer.cancel();
		if(this._timeoutFunc) this._timeoutFunc = null;

		this._timer = Components.classes["@mozilla.org/timer;1"]
								.createInstance(Components.interfaces.nsITimer);
		this._timeoutFunc = aFunction;
		this._timer.initWithCallback(this, aDelay, this._timer.TYPE_ONE_SHOT);	
	},


	/**
	 * HTTP ꥯȤȤä DAT եμ
	 */
	httpGetStart: function(){	
		this._buffer = "";
		
		this._httpReq = new Bbs2chHttpRequest(this.datURL.spec, this);

		if(this.type == Bbs2chGlobal.TYPE_JBBS && this.lineCount){
				// JBBS  ʬϡDAT URL + 쥹κǽֹ + "-"
			this._httpReq = new Bbs2chHttpRequest(this.datURL.spec + (this.lineCount+1) + "-", this);
		}

		if(this.datFile.exists() && this.contentLength && this.lastModified){
			this._httpReq.getRange(this.contentLength, this.lastModified);
		}else{
			this._httpReq.get();
		}
	},


// ********** ********* implements Bbs2chHttpRequestListener ********** **********


	onHttpStart: function(){},


	onHttpStop: function(aResponseText, aStatus){
		switch(aStatus){
			case 200: //̾GET OK
			case 206: //ʬGET OK
				break;
			case 304: //̤
				this.requestEnd(false, "NOT MODIFIED");
				return;
			default: // HTTP 顼
				this.requestEnd(false, "ERROR HTTP STATUS : " + aStatus);
				return;
		}

			// JBBS ̤ΤȤʸ֤
		if(!aResponseText){
			this.requestEnd(false, "NOT MODIFIED");
			return;
		}		

		if(this._buffer){
			this._lineCount ++;
			
			this._buffer = this.convertCharset(this._buffer);			
			this.requestRespond(this.datLineParse(this._buffer, this.lineCount, true));
		}
			// ꥯȤνλ
		this.requestEnd(true, "OK");

		this._lastModified = this._httpReq.getResponseHeader("Last-Modified");
		this._eTag = this._httpReq.getResponseHeader("Etag");


		if(aStatus == 200 || aStatus == 206){
				// ¸ɤ߹
			var logContent = "";
			if(this.datFile.exists()){
				logContent = Bbs2chGlobal.readFile(this.datFile.path);
			}

				// 񤭹ߤΥХåƥ󥰤򤱤
			var tmpLineCount = 0;
			if(this.idxFile.exists()){
				var idxContent = Bbs2chGlobal.readFile(this.idxFile.path);
				tmpLineCount = idxContent.match(/^lineCount=(.+)/m) ? RegExp.$1 : 0;
			}
			if(this.lineCount > tmpLineCount){
					// .dat ν񤭹
				Bbs2chGlobal.writeFile(this.datFile.path, logContent + aResponseText);
				
					// .idx ν񤭹
				var idxArray = new Array();
				if(this.title) idxArray.push("title=" + this.title);
				if(this.lineCount) idxArray.push("lineCount=" + this.lineCount);
				if(this.lastModified) idxArray.push("lastModified=" + this.lastModified);
				if(this.eTag) idxArray.push("etag=" + this.eTag);
				Bbs2chGlobal.writeFile(this.idxFile.path, idxArray.join("\n"));
			}
		}
	},


	onHttpDataAvailable: function(aAvailableData, aStatus){
		if(!(aStatus==200 || aStatus==206)) return;

		aAvailableData = this.convertCharset(aAvailableData);
		aAvailableData = this._buffer + aAvailableData;


			// ԤޤޤʤʤХåեɲäƽλ
		if(!aAvailableData.match(/\n/)){
			this._buffer = aAvailableData;
			return;
		}

		var datLines = aAvailableData.split("\n");
		if(datLines.length > 1){
			this._buffer = datLines.pop();
		}else{
			this._buffer = "";
		}

		for(var i=0; i<datLines.length; i++){
			this._lineCount ++;
			datLines[i] = this.datLineParse(datLines[i], this.lineCount, true);
		}
		this.requestRespond(datLines.join("\n"));
	},


	onHttpError: function(aErrorCode){
		var errorText = "";
		switch(aErrorCode){
			case this._httpReq.ERROR_NOT_AVAILABLE:
				errorText = "HTTP: NOT AVAILABLE";
				break;
			case this._httpReq.ERROR_FAILURE:
				errorText = "HTTP: ERROR FAILURE";
				break;
		}
		this.requestEnd(false, errorText);
	}
}