/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is bbs2chreader.
 *
 * The Initial Developer of the Original Code is
 * flyson.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    flyson <flyson at users.sourceforge.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */




function startup(){
	loadSettings();
	initThreadSkinList();

	doEnable("chkAppointDataDir", "checked", "ffrmDataDir");
}

function accept(){
	saveSettings();
	Bbs2chGlobal.setSkinResSubstitution();
}


/**
 * pref ǂݍŃRg[̒lݒ肷
 */
function loadSettings(){
	var prefElements = document.getElementsByAttribute("prefelement", "true");
	
	for(var i=0; i<prefElements.length; i++){
		var prefElement = prefElements[i];
		var prefString = prefElement.getAttribute("prefstring");
		var prefAttribute = prefElement.getAttribute("prefattribute");

		var prefValue = Bbs2chGlobal.getPrefValue(prefString);

		prefElement[prefAttribute] = prefValue;
		prefElement.setAttribute(prefAttribute, prefValue);
	}
}


/**
 * Rg[̒l pref ɕۑ
 */
function saveSettings(){
	var prefElements = document.getElementsByAttribute("prefelement", "true");
	
	for(var i=0; i<prefElements.length; i++){
		var prefElement = prefElements[i];
		var prefString = prefElement.getAttribute("prefstring");
		var prefAttribute = prefElement.getAttribute("prefattribute");

		var prefValue = prefElement[prefAttribute];
		var prefLastValue = Bbs2chGlobal.getPrefValue(prefString);
		var prefType = typeof(Bbs2chGlobal.getDefaultValue(prefString));

		if(prefType == "number"){
			prefValue = parseInt(prefValue);
			if(isNaN(prefValue)) prefValue = prefLastValue;
		}

		if(prefValue != prefLastValue)
			Bbs2chGlobal.setPrefValue(prefString, prefValue);
	}
}


/**
 * XLIj[Xg̏
 */
function initThreadSkinList(){
	var lstThreadSkinList = document.getElementById("lstThreadSkinList");
	
		// K̃XL
	lstThreadSkinList.appendItem("(Default)",
			Bbs2chGlobal.getDefaultValue("fls.bbs2chreader.thread_skin_uri"));

	var skinDir = Bbs2chGlobal.getDataDir();
	skinDir.appendRelativePath("skin");
	try{
		if(!skinDir.exists()) skinDir.create(skinDir.DIRECTORY_TYPE, 0777);
	}catch(ex){
		return;
	}
	
	var entries = skinDir.directoryEntries;
	while(entries.hasMoreElements()){
		var entry = entries.getNext().QueryInterface(Components.interfaces.nsILocalFile);
		var fileURL = Bbs2chGlobal.ioService.newFileURI(entry).QueryInterface(Components.interfaces.nsIFileURL);
		if(entry.isDirectory()){
			lstThreadSkinList.appendItem(entry.leafName, fileURL.spec);
		}
	}

		// MenuList  Value Ɠ MenuItem I
	var menuItems = lstThreadSkinList.menupopup.childNodes;
	for(var i=0; i<menuItems.length; i++){
		if(menuItems[i].getAttribute("value") == lstThreadSkinList.value){
			lstThreadSkinList.selectedIndex = i;
		}
	}
		//  MenuItem ꍇ́AftHgI
	if(lstThreadSkinList.selectedIndex == -1)
			lstThreadSkinList.selectedIndex = 0;
}


function doEnable(aElementID, aProperty, aTargetID){
	var enabled = document.getElementById(aElementID)[aProperty];
	document.getElementById(aTargetID).disabled = !enabled;
}


function openSkinDir(){
	var skinDir = Bbs2chGlobal.getDataDir();
	skinDir.appendRelativePath("skin");
	try{
		skinDir.launch();
	}catch(ex){}
}


function openAboneManager(){
	var aboneManagerURL = "chrome://bbs2chreader/content/settings/abone-manager.xul";
	window.openDialog(aboneManagerURL, "_blank", "chrome, modal, resizable");
}