/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is bbs2chreader.
 *
 * The Initial Developer of the Original Code is
 * flyson.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    flyson <flyson at users.sourceforge.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */




var lstNgNames;
var lstNgAddrs;
var lstNgId;
var lstNgWords;
var abone;


function startup(){
	lstNgNames = document.getElementById("lstNgNames");
	lstNgAddrs = document.getElementById("lstNgAddrs");
	lstNgId = document.getElementById("lstNgId");
	lstNgWords = document.getElementById("lstNgWords");

	abone = new Bbs2chAbone();
	
	initList(abone.ngNames, lstNgNames);
	initList(abone.ngAddrs, lstNgAddrs);
	initList(abone.ngId, lstNgId);
	initList(abone.ngWords, lstNgWords);
}


function accept(){
	abone.save();
}


function initList(aNgArray, aListBox){
	for(var i=0; i<aNgArray.length; i++){
		var ngWord = aNgArray[i];
		if(!ngWord) continue;
		aListBox.appendItem(ngWord, ngWord);
	}
}

function appendNgWord(aNgType){
	var ngWord;
	var ngListBox;

	switch(aNgType){
		case "names":
			ngWord = document.getElementById("txtNgNames").value;
			ngListBox = lstNgNames;
			break;
		case "addrs":
			ngWord = document.getElementById("txtNgAddrs").value;
			ngListBox = lstNgAddrs;
			break;
		case "id":
			ngWord = document.getElementById("txtNgId").value;
			ngListBox = lstNgId;
			break;
		case "words":
			ngWord = document.getElementById("txtNgWords").value;
			ngListBox = lstNgWords;
			break;
	}
	if(!ngWord) return;

	abone.appendNgWord(aNgType, ngWord);
	ngListBox.appendItem(ngWord, ngWord);
}

function removeNgWord(aNgType){
	var ngWord;
	var ngListBox;

	switch(aNgType){
		case "names":
			ngListBox = lstNgNames;
			break;
		case "addrs":
			ngListBox = lstNgAddrs;
			break;
		case "id":
			ngListBox = lstNgId;
			break;
		case "words":
			ngListBox = lstNgWords;
			break;
	}
	
	if(ngListBox.selectedIndex == -1) return;
	
	ngWord = ngListBox.selectedItem.value;
	ngListBox.removeItemAt(ngListBox.selectedIndex);
	abone.removeNgWord(aNgType, ngWord);
}