/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is bbs2chreader.
 *
 * The Initial Developer of the Original Code is
 * flyson.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    flyson <flyson at users.sourceforge.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */




/**
 *
 * >>1 ̂悤ȃNɃ}EX悹ƂɁAX|bvAbvXNvg
 *
 */
 
var resPopup = {

	/**
	 * 
	 */
	init: function(){
		document.addEventListener("mouseover", resPopup.doMouseOver, false);
		document.addEventListener("mouseout", resPopup.doMouseOut, false);
	},

	/**
	 * XNɃ}EX悹Ƃ̃Cxg
	 *
	 * @param aEvent event
	 */
	doMouseOver: function(aEvent){
		var targetNode = aEvent.target;
		var relatedNode = aEvent.relatedTarget;

		if(targetNode.className != "resPointer") return;
		if(relatedNode.className == "res-popup") return;

		
		if(targetNode.text.match(/>>?(\d{1,3})-(\d{1,3})/)){
			resPopup.showPopup(aEvent, targetNode, RegExp.$1, RegExp.$2);
		}else if(targetNode.text.match(/>>?(\d{1,3})/)){
			resPopup.showPopup(aEvent, targetNode, RegExp.$1, 0);
		}
	},


	/**
	 * XN}EXoƂ̃Cxg
	 *
	 * @param aEvent event
	 */
	doMouseOut: function(aEvent){
		var targetNode = aEvent.target;
		if(targetNode.className != "resPointer") return;
	},


	/**
	 * |bvAbv\
	 *
	 * @param aEvent event
	 * @param aTargetNode node Nm[h
	 * @param aStart number X̎n
	 * @param aEnd number X̏I
	 */
	showPopup: function(aEvent, aTargetNode, aStart, aEnd){
		var resNode = document.getElementById("res" + aStart);
		if(!resNode) return;

		var content = document.createDocumentFragment();
		if(aStart < aEnd){ // |bvAbv
			if(aStart < 1) aStart = 1;
			if(aEnd > 1000) aStart = 1000;
			for(var i = aStart; i<=aEnd; i++){
				resNode = document.getElementById("res" + i);
				if(!resNode) break;
				content.appendChild(this.getCloneNode(resNode));
			}
		}else{ // ʏ|bvAbv
			content.appendChild(this.getCloneNode(resNode));
		}


		var divResPopup = document.createElement("div");
		divResPopup.className = "res-popup";
		divResPopup.style.position = "absolute";
		divResPopup.style.fontSize = "0.8em";
		divResPopup.style.maxWidth = "50em";
		divResPopup.style.padding = "5px";
		divResPopup.style.backgroundColor = "infobackground";
		divResPopup.style.border = "1px solid WindowFrame";
		var popupPosX = (aEvent.pageX - 12) + "px";
		var popupPosY = (aEvent.pageY - 12) + "px";
		divResPopup.style.left = popupPosX;
		divResPopup.style.top = popupPosY;

		divResPopup.appendChild(content);
		document.body.appendChild(divResPopup);

		
		divResPopup.addEventListener("mouseout", function(aEvent){
			if(aEvent.pageX <= this.offsetLeft ||
						aEvent.pageY <= this.offsetTop ||
						aEvent.pageX >= this.offsetLeft + this.offsetWidth ||
						aEvent.pageY >= this.offsetTop + this.offsetHeight)
				document.body.removeChild(this);
		}, false);
	},


	/**
	 * m[h̃N[𖳖ɂĕԂ
	 *
	 * @param aNode node 擾m[h
	 * @return node N[m[h
	 */
	getCloneNode: function(aNode){
		aNode = aNode.cloneNode(true);
		if(aNode.id) aNode.id = "";
		var elements = aNode.getElementsByTagName("*");
		for(var i=0; i<elements.length; i++){
			if(elements[i].id) elements[i].id = "";
		}		
		return aNode;
	}
}



window.addEventListener("load", resPopup.init, false);