/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is bbs2chreader.
 *
 * The Initial Developer of the Original Code is
 * flyson.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    flyson <flyson at users.sourceforge.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */




/**
 *
 * N悪A摜̏ꍇɃTlC|bvAbvXNvg
 *
 */

var ImagePopup = {
	/**
	 * 
	 */
	init: function(){
			// |bvAbvp̃C̍쐬
		var divImgPopup = document.createElement("div");
		divImgPopup.id = "divImgPopup";
		divImgPopup.style.position = "absolute";
		divImgPopup.style.backgroundColor = "infobackground";
		divImgPopup.style.display = "none";
		document.body.appendChild(divImgPopup);

		document.addEventListener("mouseover", ImagePopup.doMouseOver, false);
		document.addEventListener("mouseout", ImagePopup.doMouseOut, false);
	},


	/**
	 * NɃ}EX悹Ƃ̃Cxg
	 *
	 * @param aEvent event
	 */
	doMouseOver: function(aEvent){
		var targetNode = aEvent.originalTarget;
		if(targetNode.className != "outLink") return;

		var imgSrc = targetNode.href;
		if(!imgSrc.match(/\.jpg|jpeg|png|gif$/i)) return;
	
		var posX = (aEvent.pageX + 10) + "px";
		var posY = targetNode.offsetTop + "px";
		
		ImagePopup.showImagePopup(imgSrc, posX, posY);
	},


	/**
	 * N}EXoƂ̃Cxg
	 *
	 * @param aEvent event
	 */
	doMouseOut: function(aEvent){
		var targetNode = aEvent.originalTarget;

		if(targetNode.className != "outLink") return;
		if(aEvent.relatedTarget && aEvent.relatedTarget.id == "imgImgPopup") return;

		ImagePopup.hideImagePopup();
	},
	

	/**
	 * 摜|bvAbv̕\
	 *
	 * @param aSrc string 摜 URL
	 * @param aPosX number |bvAbv X W
	 * @param aPosY number |bvAbv Y W
	 */
	showImagePopup: function(aSrc, aPosX, aPosY){
		var divImgPopup = document.getElementById("divImgPopup");
		var imgImgPopup = document.createElement("img");

		imgImgPopup.id = "imgImgPopup";
		imgImgPopup.src = aSrc;
		imgImgPopup.addEventListener("mouseout", ImagePopup.hideImagePopup, false);
		imgImgPopup.addEventListener("click", ImagePopup.toggleImageSize, false);
		imgImgPopup.style.width = "120px";
		imgImgPopup.style.border = "1px solid WindowFrame";
		divImgPopup.appendChild(imgImgPopup);

		divImgPopup.style.display = "block";
		divImgPopup.style.left = aPosX;
		divImgPopup.style.top = aPosY;
	},


	/**
	 * 摜|bvAbv̏
	 */
	hideImagePopup: function(){
		var divImgPopup = document.getElementById("divImgPopup");

		while(divImgPopup.hasChildNodes()){
			divImgPopup.removeChild(divImgPopup.firstChild)
		}

		divImgPopup.style.display = "none";
	},

	/**
	 * 摜NbNƂɃTCYύX
	 */
	toggleImageSize: function(aEvent){
		var targetNode = aEvent.originalTarget;
		targetNode.style.width = (targetNode.style.width == "") ? "120px" : "";
	}
}




window.addEventListener("load", ImagePopup.init, false);