/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is bbs2chreader.
 *
 * The Initial Developer of the Original Code is
 * flyson.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    flyson <flyson at users.sourceforge.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */




/**
 * RDF ǡ֥
 * @constructor
 */
function Bbs2chRDF(){}


Bbs2chRDF.prototype = {


// ********** ********* ץѥƥ ********** **********


	/**
	 * RDFǡ
	 * @return nsIRDFDataSource
	 */
	get ds(){
		return this._ds;
	},


	/**
	 * nsIRDFService
	 * @return nsIRDFService
	 */
	get rdf(){
		if(!this._rdf){
			this._rdf = Components.classes['@mozilla.org/rdf/rdf-service;1']
						.getService(Components.interfaces.nsIRDFService);
		}
		return this._rdf;
	},
	_rdf: null,


	/**
	 * nsIRDFContainerUtils
	 * @return nsIRDFContainerUtils
	 */
	get rdfCU(){
		if(!this._rdfCU){
			this._rdfCU = Components.classes['@mozilla.org/rdf/container-utils;1']
								.getService(Components.interfaces.nsIRDFContainerUtils);
		}
		return this._rdfCU;
	},
	_rdfCU: null,



// ********** ********* ᥽å ********** **********


	init: function(){
		this._ds = Components.classes["@mozilla.org/rdf/datasource;1?name=in-memory-datasource"]
						.createInstance(Components.interfaces.nsIRDFDataSource);
	},


	/**
	 * ¸ nsIRDFDataSource Ȥäƽ
	 * @param aDataSource nsIRDFDataSource RDF ǡ
	 */
	initWithDataSource: function(aDataSource){
		 if(!(aDataSource instanceof Components.interfaces.nsIRDFDataSource))
				throw Components.results.NS_ERROR_INVALID_ARG;
		this._ds = aDataSource;
	},


	/**
	 * ꤷ ID  nsIRDFResource ֤
	 * @param aResourceID string ꥽ ID
	 * @return nsIRDFResource
	 */
	GetResource: function(aResourceID){
		return this.rdf.GetResource(aResourceID);
	},


	/**
	 * ꤷͤ nsIRDFLiteral ֤
	 * @param aValue string 
	 * @return nsIRDFLiteral
	 */
	GetLiteral: function(aValue){
		return this.rdf.GetLiteral(aValue);
	},


	/**
	 * ꤷͤ nsIRDFInt ֤
	 * @param aValue number 
	 * @return nsIRDFInt
	 */
	GetIntLiteral: function(aValue){
		return this.rdf.GetIntLiteral(aValue);
	},


	/**
	 * ꤷͤ nsIRDFDate ֤
	 * @param aValue number 
	 * @return nsIRDFDate
	 */
	GetDateLiteral: function(aValue){
		return this.rdf.GetDateLiteral(aValue);
	},


	/**
	 * nsIRDFLiteral Υץѥƥͤꤹ
	 * @param aSourceOrID variable ꥽ޤϥ꥽ID
	 * @param aProperty string ץѥƥ̾
	 * @param aValue string ץѥƥ
	 */
	setLiteralProp: function(aSourceOrID, aProperty, aValue){
		var source = (typeof(aSourceOrID)=="string") ?
								this.GetResource(aSourceOrID) : aSourceOrID;
		var property = this.GetResource(aProperty);
		var newValue = this.GetLiteral(aValue);
		
		this.ds.Assert(source, property, newValue, true);
	},


	/**
	 * nsIRDFInt Υץѥƥͤꤹ
	 * @param aSourceOrID variable ꥽ޤϥ꥽ID
	 * @param aProperty string ץѥƥ̾
	 * @param aValue number ץѥƥ
	 */
	setIntProp: function(aSourceID, aProperty, aValue){
		var source = (typeof(aSourceOrID)=="string") ?
								this.GetResource(aSourceOrID) : aSourceOrID;
		var property = this.GetResource(aProperty);
		var newValue = this.GetIntLiteral(aValue);

		this.ds.Assert(source, property, newValue, true);
	},


	/**
	 * nsIRDFDate Υץѥƥͤꤹ
	 * @param aSourceOrID variable ꥽ޤϥ꥽ID
	 * @param aProperty string ץѥƥ̾
	 * @param aValue number ץѥƥ
	 */
	setDateProp: function(aSourceID, aProperty, aValue){
		var source = (typeof(aSourceOrID)=="string") ?
								this.GetResource(aSourceOrID) : aSourceOrID;
		var property = this.GetResource(aProperty);
		var newValue = this.GetDateLiteral(aValue);

		this.ds.Assert(source, property, newValue, true);
	},


	/**
	 * nsIRDFLiteral Υץѥƥ֤ͤ
	 * @param aSourceID string ꥽ ID
	 * @param aProperty string ץѥƥ̾
	 * @return nsIRDFLiteral
	 */
	getLiteralProp: function(aSourceID, aProperty){
		var target = this.ds.GetTarget(this.GetResource(aSourceID),
								this.GetResource(aProperty), true);
		if(target) return target.QueryInterface(Components.interfaces.nsIRDFLiteral);
		return null;
	},


	/**
	 * nsIRDFInt Υץѥƥ֤ͤ
	 * @param aSourceID string ꥽ ID
	 * @param aProperty string ץѥƥ̾
	 * @return nsIRDFInt
	 */
	getIntProp: function(aSourceID, aProperty){
		var target = this.ds.GetTarget(this.GetResource(aSourceID),
								this.GetResource(aProperty), true);
		if(target) return target.QueryInterface(Components.interfaces.nsIRDFInt);
		return null;
	},


	/**
	 * nsIRDFDate Υץѥƥ֤ͤ
	 * @param aSourceID string ꥽ ID
	 * @param aProperty string ץѥƥ̾
	 * @return nsIRDFDate
	 */
	getDateProp: function(aSourceID, aProperty){
		var target = this.ds.GetTarget(this.GetResource(aSourceID),
								this.GetResource(aProperty), true);
		if(target) return target.QueryInterface(Components.interfaces.nsIRDFDate);
		return null;
	},


	/**
	 * ƥʤ
	 *
	 * @param aSourceID string 륳ƥʤ ID
	 * @return nsIRDFContainer
	 */
	MakeSeq: function(aSourceID){
		return this.rdfCU.MakeSeq(this.ds, this.GetResource(aSourceID));
	},


	/**
	 * ƥʤ֤
	 * ꤷ ID Υƥʤ̵Ͽ
	 *
	 * @param aSourceID string ƥʤ ID
	 * @return nsIRDFContainer
	 */	
	GetContainer: function(aSourceID){
		var rdfc = Components.classes["@mozilla.org/rdf/container;1"]
							.createInstance(Components.interfaces.nsIRDFContainer);
		try{
			rdfc.Init(this.ds, this.GetResource(aSourceID));
		}catch(ex){
			return this.MakeSeq(aSourceID);
		}
		return rdfc;
	},


	/**
	 * ƥʤƤ
	 *
	 * @param aSourceID string ƥʤ ID
	 */	
	clearContainer: function(aSourceID){
		var container = this.GetContainer(aSourceID);
		while(container.GetCount()){
			container.RemoveElementAt(1, true);
		}
	},


	/**
	 * RDF ǡ XML ֤
	 * @param string ɲä XML֤̾Ƭ (ɲäʤʤ null)
	 * @param string ɲä XML֤̾ URI (ɲäʤʤ null)
	 * @return string XML 
	 */
	getXmlSource: function(aNsPrefix, aNsURL){
		var outputStream = {
			data: "",
			write: function(aBuffer, aCount){
				this.data += aBuffer;
				return aCount;
			}
		}
		var serializer = Components.classes["@mozilla.org/rdf/xml-serializer;1"]
								.createInstance(Components.interfaces.nsIRDFXMLSerializer);
		serializer.init(this.ds);
		
		if(aNsPrefix && aNsURL){
			var atomService = Components.classes["@mozilla.org/atom-service;1"]
									.createInstance(Components.interfaces.nsIAtomService);
			var prefix = atomService.getAtom(aNsPrefix);
			serializer.addNameSpace(prefix, aNsURL);
		}

		serializer.QueryInterface(Components.interfaces.nsIRDFXMLSource)
						.Serialize(outputStream);
		return(outputStream.data);
	}
}