/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is bbs2chreader.
 *
 * The Initial Developer of the Original Code is
 * flyson.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    flyson <flyson at users.sourceforge.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */




var threadURL;
var boardURL;
var bbsCgiURL;
var idxContent = "";
var type;

var txtResponse;
var httpReq;


function startup(){
	txtResponse = document.getElementById("txtResponse");

	if(!("arguments" in window)){
		alert("NOT ARGUMENTS");
		window.close();
		return;
	}

	var threadURLSpec = window.arguments[0];
	threadURLSpec = threadURLSpec.replace(/^bbs2ch:post:/, "");

	try{
		threadURL = Bbs2chGlobal.ioService.newURI(threadURLSpec, null, null)
							.QueryInterface(Components.interfaces.nsIURL);
	}catch(ex){
			// ǧǤʤ URL
		alert("BAD URL");
		window.close();
		return;
	}

		// ĤΥפå
	type = Bbs2chGlobal.getBoardType(threadURL.spec);

		// ĤΥפTYPE_PAGE Ǥ⡢
		// URL  /test/read.cgi/ ޤǤ 2chߴȤߤʤ
	if(type == Bbs2chGlobal.TYPE_PAGE &&
		threadURL.spec.indexOf("/test/read.cgi/") != -1)
			type = Bbs2chGlobal.TYPE_2CH;


	switch(type){
		case Bbs2chGlobal.TYPE_JBBS:
			alert("JBBS NOT SUPPORTED");
			window.close();
			return;
		case Bbs2chGlobal.TYPE_MACHI:
			alert("MACHI-BBS NOT SUPPORTED");
			window.close();
			return;
		case Bbs2chGlobal.TYPE_PAGE:
			alert("BAD URL");
			window.close();
			return;
	}


		// åɤ URL
	var boardURLSpec = threadURL.resolve("../");
	boardURLSpec = boardURLSpec.replace("/test/read.cgi/", "/");

	boardURL = Bbs2chGlobal.ioService.newURI(boardURLSpec, null, null)
							.QueryInterface(Components.interfaces.nsIURL);

		// bbs.cgi  URL
	var bbsCgiURLSpec = boardURL.resolve("../test/bbs.cgi");
	bbsCgiURL = Bbs2chGlobal.ioService.newURI(bbsCgiURLSpec, null, null)
							.QueryInterface(Components.interfaces.nsIURL);


		// ǥ쥯ȥ .idx ե
	var datID = (threadURL.spec.match(/\/(\d{9,10})/)) ? RegExp.$1 : "";
	var idxFile = Bbs2chGlobal.createLogFile(boardURL.resolve(datID + ".idx"));
		// .idx ¸ߤʤȤ̤ɤȤߤʤ
	if(!idxFile.exists()){
		alert("Unsubscribed Thread");
		window.close();
		return;
	}
	idxContent = Bbs2chGlobal.fromSJIS(Bbs2chGlobal.readFile(idxFile.path));


		// åɥȥɽ
	var wizPostWizard = document.getElementById("wizPostWizard");
	wizPostWizard.setAttribute("title", "POST: " + getTitle() + Bbs2chGlobal.SUB_TITLE);
	document.getElementById("lblThreadTitle").value = getTitle();

	checkBeLogin();
}


/**
 * 񤭹
 */
function post(){
	txtResponse.value = "";
	document.getElementById("btnRePost").disabled = true;

	var name = document.getElementById("txtName").value;
	var mail = document.getElementById("txtMail").value;
	var message = document.getElementById("txtMsg").value;

	
		// DAT ID
	threadURL.spec.match(/\/(\d{9,10})/);
	var datID = RegExp.$1;
		// ƥ
	boardURL.spec.match(/\/([^\/]+)\/?$/);
	var category = RegExp.$1;


		// POST ǡ
	var postSubmit = Bbs2chGlobal.fromEUC("񤭹", "EUC-JP");
		postSubmit = "submit=" + escapeFromBoardType(postSubmit);

	var postBbs  = "bbs="  + category;
	var postKey  = "key="  + datID;
	var postTime = "time=" + getLastModified();

	var postMsg  = "MESSAGE=" + escapeFromBoardType(message);
	var postName = "FROM=" + escapeFromBoardType(name);
	var postMail = "mail=" + escapeFromBoardType(mail);


	var postData = new Array(postSubmit, postBbs, postKey, postTime,
								postMsg, postName, postMail).join("&");

	httpReq = new Bbs2chHttpRequest(bbsCgiURL.spec, postListener, threadURL.spec);
	httpReq.post(postData);
}


/**
 * ĤΥפ˹碌ʸ URL 
 * @param aString string פʸ
 * @return string URL פ줿ʸ
 */
function escapeFromBoardType(aString){
	var textToSubURI = Components.classes["@mozilla.org/intl/texttosuburi;1"]
							.getService(Components.interfaces.nsITextToSubURI);

	switch(type){
		case Bbs2chGlobal.TYPE_2CH:
			return textToSubURI.ConvertAndEscape("Shift_JIS", aString);
		case Bbs2chGlobal.TYPE_BE2CH:
			return textToSubURI.ConvertAndEscape("EUC-JP", aString);
	}
	return aString;
}


/**
 * post Ѥ Bbs2chHttpRequestListener
 */
var postListener = {
	onHttpStart: function(){
		txtResponse.value = Bbs2chGlobal.fromEUC("񤭹") + "\n\n";
	},

	onHttpStop: function(aResponseText, aStatus){
		var response = Bbs2chGlobal.fromType(aResponseText, type);
		response = response;
		txtResponse.value += htmlToText(response) + "\n";
		
		postCheck(response);
	},

	onHttpDataAvailable: function(aAvailableData, aStatus){
	},

	onHttpError: function(aErrorCode){
		var errorMessage = "";
		switch(aErrorCode){
			case this.ERROR_BAD_URL:
				errorMessage = "BAD URL";
				break;
			case this.ERROR_NOT_AVAILABLE:
				errorMessage = "NOT AVAILABLE";
				break;
			case this.ERROR_FAILURE:
				errorMessage = "FAILURE";
				break;
		}
	
		txtResponse.value += "\n\nERROR: " + errorMessage + "\n\n";
	}
}


/**
 * 񤭹ߤǧ
 * @param aResponse string Ф֤쥹ݥ󥹥ƥ
 */
function postCheck(aResponse){
	const POST_SUCCESS1 = Bbs2chGlobal.fromEUC("񤭤ߤޤ");
	const POST_SUCCESS2 = Bbs2chGlobal.fromEUC("񤭹ߤޤ");
	const POST_SUCCESS3 = Bbs2chGlobal.fromEUC("񤭹߽λ");
	const POST_SUCCESS4 = Bbs2chGlobal.fromEUC("񤭤ߤޤ");
	const POST_OCHA = Bbs2chGlobal.fromEUC("Ǥߤޤ礦");
	const POST_COOKIE = Bbs2chGlobal.fromEUC("åǧ");
	const POST_ERROR = Bbs2chGlobal.fromEUC("ţңңϣ");

	if(aResponse.indexOf(POST_SUCCESS1) != -1 ||
			aResponse.indexOf(POST_SUCCESS2) != -1 ||
			aResponse.indexOf(POST_SUCCESS3) != -1 ||
			aResponse.indexOf(POST_SUCCESS4) != -1){
		alert(POST_SUCCESS1);
		reloadThreadPage();
		window.close();
	}else if(aResponse.indexOf(POST_COOKIE) != -1){
		alert(Bbs2chGlobal.fromEUC("쥹ݥ󥹤ǧơƽ񤭹ߤԤäƤ"));
		document.getElementById("btnRePost").disabled = false;
	}else if(aResponse.indexOf(POST_ERROR) != -1){
		alert(Bbs2chGlobal.fromEUC("񤭹˥顼ȯޤ"));
	}
}


/**
 * եΥå
 */
function formCheck(){
	var postMsg  = document.getElementById("txtMsg").value;
	if(!postMsg){
		alert(Bbs2chGlobal.fromEUC("ʸ̤"));
		return false;
	}
	return true;
}


/**
 * ץӥ塼κ
 */
function preview(){
	var bwrPreview = document.getElementById("bwrPreview");
	var template = Bbs2chGlobal.readLocalURI("chrome://bbs2chreader/content/res/post-preview.txt");
	template = Bbs2chGlobal.fromSJIS(template);

	var postName = document.getElementById("txtName").value;
	var postMail = document.getElementById("txtMail").value;
	var postMsg  = document.getElementById("txtMsg").value;

	template = template.replace(/%NAME%/m, postName);
	template = template.replace(/%MAIL%/m, postMail);

	var nowDate = new Date();
	var postDate = "0" + (nowDate.getYear() % 100) + "/";
	postDate += ((nowDate.getMonth() < 9)? "0" : "") + (nowDate.getMonth() + 1) + "/";
	postDate += ((nowDate.getDate() < 10)? "0" : "") + nowDate.getDate() + " ";
	postDate += ((nowDate.getHours() < 10)? "0" : "") + nowDate.getHours() + ":";
	postDate += ((nowDate.getMinutes() < 10)? "0" : "") + nowDate.getMinutes();
	template = template.replace(/%DATE%/m, postDate);
	
	postMsg = postMsg.replace(/</gm, "&lt;").replace(/>/gm, "&gt;");
	postMsg = postMsg.replace(/\n/gm, "<br>");
	template = template.replace(/%MESSAGE%/m, postMsg);


	bwrPreview.contentDocument.open();
	bwrPreview.contentDocument.write(template);
	bwrPreview.contentDocument.close();
}


/**
 * åɤΥȥ֤
 * @return string
 */
function getTitle(){
	var title = idxContent.match(/^title=(.+)/m) ? RegExp.$1 : threadURL.spec;
	return title;
}


/**
 * åɤκǽ֤
 * @return string
 */
function getLastModified(){
	var lastModified = idxContent.match(/^lastModified=(.+)/m) ? RegExp.$1 : "";
	return Math.ceil(new Date(lastModified).getTime() / 1000);
}


/**
 * HTML ƥȤѴ
 * @param aHTMLSource string Ѵ HTML
 * @return string Ѵ줿ƥ
 */
function htmlToText(aHTMLSource){
	var formatConverter = Components.classes["@mozilla.org/widget/htmlformatconverter;1"]
								.createInstance(Components.interfaces.nsIFormatConverter);
	var fromStr = Components.classes["@mozilla.org/supports-string;1"]
								.createInstance(Components.interfaces.nsISupportsString);
	fromStr.data = aHTMLSource;
	var toStr = { value: null };

	formatConverter.convert("text/html", fromStr, fromStr.toString().length,
							"text/unicode", toStr, {});
	toStr = toStr.value.QueryInterface(Components.interfaces.nsISupportsString);
	toStr = toStr.toString();
	return toStr;
}


/**
 * åɽΥ
 */
function reloadThreadPage(){
	var threadURLSpec = threadURL.spec;

		// ֥饦ɥ
	var windowMediator = Components.classes["@mozilla.org/appshell/window-mediator;1"]
							.getService(Components.interfaces.nsIWindowMediator);
	var browserWinEnu = windowMediator.getEnumerator("navigator:browser");

	while(browserWinEnu.hasMoreElements()){
		var browserWin = browserWinEnu.getNext();
		if(!("gBrowser" in browserWin)) continue;

		var browserContent = browserWin.gBrowser;
			// ֥饦Υ
		for(var i = 0; i < browserContent.mPanelContainer.childNodes.length; i++){
			var tabURISpec = browserContent.getBrowserAtIndex(i).currentURI.spec;
				// URL Ʊʤ
			if(tabURISpec.indexOf(threadURLSpec) != -1)
				browserContent.getBrowserAtIndex(i).reload();
		}
	}
}


/**
 * Be@2ch åܥå
 */
function checkBeLogin(){
	var chkBeLogin = document.getElementById("chkBeLogin");
	chkBeLogin.checked = Bbs2chBeLogin.logined;
}


/**
 * Be@2ch åܥåѹ줿Ȥ˸ƤФ
 */
function toggleBeLogin(){
	var chkBeLogin = document.getElementById("chkBeLogin");

	if(chkBeLogin.checked){
		Bbs2chBeLogin.openLoginDialog();
	}else{
		Bbs2chBeLogin.logout();
	}
	
	chkBeLogin.checked = Bbs2chBeLogin.logined;
}