/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is bbs2chreader.
 *
 * The Initial Developer of the Original Code is
 * flyson.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    flyson <flyson at users.sourceforge.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */




/**
 * bbs2chreader ̤ǻȤؿνޤ
 */
var Bbs2chGlobal = {


// ********** *********  ********** **********


	/**
	 * ꥯȻ User Agent ̾
	 * @return string
	 */
	USER_AGENT: "Monazilla/1.00 (bbs2chreader/0.2.0)",


	/**
	 * ڡΥȥʤɤղä륵֥ȥ
	 * @return string
	 */
	SUB_TITLE: " [bbs2chreader]",


	/**
	 * bbs2chreader  XML ̾
	 * @return string
	 */
	NS_BBS2CH: "http://bbs2ch.sourceforge.jp/#",


	/**
	 * ǡ¸ǥ쥯ȥ̾
	 * @return string
	 */
	DATA_DIR_NAME: "bbs2chreader",


	/**
	 * ¸ǥ쥯ȥ̾
	 * @return string
	 */
	LOGS_DIR_NAME: "logs",


	/**
	 * 2ch  BBS
	 * @return string
	 */
	TYPE_2CH: "type-2ch",


	/**
	 * Be@2ch BBS
	 * @return string
	 */
	TYPE_BE2CH: "type-be2ch",


	/**
	 *  JBBS
	 * @return string
	 */
	TYPE_JBBS: "type-jbbs",


	/**
	 * ޤBBS
	 * @return string
	 */
	TYPE_MACHI: "type-machi",


	/**
	 * ̾ڡ
	 * @return string
	 */
	TYPE_PAGE: "type-page",


// ********** ********* ץѥƥ ********** **********


	/**
	 * nsIIOService ֤
	 * @return nsIIOService
	 */
	get ioService(){
		if(!this._ioService){
			this._ioService = Components.classes["@mozilla.org/network/io-service;1"]
									.getService(Components.interfaces.nsIIOService);
		}
		return this._ioService;
	},
	_ioService: null,


	/**
	 * nsIScriptableUnicodeConverter ֤
	 * @return nsIScriptableUnicodeConverter
	 */
	get unicodeConverter(){
		if(!this._unicodeConverter){
			this._unicodeConverter = Components.classes["@mozilla.org/intl/scriptableunicodeconverter"]
						.getService(Components.interfaces.nsIScriptableUnicodeConverter);
		}
		return this._unicodeConverter;
	},
	_unicodeConverter: null,


	/**
	 * nsIPrefBranch ֤
	 * @return nsIPrefBranch
	 */
	get prefBranch(){
		if(!this._prefBranch){
			this._prefBranch = Components.classes["@mozilla.org/preferences-service;1"]
									.getService(Components.interfaces.nsIPrefBranch);
		}
		return this._prefBranch;
	},
	_prefBranch: null,


	/**
	 * getBoardType Ѥ㳰Ū URL Υꥹ( 2ch Ĥʤ URL)
	 * @return array
	 */
	get exUrlHash(){
		if(!this._exUrlHash){
			this._exUrlHash = new Array();
				// դĤʸ
			this._exUrlHash["http://info.2ch.net/search/"] = this.TYPE_PAGE;
				// ɥ饤
			this._exUrlHash["http://info.2ch.net/guide/adv.html"] = this.TYPE_PAGE;		
				// ͤ᡼ޥ
			this._exUrlHash["http://info.2ch.net/mag.html"] = this.TYPE_PAGE;
				// ͤwiki
			this._exUrlHash["http://info.2ch.net/wiki/"] = this.TYPE_PAGE;
				// ¶headline
			this._exUrlHash["http://headline.2ch.net/bbylive/"] = this.TYPE_PAGE;
		}
		return this._exUrlHash;
	},
	_exUrlHash: null,


// ********** ********* ᥽å ********** **********


	/**
	 * ǡ¸ǥ쥯ȥ nsILocalFile ֤
	 * @return nsILocalFile
	 */
	getDataDir: function(){
		var dataDir;
			// ǡǥ쥯ȥ
		if(this.getPrefValue("fls.bbs2chreader.appoint_data_dir")){
			try{
				dataDir = this.createLocalFile(this.getPrefValue("fls.bbs2chreader.data_dir"));
				if(dataDir.leafName!=this.DATA_DIR_NAME)
					dataDir.appendRelativePath(this.DATA_DIR_NAME);
				return dataDir;
			}catch(ex){}
		}
			// ꤷƤʤȤϥץեǥ쥯ȥ
		var dirService = Components.classes["@mozilla.org/file/directory_service;1"]
								.getService(Components.interfaces.nsIProperties);
		dataDir = dirService.get("ProfD", Components.interfaces.nsILocalFile);
		dataDir.appendRelativePath(this.DATA_DIR_NAME);

		return dataDir;
	},


	/**
	 * ¸ǥ쥯ȥ nsILocalFile ֤
	 * @return nsILocalFile
	 */
	getLogsDir: function(){
		var logsDir = this.getDataDir();
		logsDir.appendRelativePath(this.LOGS_DIR_NAME);
		return logsDir;
	},


	/**
	 * եѥ nsILocalFile 
	 * @param aFilePath string եΥѥ
	 * @return nsILocalFile
	 */
	createLocalFile: function(aFilePath){
		if(!this._localFileConstructor){
			this._localFileConstructor = new Components.Constructor(
						"@mozilla.org/file/local;1", "nsILocalFile", "initWithPath");
		}
		return new this._localFileConstructor(aFilePath);
	},
	_localFileConstructor: null,


	/**
	 * ¸ǥ쥯ȥʲ URL Υѥɲä nsILocalFile 
	 * 		(e.g. http://www.example.com/hoge/hage.txt ʤ 
	 * 		  ¸ǥ쥯ȥ\www.example.com\hoge\hage.txt)
	 * @param aFilePath string ե URL
	 * @return nsILocalFile
	 */
	createLogFile: function(aURLSpec){
		var saveFile = this.getLogsDir();

		var fromURL = Bbs2chGlobal.ioService.newURI(aURLSpec, null, null);
		fromURL = fromURL.QueryInterface(Components.interfaces.nsIURL);
		
		saveFile.appendRelativePath(fromURL.host);
		
		var pathArray = fromURL.path.split("/");
		for(var i=0; i<pathArray.length; i++){
			if(pathArray[i])
				saveFile.appendRelativePath(pathArray[i]);
		}
		
		return saveFile;
	},


	/**
	 * ƥȥեɤ߹Ƥ֤
	 * @param aFilePath string եѥ
	 * @return string ե
	 */
	readFile: function(aFilePath){
		var fileInputStream = Components.classes["@mozilla.org/network/file-input-stream;1"]
									.createInstance(Components.interfaces.nsIFileInputStream);
		var scriptableInputStream = Components.classes["@mozilla.org/scriptableinputstream;1"]
									.createInstance(Components.interfaces.nsIScriptableInputStream);
		try{
			var tmpFile = this.createLocalFile(aFilePath);
			fileInputStream.init(tmpFile, 0x01, 0666, 0);
			scriptableInputStream.init(fileInputStream);
			
			var fileContent = scriptableInputStream.read(scriptableInputStream.available());
			scriptableInputStream.close();
			fileInputStream.close();			
		}catch(ex){
			return null;
		}
		return fileContent;
	},


	/**
	 * ƥȥեʸ񤭹
	 * @param aFilePath string եѥ
	 * @param aContent string ¸ʸ
	 * @return boolean 
	 */
	writeFile: function(aFilePath, aContent){
		var fileOutputStream = Components.classes['@mozilla.org/network/file-output-stream;1']
									.createInstance(Components.interfaces.nsIFileOutputStream);
		try{
			var tmpFile = this.createLocalFile(aFilePath);
			if(tmpFile.exists()) tmpFile.remove(true);
			tmpFile.create(tmpFile.NORMAL_FILE_TYPE, 0666);
			
			fileOutputStream.init(tmpFile, 0x12, 0666, 0);
			fileOutputStream.write(aContent, aContent.length);
			fileOutputStream.flush();
			fileOutputStream.close();
		}catch(ex){
			return false;
		}
		return true;
	},


	/**
	 * file/jar/chorme Υƥȥեɤ߹Ƥ֤
	 * @param aURISpec string ե URI
	 * @return string ե
	 */
	readLocalURI: function(aURISpec){
		var	localURI = Components.classes["@mozilla.org/network/simple-uri;1"]
							.createInstance(Components.interfaces.nsIURI);
		localURI.spec = aURISpec;
		localURI = this.ioService.getProtocolHandler(localURI.scheme)
										.newURI(localURI.spec, null, null);
		var channel = this.ioService.newChannelFromURI(localURI);
		var stream	= channel.open();
		var scriptableStream = Components.classes['@mozilla.org/scriptableinputstream;1']
									.createInstance(Components.interfaces.nsIScriptableInputStream);
		scriptableStream.init(stream);

		var fileContents = scriptableStream.read(scriptableStream.available());

		scriptableStream.close();
		stream.close();

		return fileContents;
	},


	/**
	 * resource://bbs2ch-skin/ ǥե˥Ǥ褦ˤ
	 */
	setSkinResSubstitution: function(){
		var resPHandler = this.ioService.getProtocolHandler("resource")
							.QueryInterface(Components.interfaces.nsIResProtocolHandler);
		var skinUriSpec = this.getPrefValue("fls.bbs2chreader.thread_skin_uri");
		var skinURI = this.ioService.newURI(skinUriSpec, null, null);

		if(resPHandler.hasSubstitution("bbs2ch-skin") &&
				(resPHandler.getSubstitution("bbs2ch-skin").spec == skinURI.spec)){
			return;
		}

		resPHandler.setSubstitution("bbs2ch-skin", skinURI);
	},


	/**
	 * ʸɤɤ Shift_JIS Ѵ
	 * @param aString string ʸ
	 * @return string Ѵʸ
	 */
	toSJIS: function(aString){
		this.unicodeConverter.charset = "Shift_JIS";
		return this.unicodeConverter.ConvertFromUnicode(aString);
	},


	/**
	 * ʸɤ Shift_JIS ɤѴ
	 * @param aString string ʸ
	 * @return string Ѵʸ
	 */
	fromSJIS: function(aString){
		this.unicodeConverter.charset = "Shift_JIS";
		return this.unicodeConverter.ConvertToUnicode(aString);
	},


	/**
	 * ʸɤɤ EUC-JP Ѵ
	 * @param aString string ʸ
	 * @return string Ѵʸ
	 */
	toEUC: function(aString){
		this.unicodeConverter.charset = "EUC-JP";
		return this.unicodeConverter.ConvertFromUnicode(aString);
	},


	/**
	 * ʸɤ EUC-JP ɤѴ
	 * @param aString string ʸ
	 * @return string Ѵʸ
	 */
	fromEUC: function(aString){
		this.unicodeConverter.charset = "EUC-JP";
		return this.unicodeConverter.ConvertToUnicode(aString);
	},


	/**
	 * ʸɤĤΥפȽ̤ɤѴ
	 * @param aString string ʸ
	 * @param aBoardType number TYPE_XXX
	 * @return string Ѵʸ
	 */
	fromType: function(aString, aBoardType){
		var result = "";
		switch(aBoardType){
			case this.TYPE_2CH:
			case this.TYPE_MACHI:
				result = this.fromSJIS(aString);
				break;
			case this.TYPE_BE2CH:
			case this.TYPE_JBBS:
				result = this.fromEUC(aString);
				break;
		}
		return result;
	},


	/**
	 * ʸɤĤΥפȽ̤Ѵ
	 * @param aString string ʸ
	 * @param aBoardType number TYPE_XXX
	 * @return string Ѵʸ
	 */
	toType: function(aString, aBoardType){
		var result = "";
		switch(aBoardType){
			case this.TYPE_2CH:
			case this.TYPE_MACHI:
				result = this.toSJIS(aString);
				break;
			case this.TYPE_BE2CH:
			case this.TYPE_JBBS:
				result = this.toEUC(aString);
				break;
		}
		return result;
	},


	/**
	 * Preference ͤ
	 * @param aPrefString string ̾
	 * @return variable
	 */
	getPrefValue: function(aPrefString){
		var defaultValue = this.getDefaultValue(aPrefString);
		var result;

		try{
			switch(typeof(defaultValue)){
				case "boolean":
					result = this.prefBranch.getBoolPref(aPrefString);
					break;
				case "number":
					result = this.prefBranch.getIntPref(aPrefString);
					break;
				case "string":
					result = this.prefBranch.getComplexValue(aPrefString,
										Components.interfaces.nsISupportsString).data;
					break;
			}
		}catch(ex){
			result = defaultValue;
		}		
		return result;
	},


	/**
	 * Preference ͤ¸
	 * @param aPrefString string ̾
	 * @return variable
	 */
	setPrefValue: function(aPrefString, aPrefValue){
		var defaultValue = this.getDefaultValue(aPrefString);

		switch(typeof(defaultValue)){
			case "boolean":
				this.prefBranch.setBoolPref(aPrefString, aPrefValue);
				break;
			case "number":
				this.prefBranch.setIntPref(aPrefString, aPrefValue);
				break;
			case "string":
				var supportsString = Components.classes["@mozilla.org/supports-string;1"]
							.createInstance(Components.interfaces.nsISupportsString);
				supportsString.data = aPrefValue;
				this.prefBranch.setComplexValue(aPrefString,
							Components.interfaces.nsISupportsString, supportsString);
				break;
		}
		return;
	},


	/**
	 * Preference εͤ
	 * @param aPrefString string ̾
	 * @return variable
	 */
	getDefaultValue: function(aPrefString){
		switch(aPrefString){
			case "fls.bbs2chreader.enable_browser_contextmenu":
						return true;
			case "fls.bbs2chreader.bypas_http_proxy":
						return false;
			case "fls.bbs2chreader.tab_load_in_foreground":
						return false;
			case "fls.bbs2chreader.appoint_data_dir":
						return false;
			case "fls.bbs2chreader.data_dir":
						return "";

			case "fls.bbs2chreader.bbsmenu_load_url":
						return "http://www.ff.iij4u.or.jp/~ch2/bbsmenu.html";
			case "fls.bbs2chreader.bbsmenu_toggle_open_container":
						return false;
			case "fls.bbs2chreader.bbsmenu_open_action":
						return 0;

			case "fls.bbs2chreader.bbsmenu_historymenu_show":
						return true;
			case "fls.bbs2chreader.bbsmenu_historymenu_board_max":
						return 5;
			case "fls.bbs2chreader.bbsmenu_historymenu_thread_max":
						return 5;

			case "fls.bbs2chreader.board_auto_update":
						return false;
			case "fls.bbs2chreader.board_open_action":
						return 0;

			case "fls.bbs2chreader.thread_skin_uri":
						return "chrome://bbs2chreader/content/res/skin-default/";

			case "fls.bbs2chreader.livebookmarks_append_board_link":
						return true;
			case "fls.bbs2chreader.livebookmarks_min_unread":
						return 1;
		}
		return "";
	},


	/**
	 * url ĤΥפ֤
	 * @param aUrl string Ĥ URL
	 * @return string (TYPE_XXX)
	 */	
	getBoardType: function(aUrl){
			// 㳰Ū URL				
		if(this.exUrlHash.hasOwnProperty(aUrl))
			return this.exUrlHash[aUrl];

			// Be@2ch.net
		if(aUrl.search(/^http:\/\/be\.2ch\.net\/.+/) != -1)
			return this.TYPE_BE2CH;

			// 2ch.net
		if(aUrl.search(/^http:\/\/([^\.]+)\.2ch\.net\/.+/) != -1)
			return this.TYPE_2CH;
			// bbspink.com
		if(aUrl.search(/^http:\/\/([^\.]+)\.bbspink\.com\/.+/) != -1)
			return this.TYPE_2CH;
			// JBBS
		if(aUrl.search(/^http:\/\/jbbs\.livedoor\.jp\/.+/) != -1)
			return this.TYPE_JBBS;
			// ޤBBS
		if(aUrl.search(/^http:\/\/([^\.]+)\.machi\.to\/.+/) != -1)
			return this.TYPE_MACHI;

		return this.TYPE_PAGE;
	},


	/**
	 * åץܡɤʸ򥳥ԡ
	 * @param aString string ԡʸ
	 * @return string ԡʸ
	 */
	setClipBoardString: function(aString){
		var copyString = new String(aString);
		var clipboardHelper = Components.classes["@mozilla.org/widget/clipboardhelper;1"]
									.getService(Components.interfaces.nsIClipboardHelper);
		try{
			clipboardHelper.copyString(copyString);
		}catch(e){
			return null;
		}
		return copyString;
	},


	/**
	 * åץܡɤʸ
	 * @return string åץܡɤʸ
	 */
	getClipBoardString: function(){
		var resultStr = "";
		var clipBoard = Components.classes["@mozilla.org/widget/clipboard;1"]
								.createInstance(Components.interfaces.nsIClipboard);
		var transferable = Components.classes["@mozilla.org/widget/transferable;1"]
								.createInstance(Components.interfaces.nsITransferable);
		transferable.addDataFlavor("text/unicode");
		var transferData = { value:null };
		try{
			clipBoard.getData(transferable, clipBoard.kGlobalClipboard);
			transferable.getTransferData("text/unicode", transferData, {});
			resultStr = transferData.value.QueryInterface(Components.interfaces.nsISupportsString);
		}catch(e){}
		return resultStr;
	},


	/**
	 * ߤΥ֥饦֥(xul:bworser)֤
	 * @return nsIDOMXULElement
	 */
	getContentBrowser: function(){
		var windowMediator = Components.classes["@mozilla.org/appshell/window-mediator;1"]
								.getService(Components.interfaces.nsIWindowMediator);
		var topWindowOfType = windowMediator.getMostRecentWindow("navigator:browser");
		if(topWindowOfType) return topWindowOfType.document.getElementById("content");
		return null;
	},


	/**
	 * ֥饦ɥǻꤷ URI 򳫤
	 * aURISpec ꤷʤäȤ about:blank
	 *
	 * @param aURISpec string ɥǳڡ URI
	 */
	openNewWindow: function(aURISpec){
		if(!aURISpec) aURISpec = "about:blank";
		var browserURL = this.getPrefValue("browser.chromeURL");
		var appShellService = Components.classes["@mozilla.org/appshell/appShellService;1"]
									.getService(Components.interfaces.nsIAppShellService);
		var hiddenWin = appShellService.hiddenDOMWindow;	
		hiddenWin.openDialog(browserURL, "_blank", "chrome,all,dialog=no", aURISpec);
	},


	/**
	 * ֥饦ǻꤷ URI 򳫤
	 * ֥饦ɥ̵ȤϿɥǳ
	 *
	 * @param aURISpec string ڡ URI
	 * @param aReferrer string ե ꤿʤȤ null
	 * @param aAddTab boolean ֤ǳɤ
	 */
	openURI: function(aURISpec, aReferrer, aAddTab){
		var contentBrowser = this.getContentBrowser();
		if(contentBrowser){
			if(aAddTab){
				var newTab = contentBrowser.addTab(aURISpec, aReferrer);
				if(this.getPrefValue("fls.bbs2chreader.tab_load_in_foreground")){
					contentBrowser.selectedTab = newTab; 
				}
			}else{
				contentBrowser.loadURI(aURISpec, aReferrer);
			}
		}else{
			this.openURLNewWin(aURISpec);
		}
	},


	/**
	 * ꤷСʸȸߤ Gecko ΥСӤ
	 * @param aVersion string Сʸ(e.g. "1.8" "1.7.5")
	 * @return number ꤷС 1Ʊʤ 0Ť -1
	 */
	geckoVersionCompare: function(aVersion){
		var httpProtocolHandler = this.ioService.getProtocolHandler("http")
						.QueryInterface(Components.interfaces.nsIHttpProtocolHandler);
		var versionChecker = Components.classes["@mozilla.org/updates/version-checker;1"]
						.getService(Components.interfaces.nsIVersionChecker);

		var geckoVersion = httpProtocolHandler.misc.match(/rv:([0-9.]+)/)[1];
		return versionChecker.compare(aVersion, geckoVersion);
	},


	/**
	 * JavaScript 󥽡ʸɽ
	 * @param aString string ʸ
	 */
	dump: function(aString){
		var aConsoleService = Components.classes["@mozilla.org/consoleservice;1"]
								.getService(Components.interfaces.nsIConsoleService);
		aConsoleService.logStringMessage(aString);
	}
}